/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.raccompat.items;

import com.github.alexmodguy.alexscaves.server.block.ACBlockRegistry;
import com.github.alexmodguy.alexscaves.server.item.HazmatArmorItem;
import com.github.alexmodguy.alexscaves.server.misc.ACAdvancementTriggerRegistry;
import com.github.alexmodguy.alexscaves.server.misc.ACDamageTypes;
import com.github.alexmodguy.alexscaves.server.misc.ACSoundRegistry;
import com.github.alexmodguy.alexscaves.server.misc.ACTagRegistry;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.hurts.sskirillss.raccompat.entities.AcidCloudEntity;
import it.hurts.sskirillss.raccompat.init.EntityRegistry;
import it.hurts.sskirillss.raccompat.init.ItemRegistry;
import it.hurts.sskirillss.raccompat.misc.RACLootCollections;
import it.hurts.sskirillss.relics.api.events.common.FluidCollisionEvent;
import it.hurts.sskirillss.relics.client.models.items.CurioModel;
import it.hurts.sskirillss.relics.client.models.items.SidedCurioModel;
import it.hurts.sskirillss.relics.items.relics.base.IRelicItem;
import it.hurts.sskirillss.relics.items.relics.base.IRenderableCurio;
import it.hurts.sskirillss.relics.items.relics.base.RelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.StyleData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.TooltipData;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import it.hurts.sskirillss.relics.utils.NBTUtils;
import java.util.List;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.client.ICurioRenderer;

public class AcidWalkerItem
extends RelicItem
implements IRenderableCurio {
    public static final String TAG_DURATION = "duration";

    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder((String)"walking").stat(StatData.builder((String)TAG_DURATION).initialValue(7.0, 15.0).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.1).formatValue(value -> (int)MathUtils.round((double)value, (int)1)).build()).build()).build()).leveling(new LevelingData(100, 10, 200)).style(StyleData.builder().tooltip(TooltipData.builder().borderTop(-14138092).borderBottom(-15064553).textured(true).build()).build()).loot(LootData.builder().entry(RACLootCollections.TOXIC).build()).build();
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slot, boolean isSelected) {
        int duration = NBTUtils.getInt((ItemStack)stack, (String)TAG_DURATION, (int)0);
        double maxDuration = this.getAbilityValue(stack, "walking", TAG_DURATION);
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (duration > 0) {
            if ((double)duration >= maxDuration && player.f_19797_ % 3 == 0 && level.m_45976_(AcidCloudEntity.class, player.m_20191_()).isEmpty()) {
                AcidCloudEntity cloud = new AcidCloudEntity((EntityType<? extends AcidCloudEntity>)((EntityType)EntityRegistry.ACID_CLOUD.get()), level);
                cloud.m_146884_(player.m_20182_());
                cloud.m_5602_((Entity)player);
                level.m_7967_((Entity)cloud);
            }
            if (player.f_19797_ % 20 == 0 && !level.m_6425_(player.m_20183_().m_7495_()).m_192917_((Fluid)((LiquidBlock)ACBlockRegistry.ACID.get()).getFluid()) && !level.m_6425_(player.m_20183_()).m_192917_((Fluid)((LiquidBlock)ACBlockRegistry.ACID.get()).getFluid())) {
                NBTUtils.setInt((ItemStack)stack, (String)TAG_DURATION, (int)(--duration));
            }
        }
    }

    public static void triggerAcidEffect(LivingEntity entity) {
        if (entity.m_6095_().m_204039_(ACTagRegistry.RESISTS_ACID)) {
            return;
        }
        boolean armor = false;
        boolean hurtSound = false;
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            Player player;
            ItemStack stack;
            if (!slot.m_254934_() || !(stack = entity.m_6844_(slot)).m_41763_() || stack.m_41720_() instanceof HazmatArmorItem) continue;
            armor = true;
            if (!(entity.m_217043_().m_188501_() < 0.05f) || entity instanceof Player && (player = (Player)entity).m_7500_()) continue;
            stack.m_41622_(1, entity, e -> e.m_21166_(slot));
        }
        float dmgMultiplier = 1.0f - (float)HazmatArmorItem.getWornAmount((LivingEntity)entity) / 4.0f;
        if (armor) {
            ACAdvancementTriggerRegistry.ENTER_ACID_WITH_ARMOR.triggerForEntity((Entity)entity);
        }
        if (entity.m_217043_().m_188501_() < dmgMultiplier) {
            float golemAddition = entity.m_6095_().m_204039_(ACTagRegistry.WEAK_TO_ACID) ? 10.0f : 0.0f;
            hurtSound = entity.m_6469_(ACDamageTypes.causeAcidDamage((RegistryAccess)entity.m_20193_().m_9598_()), dmgMultiplier * (float)(armor ? 0.01 : 1.0) + golemAddition);
        }
        if (hurtSound) {
            entity.m_216990_((SoundEvent)ACSoundRegistry.ACID_BURN.get());
        }
    }

    public boolean onEntityItemUpdate(ItemStack stack, ItemEntity entity) {
        if (entity.f_19797_ % 3 != 0) {
            return false;
        }
        Level level = entity.m_9236_();
        if (level.m_45976_(AcidCloudEntity.class, entity.m_20191_()).isEmpty()) {
            AcidCloudEntity cloud = new AcidCloudEntity((EntityType<? extends AcidCloudEntity>)((EntityType)EntityRegistry.ACID_CLOUD.get()), level);
            cloud.m_146884_(entity.m_20182_());
            level.m_7967_((Entity)cloud);
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public CurioModel getModel(ItemStack stack) {
        return new SidedCurioModel(stack.m_41720_());
    }

    @OnlyIn(value=Dist.CLIENT)
    public <T extends LivingEntity, M extends EntityModel<T>> void render(ItemStack stack, SlotContext slotContext, PoseStack matrixStack, RenderLayerParent<T, M> renderLayerParent, MultiBufferSource renderTypeBuffer, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        CurioModel model = this.getModel(stack);
        if (!(model instanceof SidedCurioModel)) {
            return;
        }
        SidedCurioModel sidedModel = (SidedCurioModel)model;
        sidedModel.setSlot(slotContext.index());
        matrixStack.m_85836_();
        LivingEntity entity = slotContext.entity();
        sidedModel.m_6839_(entity, limbSwing, limbSwingAmount, partialTicks);
        sidedModel.m_6973_(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        ICurioRenderer.followBodyRotations((LivingEntity)entity, (HumanoidModel[])new HumanoidModel[]{sidedModel});
        VertexConsumer vertexconsumer = ItemRenderer.m_115184_((MultiBufferSource)renderTypeBuffer, (RenderType)RenderType.m_110431_((ResourceLocation)this.getTexture(stack)), (boolean)false, (boolean)stack.m_41790_());
        matrixStack.m_252880_(0.0f, 0.0f, -0.025f);
        sidedModel.m_7695_(matrixStack, vertexconsumer, light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        matrixStack.m_85849_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public LayerDefinition constructLayerDefinition() {
        MeshDefinition mesh = HumanoidModel.m_170681_((CubeDeformation)new CubeDeformation(0.4f), (float)0.0f);
        PartDefinition rightLeg = mesh.m_171576_().m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(0, 9).m_171488_(-2.9f, 5.5f, -2.5f, 6.0f, 7.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(0, 1).m_171488_(-2.9f, 5.5f, -2.5f, 6.0f, 1.0f, 6.0f, new CubeDeformation(0.175f)).m_171514_(18, 9).m_171488_(-2.9f, 9.5f, -4.5f, 6.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)1.9f, (float)12.0f, (float)0.5f));
        rightLeg.m_171599_("cube_r1", CubeListBuilder.m_171558_().m_171514_(0, -1).m_171488_(1.5f, 5.5f, 4.4f, 0.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.3927f, (float)0.0f));
        rightLeg.m_171599_("cube_r2", CubeListBuilder.m_171558_().m_171514_(0, -1).m_171480_().m_171488_(-1.325f, 5.5f, 4.2f, 0.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.3927f, (float)0.0f));
        PartDefinition leftLeg = mesh.m_171576_().m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(0, 9).m_171488_(-2.9f, 5.5f, -2.5f, 6.0f, 7.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(0, 1).m_171488_(-2.9f, 5.5f, -2.5f, 6.0f, 1.0f, 6.0f, new CubeDeformation(0.175f)).m_171514_(18, 9).m_171488_(-2.9f, 9.5f, -4.5f, 6.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)1.9f, (float)12.0f, (float)0.5f));
        leftLeg.m_171599_("cube_r1", CubeListBuilder.m_171558_().m_171514_(0, -1).m_171488_(1.5f, 5.5f, 4.4f, 0.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.3927f, (float)0.0f));
        leftLeg.m_171599_("cube_r2", CubeListBuilder.m_171558_().m_171514_(0, -1).m_171480_().m_171488_(-1.325f, 5.5f, 4.2f, 0.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.3927f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)64, (int)64);
    }

    public List<String> bodyParts() {
        return Lists.newArrayList((Object[])new String[]{"right_leg", "left_leg"});
    }

    @Mod.EventBusSubscriber
    public static class AcidWalkerItemEvents {
        @SubscribeEvent
        public static void onFluidCollide(FluidCollisionEvent event) {
            IRelicItem relic;
            Player player;
            ItemStack stack;
            block6: {
                block5: {
                    stack = EntityUtils.findEquippedCurio((Entity)event.getEntity(), (Item)((Item)ItemRegistry.ACID_WALKER.get()));
                    LivingEntity livingEntity = event.getEntity();
                    if (!(livingEntity instanceof Player)) break block5;
                    player = (Player)livingEntity;
                    livingEntity = stack.m_41720_();
                    if (!(livingEntity instanceof IRelicItem)) break block5;
                    relic = (IRelicItem)livingEntity;
                    if (event.getFluid().m_76152_().m_6212_((Fluid)((LiquidBlock)ACBlockRegistry.ACID.get()).getFluid()) && !player.m_6144_()) break block6;
                }
                return;
            }
            int duration = NBTUtils.getInt((ItemStack)stack, (String)AcidWalkerItem.TAG_DURATION, (int)0);
            if (player.f_19797_ % 20 == 0) {
                NBTUtils.setInt((ItemStack)stack, (String)AcidWalkerItem.TAG_DURATION, (int)(++duration));
                if (duration % 5 == 0) {
                    relic.spreadExperience((LivingEntity)player, stack, 1);
                }
            }
            event.setCanceled(true);
        }
    }
}

