/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.paucal.api.contrib;

import at.petrak.paucal.common.msg.MsgHeadpatSoundS2C;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class HeadpatSpec {
    protected final String location;
    protected final Type type;

    protected HeadpatSpec(String location) {
        this.location = location;
        this.type = location.contains(":") && ResourceLocation.m_135830_((String)location) ? Type.VANILLA : Type.GITHUB;
    }

    public static List<HeadpatSpec> loadFromJson(JsonElement element) {
        if (element == null) {
            return List.of();
        }
        if (GsonHelper.m_13803_((JsonElement)element)) {
            String loc = element.getAsString();
            HeadpatSpec single = new HeadpatSpec(loc);
            return List.of(single);
        }
        if (element instanceof JsonArray) {
            JsonArray arr = (JsonArray)element;
            ArrayList<HeadpatSpec> out = new ArrayList<HeadpatSpec>();
            for (JsonElement elt : arr) {
                if (GsonHelper.m_13803_((JsonElement)elt)) {
                    out.add(new HeadpatSpec(elt.getAsString()));
                    continue;
                }
                throw new RuntimeException("Invalid entry in the headpat spec, expected list of strings");
            }
            return out;
        }
        throw new RuntimeException("Invalid entry in the headpat spec, expected list of strings");
    }

    public MsgHeadpatSoundS2C makePacket(Vec3 pos, float pitch, @Nullable Player patter) {
        return new MsgHeadpatSoundS2C(this.location, this.type == Type.GITHUB, pos.f_82479_, pos.f_82480_, pos.f_82481_, pitch, patter == null ? null : patter.m_20148_());
    }

    public static enum Type {
        VANILLA,
        GITHUB;

    }
}

