/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.paucal.api.contrib;

import at.petrak.paucal.api.contrib.HeadpatSpec;
import at.petrak.paucal.xplat.IXplatAbstractions;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class Contributor {
    private final UUID uuid;
    private final int level;
    private final boolean isDev;
    private final float pitchCenter;
    private final float pitchVariance;
    private final List<HeadpatSpec> headpats;
    private final JsonObject otherVals;

    @ApiStatus.Internal
    public Contributor(UUID uuid, JsonObject cfg) {
        this.uuid = uuid;
        this.otherVals = cfg;
        this.level = this.getInt("paucal:contributor_level", 0);
        this.isDev = this.getBool("paucal:is_dev", false);
        this.pitchCenter = this.getFloat("paucal:pat_pitch", 1.0f);
        this.pitchVariance = this.getFloat("paucal:pat_variance", 0.5f);
        JsonElement patsRaw = this.otherVals.get("paucal:pat_sound");
        this.headpats = HeadpatSpec.loadFromJson(patsRaw);
    }

    public int getLevel() {
        return this.level;
    }

    public boolean isDev() {
        return this.isDev;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    @ApiStatus.Internal
    public Collection<String> neededGithubSounds() {
        ArrayList<String> out = new ArrayList<String>();
        for (HeadpatSpec hp : this.headpats) {
            if (hp.type != HeadpatSpec.Type.GITHUB) continue;
            out.add(hp.location);
        }
        return out;
    }

    public boolean doHeadpatSound(Vec3 patteePos, @Nullable Player patter, Level level) {
        if (this.headpats.isEmpty()) {
            return false;
        }
        if (level instanceof ServerLevel) {
            ServerLevel slevel = (ServerLevel)level;
            int idx = level.f_46441_.m_188503_(this.headpats.size());
            HeadpatSpec patspec = this.headpats.get(idx);
            float pitch = this.pitchCenter + (float)(Math.random() - 0.5) * this.pitchVariance;
            IXplatAbstractions.INSTANCE.sendPacketNearS2C(patteePos, 64.0, slevel, patspec.makePacket(patteePos, pitch, patter));
        }
        return true;
    }

    @Nullable
    public String getString(String key) {
        return this.getString(key, null);
    }

    public String getString(String key, String fallback) {
        return GsonHelper.m_13851_((JsonObject)this.otherVals, (String)key, (String)fallback);
    }

    @Nullable
    public Integer getInt(String key) {
        if (this.otherVals.has(key)) {
            return GsonHelper.m_13927_((JsonObject)this.otherVals, (String)key);
        }
        return null;
    }

    public int getInt(String key, int fallback) {
        return GsonHelper.m_13824_((JsonObject)this.otherVals, (String)key, (int)fallback);
    }

    @Nullable
    public Float getFloat(String key) {
        if (this.otherVals.has(key)) {
            return Float.valueOf(GsonHelper.m_13915_((JsonObject)this.otherVals, (String)key));
        }
        return null;
    }

    public float getFloat(String key, float fallback) {
        return GsonHelper.m_13820_((JsonObject)this.otherVals, (String)key, (float)fallback);
    }

    @Nullable
    public Boolean getBool(String key) {
        if (this.otherVals.has(key)) {
            return GsonHelper.m_13912_((JsonObject)this.otherVals, (String)key);
        }
        return null;
    }

    public boolean getBool(String key, boolean fallback) {
        return GsonHelper.m_13855_((JsonObject)this.otherVals, (String)key, (boolean)fallback);
    }

    public Set<String> allKeys() {
        return this.otherVals.keySet();
    }

    public JsonObject otherVals() {
        return this.otherVals;
    }
}

