/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.naturalist.common.entity.core;

import com.starfish_studios.naturalist.common.entity.core.NaturalistAnimal;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.OldUsersConverter;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.scores.Team;
import org.jetbrains.annotations.Nullable;

public abstract class TamableNaturalistAnimal
extends NaturalistAnimal
implements OwnableEntity {
    protected static final EntityDataAccessor<Byte> DATA_FLAGS_ID = SynchedEntityData.m_135353_(TamableNaturalistAnimal.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    protected static final EntityDataAccessor<Optional<UUID>> DATA_OWNERUUID_ID = SynchedEntityData.m_135353_(TamableNaturalistAnimal.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private boolean orderedToSit;

    protected TamableNaturalistAnimal(EntityType<? extends TamableNaturalistAnimal> entityType, Level level) {
        super(entityType, level);
        this.reassessTameGoals();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_FLAGS_ID, (Object)0);
        this.f_19804_.m_135372_(DATA_OWNERUUID_ID, Optional.empty());
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        if (this.m_21805_() != null) {
            compound.m_128362_("Owner", this.m_21805_());
        }
        compound.m_128379_("Sitting", this.orderedToSit);
    }

    public void m_7378_(CompoundTag compound) {
        UUID uUID;
        super.m_7378_(compound);
        if (compound.m_128403_("Owner")) {
            uUID = compound.m_128342_("Owner");
        } else {
            String string = compound.m_128461_("Owner");
            uUID = OldUsersConverter.m_11083_((MinecraftServer)this.m_20194_(), (String)string);
        }
        if (uUID != null) {
            try {
                this.setOwnerUUID(uUID);
                this.setTame(true);
            }
            catch (Throwable var4) {
                this.setTame(false);
            }
        }
        this.orderedToSit = compound.m_128471_("Sitting");
        this.setInSittingPose(this.orderedToSit);
    }

    public boolean m_6573_(Player player) {
        return !this.m_21523_();
    }

    protected void spawnTamingParticles(boolean tamed) {
        SimpleParticleType particleOptions = ParticleTypes.f_123750_;
        if (!tamed) {
            particleOptions = ParticleTypes.f_123762_;
        }
        for (int i = 0; i < 7; ++i) {
            double d = this.f_19796_.m_188583_() * 0.02;
            double e = this.f_19796_.m_188583_() * 0.02;
            double f = this.f_19796_.m_188583_() * 0.02;
            this.m_9236_().m_7106_((ParticleOptions)particleOptions, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), d, e, f);
        }
    }

    public void m_7822_(byte id) {
        if (id == 7) {
            this.spawnTamingParticles(true);
        } else if (id == 6) {
            this.spawnTamingParticles(false);
        } else {
            super.m_7822_(id);
        }
    }

    public boolean isTame() {
        return ((Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID) & 4) != 0;
    }

    public void setTame(boolean tamed) {
        byte b = (Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID);
        if (tamed) {
            this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)((byte)(b | 4)));
        } else {
            this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)((byte)(b & 0xFFFFFFFB)));
        }
        this.reassessTameGoals();
    }

    protected void reassessTameGoals() {
    }

    public boolean isInSittingPose() {
        return ((Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID) & 1) != 0;
    }

    public void setInSittingPose(boolean sitting) {
        byte b = (Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID);
        if (sitting) {
            this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)((byte)(b | 1)));
        } else {
            this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)((byte)(b & 0xFFFFFFFE)));
        }
    }

    @Nullable
    public UUID m_21805_() {
        return ((Optional)this.f_19804_.m_135370_(DATA_OWNERUUID_ID)).orElse(null);
    }

    public void setOwnerUUID(@Nullable UUID uuid) {
        this.f_19804_.m_135381_(DATA_OWNERUUID_ID, Optional.ofNullable(uuid));
    }

    public void tame(Player player) {
        this.setTame(true);
        this.setOwnerUUID(player.m_20148_());
        if (player instanceof ServerPlayer) {
            CriteriaTriggers.f_10590_.m_68829_((ServerPlayer)player, (Animal)this);
        }
    }

    public boolean m_6779_(LivingEntity target) {
        return this.isOwnedBy(target) ? false : super.m_6779_(target);
    }

    public boolean isOwnedBy(LivingEntity entity) {
        return entity == this.m_269323_();
    }

    public boolean wantsToAttack(LivingEntity target, LivingEntity owner) {
        return true;
    }

    public Team m_5647_() {
        LivingEntity livingEntity;
        if (this.isTame() && (livingEntity = this.m_269323_()) != null) {
            return livingEntity.m_5647_();
        }
        return super.m_5647_();
    }

    public boolean m_7307_(Entity entity) {
        if (this.isTame()) {
            LivingEntity livingEntity = this.m_269323_();
            if (entity == livingEntity) {
                return true;
            }
            if (livingEntity != null) {
                return livingEntity.m_7307_(entity);
            }
        }
        return super.m_7307_(entity);
    }

    public void m_6667_(DamageSource damageSource) {
        if (!this.m_9236_().f_46443_ && this.m_9236_().m_46469_().m_46207_(GameRules.f_46142_) && this.m_269323_() instanceof ServerPlayer) {
            this.m_269323_().m_213846_(this.m_21231_().m_19293_());
        }
        super.m_6667_(damageSource);
    }

    public boolean isOrderedToSit() {
        return this.orderedToSit;
    }

    public void setOrderedToSit(boolean orderedToSit) {
        this.orderedToSit = orderedToSit;
    }
}

