/*
 * Decompiled with CFR 0.152.
 */
package dev.foxgirl.loadingbackgrounds;

import com.google.common.collect.Iterators;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.foxgirl.loadingbackgrounds.LoadingBackgrounds;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.server.packs.resources.ReloadableResourceManager;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.Unit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LoadingBackgroundsImpl
extends Screen
implements LoadingBackgrounds {
    private static final Logger LOGGER = LogManager.getLogger((String)"loadingbackgrounds");
    private static LoadingBackgroundsImpl INSTANCE;
    private Config config = Config.DEFAULT;
    private static final Set<String> loadingMessageTranslationKeys;
    private Iterator<ResourceLocation> textures;
    private ResourceLocation texturePrevious;
    private ResourceLocation textureCurrent;
    private double stateSecondsStarted = LoadingBackgroundsImpl.seconds();
    private boolean stateIsFading = false;
    private static final long secondsStart;
    private static final Pattern PROFILE_NAME_PATTERN;

    public static LoadingBackgroundsImpl getInstance() {
        if (INSTANCE == null) {
            throw new IllegalStateException("    Tried to access LoadingBackgroundsImpl instance before it was initialized\n\n    This usually happens when one of the possible loading screens\n    attempts to render before the mod initialization step finishes.\n\n    This is probably a conflict with another mod!\n");
        }
        return INSTANCE;
    }

    public LoadingBackgroundsImpl() {
        super((Component)Component.m_237119_());
        INSTANCE = this;
    }

    @Override
    public void init(@NotNull Path configDirectory) {
        LOGGER.info("Setting up Loading Backgrounds...");
        this.config = Config.read(configDirectory);
    }

    public static boolean isLoadingMessage(@Nullable Component message) {
        ComponentContents content;
        if (message != null && (content = message.m_214077_()) instanceof TranslatableContents) {
            return loadingMessageTranslationKeys.contains(((TranslatableContents)content).m_237508_());
        }
        return false;
    }

    @NotNull
    public Position getPosition() {
        return this.config.position();
    }

    private void initFromScreen(Screen screen) {
        this.f_96541_ = LoadingBackgroundsImpl.getClient();
        this.f_96543_ = screen.f_96543_;
        this.f_96544_ = screen.f_96544_;
    }

    public boolean draw(GuiGraphics context, Screen screen, boolean shouldDrawDefaultBackground) {
        boolean success;
        double secondsNow = LoadingBackgroundsImpl.seconds();
        double secondsDiff = secondsNow - this.stateSecondsStarted;
        if (secondsDiff > Math.max(this.config.secondsStay(), this.config.secondsFade()) + 5.0 || this.textures == null) {
            secondsDiff = 0.0;
            this.stateSecondsStarted = secondsNow;
            this.stateIsFading = false;
            this.textures = this.getBackgroundTextures();
            if (this.textures == null) {
                if (shouldDrawDefaultBackground) {
                    this.drawDefaultBackground(context, screen);
                }
                return false;
            }
            this.texturePrevious = this.textures.next();
            this.textureCurrent = this.textures.next();
        }
        if (this.stateIsFading) {
            success = this.drawCustomBackground(context, screen, this.texturePrevious, this.config.brightness(), 1.0f);
            this.drawCustomBackground(context, screen, this.textureCurrent, this.config.brightness(), (float)Math.min(secondsDiff / this.config.secondsFade(), 1.0));
            if (secondsDiff > this.config.secondsFade()) {
                this.stateSecondsStarted = secondsNow;
                this.stateIsFading = false;
            }
        } else {
            success = this.drawCustomBackground(context, screen, this.textureCurrent, this.config.brightness(), 1.0f);
            if (secondsDiff > this.config.secondsStay()) {
                this.stateSecondsStarted = secondsNow;
                this.stateIsFading = true;
                this.texturePrevious = this.textureCurrent;
                this.textureCurrent = this.textures.next();
            }
        }
        if (!success && shouldDrawDefaultBackground) {
            this.drawDefaultBackground(context, screen);
        }
        return success;
    }

    public boolean drawCustomBackground(GuiGraphics context, Screen screen, ResourceLocation texture, float brightness, float opacity) {
        this.initFromScreen(screen);
        if (texture == null || texture.equals((Object)MissingTextureAtlasSprite.m_118071_())) {
            return false;
        }
        TextureInfo textureInfo = (TextureInfo)LoadingBackgroundsImpl.getTextureManager().m_118506_(texture);
        if (textureInfo == null || textureInfo == MissingTextureAtlasSprite.m_118080_()) {
            return false;
        }
        textureInfo.loadingbackgrounds$init();
        float textureWidth = textureInfo.loadingbackgrounds$getWidth();
        float textureHeight = textureInfo.loadingbackgrounds$getHeight();
        if (textureWidth <= 0.0f || textureHeight <= 0.0f) {
            return false;
        }
        float screenWidth = screen.f_96543_;
        float screenHeight = screen.f_96544_;
        float offsetX = 0.0f;
        float offsetY = 0.0f;
        float scaleX = 1.0f;
        float scaleY = 1.0f;
        scaleX = screenWidth / textureWidth;
        scaleY = screenHeight / textureHeight;
        if (scaleX < scaleY) {
            scaleX = scaleY;
            offsetX = 0.0f - (screenWidth - textureWidth * scaleX) * 0.5f;
        } else {
            scaleY = scaleX;
            offsetY = 0.0f - (screenHeight - textureHeight * scaleY) * 0.5f;
        }
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableBlend();
        ShaderInstance oldShader = RenderSystem.getShader();
        float[] oldShaderColor = RenderSystem.getShaderColor();
        int oldShaderTexture = RenderSystem.getShaderTexture((int)0);
        RenderSystem.setShaderColor((float)brightness, (float)brightness, (float)brightness, (float)opacity);
        context.m_280398_(texture, 0, 0, 0, offsetX, offsetY, (int)screenWidth, (int)screenHeight, (int)(textureWidth * scaleX), (int)(textureHeight * scaleY));
        RenderSystem.setShader(() -> oldShader);
        RenderSystem.setShaderColor((float)oldShaderColor[0], (float)oldShaderColor[1], (float)oldShaderColor[2], (float)oldShaderColor[3]);
        RenderSystem.setShaderTexture((int)0, (int)oldShaderTexture);
        RenderSystem.disableBlend();
        return true;
    }

    public void drawDefaultBackground(GuiGraphics context, Screen screen) {
        this.initFromScreen(screen);
        this.drawDefaultBackgroundActual(context, screen);
    }

    private void drawDefaultBackgroundActual(GuiGraphics context, Screen screen) {
        context.m_280246_(0.25f, 0.25f, 0.25f, 1.0f);
        context.m_280398_(f_279548_, 0, 0, 0, 0.0f, 0.0f, this.f_96543_, this.f_96544_, 32, 32);
        context.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
    }

    private static double seconds() {
        return (double)(System.nanoTime() - secondsStart) * 1.0E-9;
    }

    private static Minecraft getClient() {
        return Minecraft.m_91087_();
    }

    private static ResourceManager getResourceManager() {
        return LoadingBackgroundsImpl.getClient().m_91098_();
    }

    private static PackRepository getResourcePackManager() {
        return LoadingBackgroundsImpl.getClient().m_91099_();
    }

    private static TextureManager getTextureManager() {
        return LoadingBackgroundsImpl.getClient().m_91097_();
    }

    private static String getProfileID(Pack profile) {
        return profile.m_10446_();
    }

    private static boolean matchesProfileNamePattern(String name) {
        return PROFILE_NAME_PATTERN.matcher(name).find();
    }

    private static boolean matchesProfileNamePattern(Pack profile) {
        return LoadingBackgroundsImpl.matchesProfileNamePattern(LoadingBackgroundsImpl.getProfileID(profile)) || LoadingBackgroundsImpl.matchesProfileNamePattern(profile.m_10429_().getString());
    }

    private void reloadResourcePacks() {
        if (!this.config.shouldLoadResources()) {
            return;
        }
        ReloadableResourceManager resourceManager = (ReloadableResourceManager)LoadingBackgroundsImpl.getResourceManager();
        PackRepository resourcePackManager = LoadingBackgroundsImpl.getResourcePackManager();
        Collection profiles = resourcePackManager.m_10519_();
        Collection profilesEnabled = resourcePackManager.m_10524_();
        boolean reload = false;
        for (Pack profile : profiles) {
            if (profilesEnabled.contains(profile) || !LoadingBackgroundsImpl.matchesProfileNamePattern(profile)) continue;
            LOGGER.info("Enabling resource pack " + LoadingBackgroundsImpl.getProfileID(profile));
            resourcePackManager.m_275855_(LoadingBackgroundsImpl.getProfileID(profile));
            reload = true;
        }
        if (reload) {
            resourceManager.m_142463_((Executor)LoadingBackgroundsImpl.getClient(), (Executor)LoadingBackgroundsImpl.getClient(), CompletableFuture.completedFuture(Unit.INSTANCE), resourcePackManager.m_10525_());
        }
    }

    private Map<ResourceLocation, Resource> getBackgroundTextureResources() {
        return LoadingBackgroundsImpl.getResourceManager().m_214159_("textures/gui/backgrounds", filename -> filename.m_135815_().endsWith(".png"));
    }

    private Iterator<ResourceLocation> getBackgroundTextures() {
        Map<ResourceLocation, Resource> resources = this.getBackgroundTextureResources();
        if (resources.isEmpty()) {
            this.reloadResourcePacks();
            resources = this.getBackgroundTextureResources();
            if (resources.isEmpty()) {
                return null;
            }
        }
        List<Object> textures = Arrays.asList(resources.keySet().toArray());
        Collections.shuffle(textures);
        return Iterators.cycle(textures);
    }

    static {
        loadingMessageTranslationKeys = new HashSet<String>(Arrays.asList("menu.generatingLevel", "menu.generatingTerrain", "menu.loadingForcedChunks", "menu.loadingLevel", "menu.preparingSpawn", "menu.savingChunks", "menu.savingLevel", "menu.working", "multiplayer.downloadingStats", "multiplayer.downloadingTerrain", "selectWorld.data_read", "selectWorld.loading_list", "selectWorld.resource_load", "resourcepack.downloading", "resourcepack.progress", "download.pack.title"));
        secondsStart = System.nanoTime();
        PROFILE_NAME_PATTERN = Pattern.compile("load(ing)?[\\W_-]{0,3}(background|image|pic)", 2);
    }

    public record Config(double secondsStay, double secondsFade, float brightness, @NotNull Position position, boolean shouldLoadResources) {
        private static final Gson GSON = new GsonBuilder().disableHtmlEscaping().serializeNulls().setPrettyPrinting().setLenient().create();
        private static final String DEFAULT_JSON = "// Loading Backgrounds configuration JSON file\n{\n  // Amount of time that each background is displayed for\n  \"secondsStay\": 5.0,\n  // Amount of time it takes to fade between backgrounds\n  \"secondsFade\": 0.5,\n  // Background brightness, between 0.0 and 1.0\n  \"brightness\": 1.0,\n  // Level loading indicator position\n  // One of \"CENTER\", \"BOTTOM_LEFT\", \"BOTTOM_RIGHT\", \"TOP_LEFT\", or \"TOP_RIGHT\"\n  \"position\": \"BOTTOM_RIGHT\",\n  // Should we try to forcefully load any resource packs that could contain background images?\n  \"shouldLoadResources\": false\n}\n";
        private static final Config DEFAULT = (Config)GSON.fromJson("// Loading Backgrounds configuration JSON file\n{\n  // Amount of time that each background is displayed for\n  \"secondsStay\": 5.0,\n  // Amount of time it takes to fade between backgrounds\n  \"secondsFade\": 0.5,\n  // Background brightness, between 0.0 and 1.0\n  \"brightness\": 1.0,\n  // Level loading indicator position\n  // One of \"CENTER\", \"BOTTOM_LEFT\", \"BOTTOM_RIGHT\", \"TOP_LEFT\", or \"TOP_RIGHT\"\n  \"position\": \"BOTTOM_RIGHT\",\n  // Should we try to forcefully load any resource packs that could contain background images?\n  \"shouldLoadResources\": false\n}\n", Config.class);

        @NotNull
        public static Config read(@NotNull Path pathConfigDirectory) {
            Path pathTemp;
            Path pathFile;
            block15: {
                Config config;
                block14: {
                    pathFile = pathConfigDirectory.resolve("loadingbackgrounds-config.json");
                    pathTemp = pathConfigDirectory.resolve("loadingbackgrounds-config.json.tmp");
                    BufferedReader reader = Files.newBufferedReader(pathFile);
                    try {
                        config = (Config)GSON.fromJson((Reader)reader, Config.class);
                        if (reader == null) break block14;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (reader != null) {
                                try {
                                    reader.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (NoSuchFileException cause) {
                            LOGGER.warn("Failed to read config, file not found");
                            break block15;
                        }
                        catch (IOException cause) {
                            LOGGER.error("Failed to read config, IO error", (Throwable)cause);
                            break block15;
                        }
                        catch (JsonParseException cause) {
                            LOGGER.error("Failed to read config, JSON error", (Throwable)cause);
                            break block15;
                        }
                        catch (Exception cause) {
                            LOGGER.error("Failed to read config", (Throwable)cause);
                        }
                    }
                    reader.close();
                }
                return config;
            }
            try {
                Files.writeString(pathTemp, (CharSequence)DEFAULT_JSON, new OpenOption[0]);
                Files.move(pathTemp, pathFile, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException cause) {
                LOGGER.error("Failed to write new config, IO error", (Throwable)cause);
            }
            catch (Exception cause) {
                LOGGER.error("Failed to write new config", (Throwable)cause);
            }
            return DEFAULT;
        }
    }

    public static enum Position {
        CENTER,
        TOP_LEFT,
        TOP_RIGHT,
        BOTTOM_LEFT,
        BOTTOM_RIGHT;

    }

    public static interface TextureInfo {
        public void loadingbackgrounds$init();

        public int loadingbackgrounds$getWidth();

        public int loadingbackgrounds$getHeight();
    }
}

