/*
 * Decompiled with CFR 0.152.
 */
package net.moddercoder.legendaryitems.ibs.spells;

import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.registries.MobEffectRegistry;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.moddercoder.legendaryitems.effect.ModMobEffects;
import net.moddercoder.legendaryitems.item.ModItems;
import org.jetbrains.annotations.NotNull;

@AutoSpellConfig
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u0004H\u0016J\b\u0010\r\u001a\u00020\tH\u0016J0\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lnet/moddercoder/legendaryitems/ibs/spells/SuperChargeSpell;", "Lio/redspace/ironsspellbooks/api/spells/AbstractSpell;", "()V", "defaultConfig", "Lio/redspace/ironsspellbooks/api/config/DefaultConfig;", "kotlin.jvm.PlatformType", "durationTicks", "", "id", "Lnet/minecraft/resources/ResourceLocation;", "getCastType", "Lio/redspace/ironsspellbooks/api/spells/CastType;", "getDefaultConfig", "getSpellResource", "onCast", "", "level", "Lnet/minecraft/world/level/Level;", "spellLevel", "entity", "Lnet/minecraft/world/entity/LivingEntity;", "castSource", "Lio/redspace/ironsspellbooks/api/spells/CastSource;", "playerMagicData", "Lio/redspace/ironsspellbooks/api/magic/MagicData;", "legendaryitems-1.20.1"})
public final class SuperChargeSpell
extends AbstractSpell {
    @NotNull
    private final ResourceLocation id = new ResourceLocation("legendaryitems", "super_charge");
    private final int durationTicks;
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.COMMON).setSchoolResource(SchoolRegistry.LIGHTNING_RESOURCE).setMaxLevel(2).setCooldownSeconds(25.0).build();

    public SuperChargeSpell() {
        this.durationTicks = 30;
        this.manaCostPerLevel = 10;
        this.baseManaCost = 40;
    }

    public void onCast(@NotNull Level level, int spellLevel, @NotNull LivingEntity entity, @NotNull CastSource castSource, @NotNull MagicData playerMagicData) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)castSource, (String)"castSource");
        Intrinsics.checkNotNullParameter((Object)playerMagicData, (String)"playerMagicData");
        entity.m_7292_(new MobEffectInstance(MobEffects.f_19596_, this.durationTicks + (spellLevel - 1) * 10, 2, false, false, true));
        entity.m_7292_(new MobEffectInstance((MobEffect)ModMobEffects.getCRESCENS_CROSSBOW_RELOADING_BOOST().get(), this.durationTicks + 120, 0, false, false, true));
        if (spellLevel > 1) {
            entity.m_7292_(new MobEffectInstance((MobEffect)MobEffectRegistry.TRUE_INVISIBILITY.get(), 100, 0, false, false, true));
        }
        if (entity instanceof Player) {
            ((Player)entity).m_36335_().m_41524_((Item)ModItems.getCRESCENS_CROSSBOW().get(), this.durationTicks);
        }
        super.onCast(level, spellLevel, entity, castSource, playerMagicData);
    }

    @NotNull
    public DefaultConfig getDefaultConfig() {
        DefaultConfig defaultConfig = this.defaultConfig;
        Intrinsics.checkNotNullExpressionValue((Object)defaultConfig, (String)"this.defaultConfig");
        return defaultConfig;
    }

    @NotNull
    public ResourceLocation getSpellResource() {
        return this.id;
    }

    @NotNull
    public CastType getCastType() {
        return CastType.INSTANT;
    }
}

