/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarycreatures.items.materials;

import java.util.function.Supplier;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public enum ArmorMaterialBase implements ArmorMaterial
{
    STRAW("straw_hat", 20.0f, new int[]{0, 0, 0, 0}, 17, SoundEvents.f_11678_, 0.0f, 0.0f, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42405_}));

    private static final int[] BASE_DURABILITY;
    private final String name;
    private final float maxDamageFactor;
    private final int[] damageReductionAmountArray;
    private final int enchantmentValue;
    private final SoundEvent soundEvent;
    private final float toughness;
    private final float knockbackResistance;
    private final Supplier<Ingredient> repairIngredient;

    private ArmorMaterialBase(String name, float durabilityMultiplier, int[] protectionAmounts, int enchantmentValue, SoundEvent soundEvent, float toughness, float knockbackResistance, Supplier<Ingredient> repairIngredient) {
        this.name = name;
        this.maxDamageFactor = durabilityMultiplier;
        this.damageReductionAmountArray = protectionAmounts;
        this.enchantmentValue = enchantmentValue;
        this.soundEvent = soundEvent;
        this.toughness = toughness;
        this.knockbackResistance = knockbackResistance;
        this.repairIngredient = repairIngredient;
    }

    public int m_266425_(ArmorItem.Type slotIn) {
        return (int)((float)BASE_DURABILITY[slotIn.m_266308_().m_20749_()] * this.maxDamageFactor);
    }

    public int m_7366_(ArmorItem.Type slotIn) {
        return this.damageReductionAmountArray[slotIn.m_266308_().m_20749_()];
    }

    public int m_6646_() {
        return this.enchantmentValue;
    }

    @NotNull
    public SoundEvent m_7344_() {
        return this.soundEvent;
    }

    @NotNull
    public Ingredient m_6230_() {
        return this.repairIngredient.get();
    }

    @NotNull
    public String m_6082_() {
        return "legendarycreatures:" + this.name;
    }

    public float m_6651_() {
        return this.toughness;
    }

    public float m_6649_() {
        return this.knockbackResistance;
    }

    static {
        BASE_DURABILITY = new int[]{13, 15, 16, 11};
    }
}

