/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarycreatures.entities;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import sfiomn.legendarycreatures.entities.AnimatedCreatureEntity;
import sfiomn.legendarycreatures.entities.goals.BaseMeleeAttackGoal;
import sfiomn.legendarycreatures.registry.SoundRegistry;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public abstract class MojoEntity
extends AnimatedCreatureEntity
implements Enemy {
    private final RawAnimation RUN_ANIM = RawAnimation.begin().thenPlay("run");
    private final RawAnimation ATTACK_ANIM = RawAnimation.begin().thenPlay("attack");

    public MojoEntity(EntityType<? extends PathfinderMob> type, Level level) {
        super(type, level);
        this.f_21364_ = 4;
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22279_, 0.35).m_22268_(Attributes.f_22284_, 0.0).m_22268_(Attributes.f_22281_, 3.0).m_22268_(Attributes.f_22277_, 20.0).m_22268_(Attributes.f_22278_, 0.5);
    }

    protected int getBaseAttackDuration() {
        return 0;
    }

    protected int getBaseAttackActionPoint() {
        return 0;
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new BaseMeleeAttackGoal(this, this.getBaseAttackDuration(), this.getBaseAttackActionPoint(), 5, 1.0, true){

            @Override
            protected boolean executeAttack(LivingEntity target) {
                this.mob.m_5496_((SoundEvent)SoundRegistry.MOJO_BASE_ATTACK_HIT.get(), 1.0f, 1.0f);
                return super.executeAttack(target);
            }
        });
        this.f_21346_.m_25352_(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21345_.m_25352_(4, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.6, 40));
        this.f_21346_.m_25352_(5, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false, false));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    @Override
    public <E extends GeoAnimatable> PlayState attackingPredicate(AnimationState<E> state) {
        if (this.hasSpawnEffect() && this.f_19797_ < this.getSpawnAnimationTicks()) {
            return PlayState.CONTINUE;
        }
        if (this.getAttackAnimation() == 1) {
            return state.setAndContinue(this.ATTACK_ANIM);
        }
        state.getController().forceAnimationReset();
        return PlayState.STOP;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.hasSpawnEffect() && this.f_19797_ == 1) {
            this.m_9236_().m_5594_(null, this.m_20183_(), (SoundEvent)SoundRegistry.MOJO_SPAWN.get(), SoundSource.HOSTILE, 10.0f, 1.0f);
        }
    }

    protected float m_6431_(Pose p_21131_, EntityDimensions p_21132_) {
        return 0.7f;
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)SoundRegistry.MOJO_IDLE.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)SoundRegistry.MOJO_DEATH.get();
    }

    @Override
    protected SoundEvent m_7975_(@NotNull DamageSource source) {
        return (SoundEvent)SoundRegistry.MOJO_HURT.get();
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
        this.m_5496_((SoundEvent)SoundRegistry.MOJO_STEP.get(), 1.0f, 1.0f);
    }

    @Override
    public int getSpawnAnimationTicks() {
        return 15;
    }

    @Override
    public RawAnimation getSprintAnimation() {
        return this.RUN_ANIM;
    }
}

