/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.inventorymanagement.roundalib.config.value;

import java.util.Arrays;
import me.roundaround.inventorymanagement.roundalib.client.gui.GuiUtil;
import me.roundaround.inventorymanagement.roundalib.config.ModConfig;
import me.roundaround.inventorymanagement.roundalib.config.value.ListOptionValue;

public enum GuiAlignment implements ListOptionValue<GuiAlignment>
{
    TOP_LEFT(AlignmentY.TOP, AlignmentX.LEFT),
    TOP_RIGHT(AlignmentY.TOP, AlignmentX.RIGHT),
    BOTTOM_LEFT(AlignmentY.BOTTOM, AlignmentX.LEFT),
    BOTTOM_RIGHT(AlignmentY.BOTTOM, AlignmentX.RIGHT);

    private final AlignmentX alignmentX;
    private final AlignmentY alignmentY;
    private final String id;

    private GuiAlignment(AlignmentY alignmentY, AlignmentX alignmentX) {
        this.alignmentX = alignmentX;
        this.alignmentY = alignmentY;
        this.id = alignmentY + "_" + alignmentX;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getI18nKey(ModConfig config) {
        return config.getModId() + ".roundalib.gui_alignment." + this.id;
    }

    @Override
    public GuiAlignment getFromId(String id) {
        return GuiAlignment.fromId(id);
    }

    @Override
    public GuiAlignment getNext() {
        return GuiAlignment.values()[(this.ordinal() + 1) % GuiAlignment.values().length];
    }

    @Override
    public GuiAlignment getPrev() {
        return GuiAlignment.values()[(this.ordinal() + GuiAlignment.values().length - 1) % GuiAlignment.values().length];
    }

    public AlignmentX getAlignmentX() {
        return this.alignmentX;
    }

    public AlignmentY getAlignmentY() {
        return this.alignmentY;
    }

    public int getPosX() {
        return GuiAlignment.getPosX(this);
    }

    public int getPosY() {
        return GuiAlignment.getPosY(this);
    }

    public int getOffsetMultiplierX() {
        return GuiAlignment.getOffsetMultiplierX(this);
    }

    public int getOffsetMultiplierY() {
        return GuiAlignment.getOffsetMultiplierY(this);
    }

    public static GuiAlignment getDefault() {
        return TOP_LEFT;
    }

    public static GuiAlignment fromId(String id) {
        return Arrays.stream(GuiAlignment.values()).filter(guiAlignment -> guiAlignment.id.equals(id)).findFirst().orElse(GuiAlignment.getDefault());
    }

    public static int getPosX(GuiAlignment guiAlignment) {
        return guiAlignment.alignmentX.getPos();
    }

    public static int getPosY(GuiAlignment guiAlignment) {
        return guiAlignment.alignmentY.getPos();
    }

    public static int getOffsetMultiplierX(GuiAlignment guiAlignment) {
        return guiAlignment.alignmentX.getOffsetMultiplier();
    }

    public static int getOffsetMultiplierY(GuiAlignment guiAlignment) {
        return guiAlignment.alignmentY.getOffsetMultiplier();
    }

    public static enum AlignmentX {
        LEFT("left"),
        RIGHT("right");

        private final String value;

        private AlignmentX(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        public int getPos() {
            return this.value.equals("right") ? GuiUtil.getScaledWindowWidth() : 0;
        }

        public int getOffsetMultiplier() {
            return this.value.equals("right") ? -1 : 1;
        }
    }

    public static enum AlignmentY {
        TOP("top"),
        BOTTOM("bottom");

        private final String value;

        private AlignmentY(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        public int getPos() {
            return this.value.equals("bottom") ? GuiUtil.getScaledWindowHeight() : 0;
        }

        public int getOffsetMultiplier() {
            return this.value.equals("bottom") ? -1 : 1;
        }
    }
}

