/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.inventorymanagement.roundalib.config.option;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import me.roundaround.inventorymanagement.roundalib.config.ModConfig;
import net.minecraft.class_2561;

public abstract class ConfigOption<D, B extends AbstractBuilder<D, B>> {
    private final ModConfig config;
    private final String id;
    private final class_2561 label;
    private final boolean showInConfigScreen;
    private final List<String> comment;
    private final boolean useLabelAsCommentFallback;
    private final Supplier<Boolean> disabledSupplier;
    private final ValueChangeListeners<D> valueChangeListeners = new ValueChangeListeners();
    private final List<ConfigOption<?, ?>> dependencies;
    private D defaultValue;
    private D value;
    private D lastSavedValue;

    protected ConfigOption(B builder) {
        this.config = ((AbstractBuilder)builder).config;
        this.id = ((AbstractBuilder)builder).id;
        this.label = ((AbstractBuilder)builder).label;
        this.defaultValue = ((AbstractBuilder)builder).defaultValue;
        this.showInConfigScreen = ((AbstractBuilder)builder).showInConfigScreen;
        this.comment = ((AbstractBuilder)builder).comment;
        this.useLabelAsCommentFallback = ((AbstractBuilder)builder).useLabelAsCommentFallback;
        this.disabledSupplier = ((AbstractBuilder)builder).disabledSupplier;
        this.dependencies = ((AbstractBuilder)builder).dependencies;
        this.value = this.defaultValue;
        this.dependencies.forEach(dependency -> dependency.valueChangeListeners.add(null, this::dependencyChanged));
    }

    protected ConfigOption(ConfigOption<D, B> other) {
        this.config = other.config;
        this.id = other.id;
        this.label = other.label;
        this.defaultValue = other.defaultValue;
        this.showInConfigScreen = other.showInConfigScreen;
        this.comment = other.comment;
        this.useLabelAsCommentFallback = other.useLabelAsCommentFallback;
        this.disabledSupplier = other.disabledSupplier;
        this.dependencies = other.dependencies;
        this.value = other.value;
        this.lastSavedValue = other.lastSavedValue;
    }

    public ModConfig getConfig() {
        return this.config;
    }

    public String getId() {
        return this.id;
    }

    public boolean shouldShowInConfigScreen() {
        return this.showInConfigScreen;
    }

    public class_2561 getLabel() {
        return this.label;
    }

    public List<String> getComment() {
        return this.comment;
    }

    public boolean getUseLabelAsCommentFallback() {
        return this.useLabelAsCommentFallback;
    }

    public D getValue() {
        return this.value;
    }

    public void setValue(D value) {
        D prev = this.value;
        this.value = value;
        this.valueChangeListeners.invoke(prev, value);
    }

    public D getDefault() {
        return this.defaultValue;
    }

    public void setDefault(D defaultValue) {
        this.defaultValue = defaultValue;
    }

    public void resetToDefault() {
        this.setValue(this.defaultValue);
    }

    public void markValueAsSaved() {
        this.lastSavedValue = this.value;
    }

    public boolean isDirty() {
        return !this.value.equals(this.lastSavedValue);
    }

    public boolean isModified() {
        return !this.value.equals(this.defaultValue);
    }

    public boolean isDisabled() {
        return this.disabledSupplier.get();
    }

    public void deserialize(Object data) {
        this.setValue(data);
    }

    public Object serialize() {
        return this.value;
    }

    public final void subscribeToValueChanges(Integer hashCode, BiConsumer<D, D> listener) {
        this.valueChangeListeners.add(hashCode, listener);
    }

    public final void clearValueChangeListeners(Integer hashCode) {
        this.valueChangeListeners.clear(hashCode);
    }

    protected void dependencyChanged(Object prev, Object curr) {
        this.valueChangeListeners.invoke(this.getValue(), this.getValue());
    }

    public abstract ConfigOption<D, B> copy();

    public final ConfigOption<D, B> createWorkingCopy() {
        return this.copy();
    }

    private static class ValueChangeListeners<D> {
        private final HashMap<Integer, Queue<BiConsumer<D, D>>> listeners = new HashMap();

        private ValueChangeListeners() {
        }

        public void add(Integer hashCode, BiConsumer<D, D> listener) {
            if (!this.listeners.containsKey(hashCode)) {
                this.listeners.put(hashCode, new LinkedList());
            }
            this.listeners.get(hashCode).add(listener);
        }

        public void remove(Integer hashCode, BiConsumer<D, D> listener) {
            if (!this.listeners.containsKey(hashCode)) {
                return;
            }
            this.listeners.get(hashCode).remove(listener);
        }

        public void clear(Integer hashCode) {
            this.listeners.remove(hashCode);
        }

        public void invoke(D prev, D curr) {
            this.listeners.keySet().forEach(hashCode -> this.invoke((Integer)hashCode, prev, curr));
        }

        public void invoke(Integer hashCode, D prev, D curr) {
            if (!this.listeners.containsKey(hashCode)) {
                return;
            }
            this.listeners.get(hashCode).forEach(listener -> listener.accept(prev, curr));
        }
    }

    public static abstract class AbstractBuilder<D, B extends AbstractBuilder<D, B>> {
        protected final ModConfig config;
        protected final String id;
        protected final class_2561 label;
        protected D defaultValue;
        protected boolean showInConfigScreen = true;
        protected List<String> comment = List.of();
        protected boolean useLabelAsCommentFallback = true;
        protected Supplier<Boolean> disabledSupplier = () -> false;
        protected List<ConfigOption<?, ?>> dependencies = List.of();

        protected AbstractBuilder(ModConfig config, String id, String labelI18nKey, D defaultValue) {
            this(config, id, (class_2561)class_2561.method_43471((String)labelI18nKey), defaultValue);
        }

        protected AbstractBuilder(ModConfig config, String id, class_2561 label, D defaultValue) {
            this.config = config;
            this.id = id;
            this.label = label;
            this.defaultValue = defaultValue;
        }

        public B hideFromConfigScreen() {
            this.showInConfigScreen = false;
            return (B)this;
        }

        public B setComment(String comment) {
            this.comment = List.of(comment);
            return (B)this;
        }

        public B setComment(String ... comment) {
            this.comment = List.of(comment);
            return (B)this;
        }

        public B setComment(Collection<String> comment) {
            this.comment = List.copyOf(comment);
            return (B)this;
        }

        public B setUseLabelAsCommentFallback(boolean useLabelAsCommentFallback) {
            this.useLabelAsCommentFallback = useLabelAsCommentFallback;
            return (B)this;
        }

        public B setDisabledSupplier(Supplier<Boolean> disabledSupplier) {
            this.disabledSupplier = disabledSupplier;
            return (B)this;
        }

        public B dependsOn(ConfigOption<?, ?> ... dependencies) {
            this.dependencies = List.of(dependencies);
            return (B)this;
        }

        public abstract ConfigOption<D, B> build();
    }
}

