/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.inventorymanagement.client;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import me.roundaround.inventorymanagement.InventoryManagementMod;
import me.roundaround.inventorymanagement.client.gui.AutoStackButton;
import me.roundaround.inventorymanagement.client.gui.InventoryManagementButton;
import me.roundaround.inventorymanagement.client.gui.SortInventoryButton;
import me.roundaround.inventorymanagement.client.gui.TransferAllButton;
import me.roundaround.inventorymanagement.inventory.InventoryHelper;
import me.roundaround.inventorymanagement.roundalib.config.value.GuiTheme;
import me.roundaround.inventorymanagement.roundalib.config.value.Position;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.fabricmc.fabric.api.client.screen.v1.Screens;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1707;
import net.minecraft.class_1722;
import net.minecraft.class_1724;
import net.minecraft.class_1730;
import net.minecraft.class_1733;
import net.minecraft.class_1735;
import net.minecraft.class_2621;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3258;
import net.minecraft.class_3264;
import net.minecraft.class_3300;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_490;
import net.minecraft.class_746;

@Environment(value=EnvType.CLIENT)
public class InventoryButtonsManager {
    public static final InventoryButtonsManager INSTANCE = new InventoryButtonsManager();
    private static final class_310 MINECRAFT = class_310.method_1551();
    private static final int BUTTON_SPACING = 1;
    private static final int BUTTON_SHIFT_X = 0;
    private static final int BUTTON_SHIFT_Y = 1;
    private final LinkedHashSet<InventoryManagementButton> playerButtons = new LinkedHashSet();
    private final LinkedHashSet<InventoryManagementButton> containerButtons = new LinkedHashSet();
    private final HashSet<Class<? extends class_1263>> sortableInventories = new HashSet();
    private final HashSet<Class<? extends class_1263>> transerableInventories = new HashSet();
    private final HashSet<Class<? extends class_1703>> sortableScreenHandlers = new HashSet();
    private final HashSet<Class<? extends class_1703>> transferableScreenHandlers = new HashSet();
    private boolean darkUiDetected = false;

    private InventoryButtonsManager() {
        this.registerSortableContainer(class_1661.class);
        this.registerSortableContainer(class_1730.class);
        this.registerSortableContainer(class_2621.class);
        this.registerTransferableContainer(class_1661.class);
        this.registerTransferableContainer(class_1730.class);
        this.registerTransferableContainer(class_2621.class);
        this.registerSimpleInventorySortableHandler(class_1707.class);
        this.registerSimpleInventorySortableHandler(class_1733.class);
        this.registerSimpleInventorySortableHandler(class_1724.class);
        this.registerSimpleInventorySortableHandler(class_1722.class);
        this.registerSimpleInventoryTransferableHandler(class_1707.class);
        this.registerSimpleInventoryTransferableHandler(class_1733.class);
        this.registerSimpleInventoryTransferableHandler(class_1724.class);
    }

    public void registerSortableContainer(Class<? extends class_1263> clazz) {
        this.sortableInventories.add(clazz);
    }

    public void registerTransferableContainer(Class<? extends class_1263> clazz) {
        this.transerableInventories.add(clazz);
    }

    public void registerSimpleInventorySortableHandler(Class<? extends class_1703> clazz) {
        this.sortableScreenHandlers.add(clazz);
    }

    public void registerSimpleInventoryTransferableHandler(Class<? extends class_1703> clazz) {
        this.transferableScreenHandlers.add(clazz);
    }

    public void init() {
        ScreenEvents.AFTER_INIT.register(this::onScreenAfterInit);
        ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)new SimpleSynchronousResourceReloadListener(){

            public class_2960 getFabricId() {
                return new class_2960("inventorymanagement", "resource_pack_loader");
            }

            public void method_14491(class_3300 manager) {
                InventoryButtonsManager.this.darkUiDetected = false;
                manager.method_29213().forEach(pack -> {
                    block11: {
                        if (!(pack instanceof class_3258)) {
                            return;
                        }
                        class_3258 zipPack = (class_3258)pack;
                        if (zipPack.method_14410(new String[]{"Selected Packs.txt"}) == null) {
                            return;
                        }
                        try (InputStream stream = (InputStream)zipPack.method_14410(new String[]{"Selected Packs.txt"}).get();){
                            BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
                            if (stream == null) break block11;
                            String str = "";
                            while ((str = reader.readLine()) != null) {
                                if (!str.trim().startsWith("DarkUI")) continue;
                                InventoryButtonsManager.this.darkUiDetected = true;
                                break;
                            }
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                });
            }
        });
    }

    public boolean usingDarkMode() {
        switch ((GuiTheme)InventoryManagementMod.CONFIG.GUI_THEME.getValue()) {
            case LIGHT: {
                return false;
            }
            case DARK: {
                return true;
            }
        }
        return this.darkUiDetected;
    }

    private void onScreenAfterInit(class_310 client, class_437 screen, float scaledWidth, float scaledHeight) {
        if (!(screen instanceof class_465)) {
            return;
        }
        this.playerButtons.clear();
        this.containerButtons.clear();
        class_465 handledScreen = (class_465)screen;
        this.generateSortButton(handledScreen, false);
        this.generateAutoStackButton(handledScreen, false);
        this.generateTransferAllButton(handledScreen, false);
        this.generateSortButton(handledScreen, true);
        this.generateAutoStackButton(handledScreen, true);
        this.generateTransferAllButton(handledScreen, true);
    }

    private void generateSortButton(class_465<?> screen, boolean isPlayerInventory) {
        class_1661 inventory;
        if (!((Boolean)InventoryManagementMod.CONFIG.MOD_ENABLED.getValue()).booleanValue() || !((Boolean)InventoryManagementMod.CONFIG.SHOW_SORT.getValue()).booleanValue()) {
            return;
        }
        if (screen instanceof class_490 && !isPlayerInventory) {
            return;
        }
        class_1735 referenceSlot = this.getReferenceSlot(screen, isPlayerInventory);
        if (referenceSlot == null) {
            return;
        }
        class_746 player = InventoryButtonsManager.MINECRAFT.field_1724;
        if (player == null) {
            return;
        }
        Object object = inventory = isPlayerInventory ? player.method_31548() : InventoryHelper.getContainerInventory((class_1657)player);
        if (inventory == null) {
            return;
        }
        if (inventory instanceof class_1277 ? this.sortableScreenHandlers.stream().noneMatch(clazz -> clazz.isInstance(screen.method_17577())) : this.sortableInventories.stream().noneMatch(arg_0 -> InventoryButtonsManager.lambda$generateSortButton$1((class_1263)inventory, arg_0))) {
            return;
        }
        if (this.getNumberOfBulkInventorySlots(screen, isPlayerInventory) < 3) {
            return;
        }
        Position position = this.getButtonPosition((class_437)screen, isPlayerInventory);
        SortInventoryButton button = new SortInventoryButton(screen, (class_1263)inventory, referenceSlot, position, isPlayerInventory);
        this.addButton(screen, button, isPlayerInventory);
    }

    private void generateAutoStackButton(class_465<?> screen, boolean isPlayerInventory) {
        class_1661 toInventory;
        if (!((Boolean)InventoryManagementMod.CONFIG.MOD_ENABLED.getValue()).booleanValue() || !((Boolean)InventoryManagementMod.CONFIG.SHOW_STACK.getValue()).booleanValue()) {
            return;
        }
        if (screen instanceof class_490 && !isPlayerInventory) {
            return;
        }
        class_1735 referenceSlot = this.getReferenceSlot(screen, isPlayerInventory);
        if (referenceSlot == null) {
            return;
        }
        class_746 player = InventoryButtonsManager.MINECRAFT.field_1724;
        if (player == null) {
            return;
        }
        class_1263 fromInventory = isPlayerInventory ? InventoryHelper.getContainerInventory((class_1657)player) : player.method_31548();
        Object object = toInventory = isPlayerInventory ? player.method_31548() : InventoryHelper.getContainerInventory((class_1657)player);
        if (fromInventory == null || toInventory == null || fromInventory == toInventory) {
            return;
        }
        if (fromInventory instanceof class_1277 ? this.transferableScreenHandlers.stream().noneMatch(clazz -> clazz.isInstance(screen.method_17577())) : this.transerableInventories.stream().noneMatch(clazz -> clazz.isInstance(fromInventory))) {
            return;
        }
        if (toInventory instanceof class_1277 ? this.transferableScreenHandlers.stream().noneMatch(clazz -> clazz.isInstance(screen.method_17577())) : this.transerableInventories.stream().noneMatch(arg_0 -> InventoryButtonsManager.lambda$generateAutoStackButton$5((class_1263)toInventory, arg_0))) {
            return;
        }
        if (this.getNumberOfNonPlayerBulkInventorySlots(screen) < 3) {
            return;
        }
        Position position = this.getButtonPosition((class_437)screen, isPlayerInventory);
        AutoStackButton button = new AutoStackButton(screen, fromInventory, referenceSlot, position, isPlayerInventory);
        this.addButton(screen, button, isPlayerInventory);
    }

    private void generateTransferAllButton(class_465<?> screen, boolean isPlayerInventory) {
        class_1661 toInventory;
        if (!((Boolean)InventoryManagementMod.CONFIG.MOD_ENABLED.getValue()).booleanValue() || !((Boolean)InventoryManagementMod.CONFIG.SHOW_TRANSFER.getValue()).booleanValue()) {
            return;
        }
        if (screen instanceof class_490 && !isPlayerInventory) {
            return;
        }
        class_1735 referenceSlot = this.getReferenceSlot(screen, isPlayerInventory);
        if (referenceSlot == null) {
            return;
        }
        class_746 player = InventoryButtonsManager.MINECRAFT.field_1724;
        if (player == null) {
            return;
        }
        class_1263 fromInventory = isPlayerInventory ? InventoryHelper.getContainerInventory((class_1657)player) : player.method_31548();
        Object object = toInventory = isPlayerInventory ? player.method_31548() : InventoryHelper.getContainerInventory((class_1657)player);
        if (fromInventory == null || toInventory == null || fromInventory == toInventory) {
            return;
        }
        if (fromInventory instanceof class_1277 ? this.transferableScreenHandlers.stream().noneMatch(clazz -> clazz.isInstance(screen.method_17577())) : this.transerableInventories.stream().noneMatch(clazz -> clazz.isInstance(fromInventory))) {
            return;
        }
        if (toInventory instanceof class_1277 ? this.transferableScreenHandlers.stream().noneMatch(clazz -> clazz.isInstance(screen.method_17577())) : this.transerableInventories.stream().noneMatch(arg_0 -> InventoryButtonsManager.lambda$generateTransferAllButton$9((class_1263)toInventory, arg_0))) {
            return;
        }
        if (this.getNumberOfNonPlayerBulkInventorySlots(screen) < 3) {
            return;
        }
        Position position = this.getButtonPosition((class_437)screen, isPlayerInventory);
        TransferAllButton button = new TransferAllButton(screen, fromInventory, referenceSlot, position, isPlayerInventory);
        this.addButton(screen, button, isPlayerInventory);
    }

    private void addButton(class_465<?> screen, InventoryManagementButton button, boolean isPlayerInventory) {
        Screens.getButtons(screen).add(button);
        (isPlayerInventory ? this.playerButtons : this.containerButtons).add(button);
    }

    private class_1735 getReferenceSlot(class_465<?> screen, boolean isPlayerInventory) {
        return screen.method_17577().field_7761.stream().filter(slot -> isPlayerInventory == slot.field_7871 instanceof class_1661).max(Comparator.comparingInt(slot -> slot.field_7873 - slot.field_7872)).orElse(null);
    }

    private int getNumberOfBulkInventorySlots(class_465<?> screen, boolean isPlayerInventory) {
        return screen.method_17577().field_7761.stream().filter(slot -> isPlayerInventory == slot.field_7871 instanceof class_1661).filter(slot -> !(screen.method_17577() instanceof class_1724) || slot.method_34266() >= 2).mapToInt(slot -> 1).sum();
    }

    private int getNumberOfNonPlayerBulkInventorySlots(class_465<?> screen) {
        return screen.method_17577().field_7761.stream().filter(slot -> !(slot.field_7871 instanceof class_1661)).filter(slot -> !(screen.method_17577() instanceof class_1724) || slot.method_34266() >= 2).mapToInt(slot -> 1).sum();
    }

    private Position getButtonPosition(class_437 screen, boolean isPlayerInventory) {
        Position offset = InventoryManagementMod.CONFIG.SCREEN_POSITIONS.get(screen, isPlayerInventory).orElse((Position)InventoryManagementMod.CONFIG.DEFAULT_POSITION.getValue());
        return this.getButtonPosition((isPlayerInventory ? this.playerButtons : this.containerButtons).size(), offset);
    }

    public Position getButtonPosition(int index, Position offset) {
        int x = offset.x() + 0 * index;
        int y = offset.y() + 15 * index;
        return new Position(x, y);
    }

    public LinkedList<InventoryManagementButton> getPlayerButtons() {
        return new LinkedList<InventoryManagementButton>(this.playerButtons);
    }

    public LinkedList<InventoryManagementButton> getContainerButtons() {
        return new LinkedList<InventoryManagementButton>(this.containerButtons);
    }

    private static /* synthetic */ boolean lambda$generateTransferAllButton$9(class_1263 toInventory, Class clazz) {
        return clazz.isInstance(toInventory);
    }

    private static /* synthetic */ boolean lambda$generateAutoStackButton$5(class_1263 toInventory, Class clazz) {
        return clazz.isInstance(toInventory);
    }

    private static /* synthetic */ boolean lambda$generateSortButton$1(class_1263 inventory, Class clazz) {
        return clazz.isInstance(inventory);
    }
}

