/*
 * Decompiled with CFR 0.152.
 */
package com.samsthenerd.inline.api.data;

import com.mojang.serialization.Codec;
import com.samsthenerd.inline.api.InlineData;
import com.samsthenerd.inline.tooltips.CustomTooltipManager;
import com.samsthenerd.inline.tooltips.providers.EntityTTProvider;
import com.samsthenerd.inline.utils.EntityCradle;
import com.samsthenerd.inline.utils.cradles.EntTypeCradle;
import com.samsthenerd.inline.utils.cradles.NbtCradle;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;

public class EntityInlineData
implements InlineData<EntityInlineData> {
    protected static final RandomSource random = RandomSource.m_216327_();
    protected float uniqueOffset = 0.0f;
    public final EntityCradle cradle;

    public EntityInlineData(EntityCradle cradle) {
        this.cradle = cradle;
    }

    public static EntityInlineData fromEntity(Entity entity) {
        return new EntityInlineData(new NbtCradle(entity));
    }

    public static EntityInlineData fromNbt(CompoundTag tag) {
        return new EntityInlineData(new NbtCradle(tag));
    }

    public static EntityInlineData fromType(EntityType type) {
        return new EntityInlineData(new EntTypeCradle(type));
    }

    public EntityDataType getType() {
        return EntityDataType.INSTANCE;
    }

    @Override
    public ResourceLocation getRendererId() {
        return new ResourceLocation("inline", "entity");
    }

    @Nullable
    public Entity getEntity(Level world) {
        return this.cradle.getEntity(world);
    }

    public float getUniqueOffset() {
        return this.uniqueOffset;
    }

    public HoverEvent getEntityDisplayHoverEvent() {
        return new HoverEvent(HoverEvent.Action.f_130832_, (Object)new HoverEvent.ItemStackInfo(CustomTooltipManager.getForTooltip(EntityTTProvider.INSTANCE, this.cradle)));
    }

    public Style getDataStyle(boolean withAdditional) {
        Style superStyle = InlineData.super.asStyle(withAdditional);
        if (!withAdditional) {
            return superStyle;
        }
        return superStyle.m_131146_(Style.f_131099_.m_131144_(this.getEntityDisplayHoverEvent()));
    }

    public static class EntityDataType
    implements InlineData.InlineDataType<EntityInlineData> {
        public static EntityDataType INSTANCE = new EntityDataType();

        @Override
        public ResourceLocation getId() {
            return new ResourceLocation("inline", "entity");
        }

        @Override
        public Codec<EntityInlineData> getCodec() {
            return EntityCradle.CRADLE_CODEC.xmap(EntityInlineData::new, data -> data.cradle);
        }
    }
}

