/*
 * Decompiled with CFR 0.152.
 */
package net.moddercoder.immortalsoul.util;

public class TimeableAction {
    public static final int NONE = -1;
    private int ticks = -1;
    private int ticksDuration = -1;
    private Runnable runnableEnd = () -> {};
    private Runnable runnableStart = () -> {};

    public TimeableAction(Runnable runnableEnd) {
        this.runnableEnd = runnableEnd;
    }

    public TimeableAction onStartAnimation(Runnable runnableStart) {
        this.setOnStart(runnableStart);
        return this;
    }

    public TimeableAction onEndAnimation(Runnable runnableEnd) {
        this.setOnEnd(runnableEnd);
        return this;
    }

    public void setOnStart(Runnable runnableStart) {
        this.runnableStart = runnableStart;
    }

    public void setOnEnd(Runnable runnableEnd) {
        this.runnableEnd = runnableEnd;
    }

    public void start(int ticksDuration, boolean force) {
        if (!this.isRunning() || force) {
            this.runnableStart.run();
            this.ticksDuration = ticksDuration;
            this.ticks = 0;
        }
    }

    public void start(int ticksDuration) {
        this.start(ticksDuration, false);
    }

    public void update() {
        if (this.isRunning()) {
            this.ticks = Math.min(this.ticks + 1, this.ticksDuration);
            if (this.ticks >= this.ticksDuration) {
                this.end();
            }
        }
    }

    public void stop() {
        this.ticksDuration = -1;
        this.ticks = -1;
    }

    private void end() {
        this.stop();
        this.runnableEnd.run();
    }

    public int getDurationTicks() {
        return this.isRunning() ? this.ticksDuration : -1;
    }

    public int getCurrentTicks() {
        return this.ticks;
    }

    public boolean isRunning() {
        return this.ticks != -1 & this.ticksDuration != -1;
    }
}

