/*
 * Decompiled with CFR 0.152.
 */
package net.moddercoder.immortalsoul.item;

import java.util.List;
import java.util.UUID;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5712;
import net.moddercoder.immortalsoul.entity.ModEntityTypes;
import net.moddercoder.immortalsoul.entity.SoulGuideEntity;
import net.moddercoder.immortalsoul.sound.ModSoundEvents;
import org.jetbrains.annotations.Nullable;

public class KeyItem
extends class_1792 {
    public static int LIMIT_FOR_SOUL_GUIDE_SPAWN = 64;
    public static String NBT_SOUL_GUIDE_NAME = "SoulGuide";

    @Nullable
    public static UUID readSoulGuideUuidFromItemStack(class_1799 stack) {
        class_2487 nbtSoulGuide = stack.method_7941(NBT_SOUL_GUIDE_NAME);
        if (nbtSoulGuide != null && !nbtSoulGuide.method_33133() && nbtSoulGuide.method_25928("UUID")) {
            return nbtSoulGuide.method_25926("UUID");
        }
        return null;
    }

    public static class_1799 writeSoulGuideEmptyUuidToItemStack(class_1799 stack) {
        class_2487 nbtWithUuid = new class_2487();
        nbtWithUuid.method_25927("UUID", new UUID(0L, 0L));
        stack.method_7959(NBT_SOUL_GUIDE_NAME, (class_2520)nbtWithUuid);
        return stack;
    }

    public static boolean isKeyEmpty(class_1799 stack) {
        return KeyItem.readSoulGuideUuidFromItemStack(stack) != null;
    }

    public KeyItem(class_1792.class_1793 settings) {
        super(settings);
    }

    public class_1269 method_7884(class_1838 context) {
        class_1937 world = context.method_8045();
        if (world == null) {
            return class_1269.field_5814;
        }
        class_1799 stack = context.method_8041();
        class_2487 nbtSoulGuide = stack.method_7911(NBT_SOUL_GUIDE_NAME);
        if (nbtSoulGuide == null || nbtSoulGuide.method_33133()) {
            class_1657 playerEntity = context.method_8036();
            if (this.hasNearbySoulGuides(world, context.method_8037())) {
                playerEntity.method_7357().method_7906((class_1792)this, 40);
                playerEntity.method_5783(class_3417.field_15008, 1.0f, 1.0f);
                return class_1269.field_5812;
            }
            class_2338 placedBlockPos = context.method_8037().method_10093(context.method_8038());
            SoulGuideEntity soulGuideEntity = new SoulGuideEntity(ModEntityTypes.SOUL_GUIDE_ENTITY, world);
            soulGuideEntity.method_5725(placedBlockPos, -context.method_8044(), 0.0f);
            nbtSoulGuide.method_25927("UUID", soulGuideEntity.method_5667());
            stack.method_7959(NBT_SOUL_GUIDE_NAME, (class_2520)nbtSoulGuide);
            playerEntity.method_7357().method_7906((class_1792)this, 200);
            world.method_8649((class_1297)soulGuideEntity);
            world.method_43129(null, (class_1297)soulGuideEntity, ModSoundEvents.ENTITY_SOUL_GUIDE_APPEARANCE, class_3419.field_15254, 1.0f, 1.0f);
            world.method_33596((class_1297)playerEntity, class_5712.field_28738, placedBlockPos);
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    public class_1269 method_7847(class_1799 _stack, class_1657 user, class_1309 entity, class_1268 hand) {
        if (entity instanceof SoulGuideEntity) {
            SoulGuideEntity soulGuideEntity = (SoulGuideEntity)entity;
            class_1937 world = soulGuideEntity.method_5770();
            if (world == null) {
                return class_1269.field_5811;
            }
            class_1799 stack = user.method_5998(hand);
            UUID uuidSoulGuide = KeyItem.readSoulGuideUuidFromItemStack(stack);
            if (uuidSoulGuide != null && uuidSoulGuide.equals(soulGuideEntity.method_5667())) {
                stack.method_7983(NBT_SOUL_GUIDE_NAME);
                world.method_43129(null, (class_1297)soulGuideEntity, ModSoundEvents.ENTITY_SOUL_GUIDE_DISAPPEARANCE, class_3419.field_15254, 1.0f, 1.0f);
                soulGuideEntity.method_31472();
            }
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    private boolean hasNearbySoulGuides(class_1937 world, class_2338 position) {
        class_238 box = new class_238(-1.0, -1.0, -1.0, 1.0, 1.0, 1.0).method_1014((double)LIMIT_FOR_SOUL_GUIDE_SPAWN).method_996(position);
        List soulGuideEntities = world.method_8390(SoulGuideEntity.class, box, entity -> true);
        for (SoulGuideEntity _soulGuideEntity : soulGuideEntities) {
            if (!(_soulGuideEntity.method_5649(position.method_10263(), position.method_10264(), position.method_10260()) <= (double)(LIMIT_FOR_SOUL_GUIDE_SPAWN * LIMIT_FOR_SOUL_GUIDE_SPAWN))) continue;
            return true;
        }
        return false;
    }

    public class_2561 method_7864(class_1799 stack) {
        return class_2561.method_43471((String)(this.method_7866(stack) + (KeyItem.isKeyEmpty(stack) ? ".empty" : ".filled")));
    }

    public boolean method_7886(class_1799 stack) {
        return !KeyItem.isKeyEmpty(stack);
    }
}

