/*
 * Decompiled with CFR 0.152.
 */
package net.moddercoder.immortalsoul.fastcfg.io;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.ReadOnlyFileSystemException;
import net.fabricmc.loader.api.FabricLoader;
import net.moddercoder.immortalsoul.ImmortalSoul;
import net.moddercoder.immortalsoul.fastcfg.IFastConfig;
import org.jetbrains.annotations.Nullable;

public record FastConfigIO<T extends IFastConfig>(String configName, Codec<T> codec, T defaultConfig) {
    private static final String FORMAT_POSTFIX = ".json";
    private static final String VERSION_METADATA_NAME = "_immortalsoul_version";
    private static final Path CONFIG_FOLDER_PATH = Path.of(FabricLoader.getInstance().getConfigDir().toString(), "immortalsoul");

    public T initConfig() {
        File configFile = this.getConfigFile();
        if (configFile.exists()) {
            T loadedConfig = this.loadConfig();
            if (loadedConfig == null) {
                configFile.delete();
                return this.saveDefaultConfig();
            }
            return loadedConfig;
        }
        return this.saveDefaultConfig();
    }

    public void saveConfig(T config) {
        try (FileWriter writer = new FileWriter(this.getConfigFile());){
            JsonElement jsonifyConfig = this.getJsonifyConfig(config);
            jsonifyConfig.getAsJsonObject().addProperty(VERSION_METADATA_NAME, "1.1.3.2");
            String data = ImmortalSoul.GSON.toJson(jsonifyConfig);
            writer.write(data);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    protected T saveDefaultConfig() {
        this.saveConfig(this.defaultConfig());
        return this.defaultConfig();
    }

    @Nullable
    public T loadConfig() {
        try {
            String jsonityConfigData = new String(Files.readAllBytes(this.getConfigFilePath()), StandardCharsets.UTF_8);
            JsonElement jsonifyConfig = JsonParser.parseString((String)jsonityConfigData);
            String modVersionMetadata = jsonifyConfig.getAsJsonObject().get(VERSION_METADATA_NAME).getAsString();
            this.processVersionMetadata(modVersionMetadata);
            jsonifyConfig.getAsJsonObject().remove(VERSION_METADATA_NAME);
            return this.getConfigFromJson(jsonifyConfig);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return null;
        }
        catch (JsonSyntaxException jse) {
            jse.printStackTrace();
            return null;
        }
    }

    private void processVersionMetadata(String string) {
    }

    @Nullable
    public T getConfigFromJson(JsonElement json) {
        DataResult result = this.codec.parse((DynamicOps)JsonOps.INSTANCE, (Object)json);
        if (result.result().isPresent()) {
            return (T)((IFastConfig)result.result().get());
        }
        return null;
    }

    @Nullable
    public JsonElement getJsonifyConfig(T config) {
        DataResult result = this.codec.encodeStart((DynamicOps)JsonOps.INSTANCE, config);
        if (result.result().isPresent()) {
            return (JsonElement)result.result().get();
        }
        return null;
    }

    @Nullable(value="Null if unable to create or delete folder/file in system (Enough rare way)")
    public @Nullable(value="Null if unable to create or delete folder/file in system (Enough rare way)") File getConfigFile() {
        File configFolder = this.getOrCreateConfigFolder();
        if (configFolder != null) {
            return this.getConfigFilePath().toFile();
        }
        return null;
    }

    public Path getConfigFilePath() {
        return Path.of(this.getConfigFolderPath().toString(), this.configName().concat(FORMAT_POSTFIX));
    }

    @Nullable(value="Null if unable to create or delete folder/file in system (Enough rare way)")
    public @Nullable(value="Null if unable to create or delete folder/file in system (Enough rare way)") File getOrCreateConfigFolder() {
        File configFolder = this.getConfigFolderPath().toFile();
        if (configFolder.exists()) {
            if (configFolder.isFile()) {
                if (!configFolder.delete()) {
                    return null;
                }
                return this.createFolder(configFolder);
            }
            return configFolder;
        }
        return this.createFolder(configFolder);
    }

    public Path getConfigFolderPath() {
        return CONFIG_FOLDER_PATH;
    }

    protected File createFolder(File file) {
        if (!file.mkdirs()) {
            throw new ReadOnlyFileSystemException();
        }
        return file;
    }
}

