/*
 * Decompiled with CFR 0.152.
 */
package net.moddercoder.immortalsoul.entity;

import com.google.common.collect.ImmutableMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import java.util.UUID;
import mod.azure.azurelib.animatable.GeoEntity;
import mod.azure.azurelib.core.animatable.GeoAnimatable;
import mod.azure.azurelib.core.animatable.instance.AnimatableInstanceCache;
import mod.azure.azurelib.core.animation.AnimatableManager;
import mod.azure.azurelib.core.animation.AnimationController;
import mod.azure.azurelib.core.animation.RawAnimation;
import mod.azure.azurelib.core.object.PlayState;
import mod.azure.azurelib.util.AzureLibUtil;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1376;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1914;
import net.minecraft.class_1915;
import net.minecraft.class_1916;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3853;
import net.minecraft.class_3908;
import net.minecraft.class_3988;
import net.minecraft.class_5819;
import net.moddercoder.immortalsoul.diamond.block.ModBlocksDiamond;
import net.moddercoder.immortalsoul.item.KeyItem;
import net.moddercoder.immortalsoul.item.ModItems;
import net.moddercoder.immortalsoul.item.ModItemsGold;
import net.moddercoder.immortalsoul.reference.Reference;
import net.moddercoder.immortalsoul.screen.SoulGuideScreenHandler;
import net.moddercoder.immortalsoul.sound.ModSoundEvents;
import org.apache.commons.lang3.ArrayUtils;
import org.joml.Vector3f;

public class SoulGuideEntity
extends class_3988
implements GeoEntity {
    private static final class_3853.class_1652[] TRADE_OFFER_FACTORY = new class_3853.class_1652[]{new SellItemFactoryForSoul(ModItems.SOUL_COMPASS.method_7854(), 1, 1, Integer.MAX_VALUE, 0, 1.0f), new SellItemFactoryForSoul(ModItems.SCYTHE_REAPER.method_7854(), 6, 1, Integer.MAX_VALUE, 0, 1.0f), new SellItemFactoryForSoul(ModItems.SOLAR_CROWN.method_7854(), 20, 1, Integer.MAX_VALUE, 0, 1.0f), new SellItemFactoryForSoul(ModItems.LUNAR_CROWN.method_7854(), 20, 1, Integer.MAX_VALUE, 0, 1.0f), new SellItemFactoryForSoul(ModItems.ENERGY_CUBE.method_7854(), 12, 1, Integer.MAX_VALUE, 0, 1.0f), new SellItemFactoryForSoul(ModItems.SCROLL_RETURN.method_7854(), 5, 1, Integer.MAX_VALUE, 0, 1.0f), new SellItemFactoryForSoul(ModItems.SCROLL_TELEPORT.method_7854(), 33, 1, Integer.MAX_VALUE, 0, 1.0f)};
    public static final Int2ObjectMap<class_3853.class_1652[]> SOUL_GUIDE_TRADES = new Int2ObjectOpenHashMap((Map)ImmutableMap.of((Object)1, (Object)(Reference.VERSION_TYPE.isDiamond() ? (class_3853.class_1652[])ArrayUtils.addAll((Object[])TRADE_OFFER_FACTORY, (Object[])new class_3853.class_1652[]{new SellItemFactoryForSoul(ModItemsGold.VAMPIRE_TOME.method_7854(), 30, 1, Integer.MAX_VALUE, 0, 1.0f), new SellItemFactoryForSoul(ModBlocksDiamond.CURSED_CHEST.method_8389().method_7854(), 13, 1, Integer.MAX_VALUE, 0, 1.0f), new SellItemFactoryForSoul(ModBlocksDiamond.MOB_WARD.method_8389().method_7854(), 20, 1, Integer.MAX_VALUE, 0, 1.0f)}) : (Reference.VERSION_TYPE.isGold() ? (class_3853.class_1652[])ArrayUtils.addAll((Object[])TRADE_OFFER_FACTORY, (Object[])new class_3853.class_1652[]{new SellItemFactoryForSoul(ModItemsGold.VAMPIRE_TOME.method_7854(), 30, 1, Integer.MAX_VALUE, 0, 1.0f)}) : TRADE_OFFER_FACTORY))));
    private final AnimatableInstanceCache animatableInstanceCache = AzureLibUtil.createInstanceCache((GeoAnimatable)this);
    public static final RawAnimation ANIMATION_IDLE = RawAnimation.begin().thenLoop("idle");
    public static final RawAnimation ANIMATION_IDLE_2 = RawAnimation.begin().thenPlay("idle_2");
    public static final RawAnimation ANIMATION_IDLE_3 = RawAnimation.begin().thenPlay("idle_3");
    public static final RawAnimation ANIMATION_BUFF = RawAnimation.begin().thenPlay("buff");
    public static final int TICKS_SPECIAL_IDLE_ANIMATION_TIMEOUT = 400;
    public static final float SPECIAL_IDLE_ANIMATION_CHANCE = 0.05f;
    private int idle3AnimationPlayingTicks = 0;
    private final int SPECIAL_IDLE_3_ANIMATION_DURATION = 65;
    private boolean specialIdle3AnimationPlaying = false;
    private final HashMap<Vector3f, Integer> particleTimingsForSpecialIdle3Animation = new HashMap<Vector3f, Integer>(Map.of(new Vector3f(0.4f, 0.1f, 0.4f), 35, new Vector3f(0.4f, 0.3f, 0.45f), 37, new Vector3f(0.3f, 0.5f, 0.45f), 40, new Vector3f(0.4f, 0.5f, 0.1f), 42, new Vector3f(0.3f, 0.45f, 0.2f), 43, new Vector3f(0.3f, 0.4f, 0.25f), 44, new Vector3f(0.25f, 0.38f, 0.2f), 45, new Vector3f(0.2f, 0.35f, 0.3f), 47));
    private int specialIdleAnimationTimeoutTicks = 0;

    public SoulGuideEntity(class_1299<? extends class_3988> entityType, class_1937 world) {
        super(entityType, world);
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new class_1361((class_1308)this, class_1657.class, 6.0f, 1.1f));
        this.field_6201.method_6277(2, (class_1352)new class_1376((class_1308)this));
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", state -> state.isMoving() ? PlayState.STOP : state.setAndContinue(ANIMATION_IDLE))});
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controllerIdle2", state -> PlayState.STOP).triggerableAnim("idle_2", ANIMATION_IDLE_2)});
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controllerIdle3", state -> PlayState.STOP).triggerableAnim("idle_3", ANIMATION_IDLE_3)});
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controllerBuff", state -> PlayState.STOP).triggerableAnim("buff", ANIMATION_BUFF)});
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        class_1937 world = this.method_5770();
        if (!stack.method_31574(ModItems.KEY) && this.method_5805() && !this.method_18009() && !this.method_6109()) {
            if (this.method_8264().isEmpty()) {
                return class_1269.method_29236((boolean)world.field_9236);
            }
            if (!world.field_9236) {
                this.method_8259(player);
                this.method_8264().clear();
                this.method_7237();
                this.method_17449(player, this.method_5476(), 1);
            }
            return class_1269.method_29236((boolean)world.field_9236);
        }
        return super.method_5992(player, hand);
    }

    public boolean method_5643(class_1282 source, float amount) {
        if (super.method_5643(source, amount) && !this.method_29504()) {
            class_3218 serverWorld = (class_3218)this.method_5770();
            List players = serverWorld.method_18456();
            for (class_3222 player : players) {
                class_1661 inventory = player.method_31548();
                for (int i = 0; i < inventory.method_5439(); ++i) {
                    UUID uuidSoulGuide;
                    class_1799 stack = inventory.method_5438(i);
                    if (stack.method_7960() || (uuidSoulGuide = KeyItem.readSoulGuideUuidFromItemStack(stack)) == null || !uuidSoulGuide.equals(this.method_5667())) continue;
                    stack.method_7983(KeyItem.NBT_SOUL_GUIDE_NAME);
                    serverWorld.method_45447(null, this.method_24515(), ModSoundEvents.ENTITY_SOUL_GUIDE_DISAPPEARANCE, class_3419.field_15254);
                    this.method_31472();
                    return true;
                }
            }
            serverWorld.method_45447(null, this.method_24515(), ModSoundEvents.ENTITY_SOUL_GUIDE_DISAPPEARANCE, class_3419.field_15254);
            this.method_31472();
            return true;
        }
        return true;
    }

    public void method_5670() {
        super.method_5670();
        class_1937 world = this.method_37908();
        if (!world.field_9236) {
            if (this.specialIdle3AnimationPlaying && this.idle3AnimationPlayingTicks < this.SPECIAL_IDLE_3_ANIMATION_DURATION) {
                ++this.idle3AnimationPlayingTicks;
                this.particleTimingsForSpecialIdle3Animation.entrySet().forEach(entry -> {
                    if (this.idle3AnimationPlayingTicks == (Integer)entry.getValue()) {
                        Vector3f offset = (Vector3f)entry.getKey();
                        this.spawnParticleRelativeSelf((class_2394)new class_2388(class_2398.field_11206, class_2246.field_10102.method_9564()), world, offset.x, offset.y, offset.z, 2, 0.0, 0.0, 0.0, 0.0);
                    }
                });
                if (this.idle3AnimationPlayingTicks >= this.SPECIAL_IDLE_3_ANIMATION_DURATION) {
                    this.specialIdle3AnimationPlaying = false;
                    this.idle3AnimationPlayingTicks = 0;
                }
            }
            if (this.specialIdleAnimationTimeoutTicks < 400) {
                ++this.specialIdleAnimationTimeoutTicks;
            } else if (this.field_5974.method_43057() <= 0.05f) {
                this.playSpecialIdleAnimation();
            }
        }
    }

    public void playSpecialIdleAnimation() {
        boolean chanceForIdle2 = false;
        boolean chanceForIdle3 = true;
        int chance = this.field_5974.method_43048(2);
        this.triggerAnim(chance == 0 ? "controllerIdle2" : "controllerIdle3", chance == 0 ? "idle_2" : "idle_3");
        if (chance == 1) {
            this.specialIdle3AnimationPlaying = true;
        }
        this.specialIdleAnimationTimeoutTicks = 0;
    }

    private void spawnParticleRelativeSelf(class_2394 particleEffect, class_1937 world, double offsetX, double offsetY, double offsetZ, int count, double deltaX, double deltaY, double deltaZ, double speed) {
        if (!world.field_9236) {
            float degToRadFactor = (float)Math.PI / 180;
            float normalizeDirLookXForRelativeX = -class_3532.method_15374((float)(this.method_43078() * ((float)Math.PI / 180))) * class_3532.method_15362((float)(this.method_36455() * ((float)Math.PI / 180)));
            float normalizeDirLookZForRelativeX = class_3532.method_15362((float)(this.method_43078() * ((float)Math.PI / 180))) * class_3532.method_15362((float)(this.method_36455() * ((float)Math.PI / 180)));
            float normalizeDirLookXForRelativeZ = -class_3532.method_15374((float)((this.method_43078() - 90.0f) * ((float)Math.PI / 180))) * class_3532.method_15362((float)(this.method_36455() * ((float)Math.PI / 180)));
            float normalizeDirLookZForRelativeZ = class_3532.method_15362((float)((this.method_43078() - 90.0f) * ((float)Math.PI / 180))) * class_3532.method_15362((float)(this.method_36455() * ((float)Math.PI / 180)));
            double offsetGlobalX = (double)normalizeDirLookXForRelativeX * offsetX + (double)normalizeDirLookXForRelativeZ * offsetZ;
            double offsetGlobalZ = (double)normalizeDirLookZForRelativeX * offsetX + (double)normalizeDirLookZForRelativeZ * offsetZ;
            ((class_3218)world).method_14199(particleEffect, this.method_23317() + offsetGlobalX, this.method_23318() + offsetY, this.method_23321() + offsetGlobalZ, count, deltaX, deltaY, deltaZ, speed);
        }
    }

    public class_1296 method_5613(class_3218 serverWorld, class_1296 passiveEntity) {
        return null;
    }

    public boolean method_5974(double distanceSquared) {
        return false;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.animatableInstanceCache;
    }

    protected void method_18008(class_1914 tradeOffer) {
    }

    public boolean method_19270() {
        return false;
    }

    protected void method_7237() {
        class_1916 tradeOfferList = this.method_8264();
        class_3853.class_1652[] factories = (class_3853.class_1652[])SOUL_GUIDE_TRADES.get(1);
        for (int i = 0; i < factories.length; ++i) {
            class_1914 tradeOffer = factories[i].method_7246((class_1297)this, this.field_5974);
            if (tradeOffer == null) continue;
            tradeOfferList.add((Object)tradeOffer);
        }
    }

    public void method_17449(class_1657 player, class_2561 test, int levelProgress) {
        class_1916 tradeOfferList;
        OptionalInt optionalInt = player.method_17355((class_3908)new ExtendedScreenHandlerFactory(){

            public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 playerEntity) {
                return new SoulGuideScreenHandler(syncId, playerInventory, (class_1915)SoulGuideEntity.this);
            }

            public class_2561 method_5476() {
                return SoulGuideEntity.this.method_5476();
            }

            public void writeScreenOpeningData(class_3222 player, class_2540 buf) {
            }
        });
        if (optionalInt.isPresent() && !(tradeOfferList = this.method_8264()).isEmpty()) {
            player.method_17354(optionalInt.getAsInt(), tradeOfferList, levelProgress, this.method_19269(), this.method_19270(), this.method_20708());
        }
    }

    public void method_8258(class_1799 stack) {
    }

    public void method_20010() {
    }

    public static class SellItemFactoryForSoul
    extends class_3853.class_4165 {
        private final class_1799 sell;
        private final int price;
        private final int count;
        private final int maxUses;
        private final int experience;
        private final float multiplier;

        public SellItemFactoryForSoul(class_2248 block, int price, int count, int maxUses, int experience) {
            this(new class_1799((class_1935)block), price, count, maxUses, experience);
        }

        public SellItemFactoryForSoul(class_1792 item, int price, int count, int experience) {
            this(new class_1799((class_1935)item), price, count, 12, experience);
        }

        public SellItemFactoryForSoul(class_1792 item, int price, int count, int maxUses, int experience) {
            this(new class_1799((class_1935)item), price, count, maxUses, experience);
        }

        public SellItemFactoryForSoul(class_1799 stack, int price, int count, int maxUses, int experience) {
            this(stack, price, count, maxUses, experience, 0.05f);
        }

        public SellItemFactoryForSoul(class_1799 stack, int price, int count, int maxUses, int experience, float multiplier) {
            super(stack, price, count, maxUses, experience, multiplier);
            this.sell = stack;
            this.price = price;
            this.count = count;
            this.maxUses = maxUses;
            this.experience = experience;
            this.multiplier = multiplier;
        }

        public class_1914 method_7246(class_1297 entity, class_5819 random) {
            return new class_1914(new class_1799((class_1935)ModItems.SOUL, this.price), new class_1799((class_1935)this.sell.method_7909(), this.count), this.maxUses, this.experience, this.multiplier);
        }
    }
}

