/*
 * Decompiled with CFR 0.152.
 */
package net.moddercoder.immortalsoul.diamond.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1301;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1831;
import net.minecraft.class_1832;
import net.minecraft.class_1834;
import net.minecraft.class_1839;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2390;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_3532;
import net.minecraft.class_5134;
import net.minecraft.class_5819;
import net.moddercoder.immortalsoul.diamond.sound.ModSoundEventsDiamond;
import net.moddercoder.immortalsoul.entity.FXEntity;
import net.moddercoder.immortalsoul.item.IAttackBarVisualizedItem;
import net.moddercoder.immortalsoul.item.ModItemsDiamond;
import net.moddercoder.immortalsoul.item.ModItemsGold;
import net.moddercoder.immortalsoul.util.ColorVectorHelper;

public class EnergyGloveActivateItem
extends class_1831
implements IAttackBarVisualizedItem {
    public static final String NBT_GLOVE_DATA_NAME = "GloveData";
    public static final String NBT_HIT_COUNT_NAME = "HitCount";
    public static final int RESET_POWERFUL_ATTACK_DURATION = 100;
    public static final int ATTACK_COUNT_FOR_POWERFUL = 3;
    public static final int DASH_ATTACK_DURATION = 40;
    public static final float DASH_ATTACK_RADIUS = 2.0f;
    public static final int SHIELD_COOLDOWN = 1200;
    public static final int SHIELD_DURATION = 200;
    public static final int USAGE_DURATION = 40;
    private ConcurrentHashMap<UUID, Integer> shieldDurationMap = new ConcurrentHashMap(4);
    private ConcurrentHashMap<UUID, DashAttackData> dashAttackPlayerMap = new ConcurrentHashMap(4);
    private ConcurrentHashMap<UUID, Integer> resetPowerfulAttackDurationMap = new ConcurrentHashMap(4);
    private final int attackDamage;
    private final float attackSpeed;
    private final Multimap<class_1320, class_1322> attributeModifiers;
    protected static final DashAttackData NULL_DASH_ATTACK_DATA = DashAttackData.of(null, -1);

    public static boolean incrementHitCount(class_1799 stack) {
        if (!stack.method_31574((class_1792)ModItemsDiamond.ENERGY_GLOVE_ACTIVE)) {
            return false;
        }
        class_2487 nbt = stack.method_7911(NBT_GLOVE_DATA_NAME);
        boolean powerfulAttack = false;
        int hitCount = 1;
        if (!nbt.method_33133() && (hitCount = nbt.method_10550(NBT_HIT_COUNT_NAME) + 1) >= 3) {
            powerfulAttack = true;
            hitCount = 0;
        }
        nbt.method_10569(NBT_HIT_COUNT_NAME, hitCount);
        return powerfulAttack;
    }

    public static void resetHitCount(class_1799 stack) {
        if (!stack.method_31574((class_1792)ModItemsDiamond.ENERGY_GLOVE_ACTIVE)) {
            return;
        }
        class_2487 nbt = stack.method_7911(NBT_GLOVE_DATA_NAME);
        nbt.method_10569(NBT_HIT_COUNT_NAME, 0);
    }

    public static int getHitCount(class_1799 stack) {
        if (!stack.method_31574((class_1792)ModItemsDiamond.ENERGY_GLOVE_ACTIVE)) {
            return -1;
        }
        class_2487 nbt = stack.method_7911(NBT_GLOVE_DATA_NAME);
        return nbt.method_10550(NBT_HIT_COUNT_NAME);
    }

    public EnergyGloveActivateItem(int attackDamage, float attackSpeed, int maxUses, class_1792.class_1793 settings) {
        super((class_1832)class_1834.field_8923, settings.method_7895(maxUses));
        this.attackSpeed = attackSpeed;
        this.attackDamage = attackDamage;
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)class_5134.field_23721, (Object)new class_1322(field_8006, "Tool modifier", (double)this.attackDamage, class_1322.class_1323.field_6328));
        builder.put((Object)class_5134.field_23723, (Object)new class_1322(field_8001, "Tool modifier", (double)this.attackSpeed, class_1322.class_1323.field_6328));
        this.attributeModifiers = builder.build();
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        class_1799 mainHandItemStack = user.method_5998(class_1268.field_5808);
        class_1799 offHandItemStack = user.method_5998(class_1268.field_5810);
        if (offHandItemStack.method_31574(ModItemsGold.ENERGY_CUBE) && mainHandItemStack.method_7919() > 0) {
            user.method_6122(class_1268.field_5808, ModItemsDiamond.ENERGY_GLOVE_ACTIVE.method_7854());
            world.method_8396(null, user.method_24515(), class_3417.field_15217, class_3419.field_15248, 1.0f, 1.5f);
            if (!user.method_7337()) {
                offHandItemStack.method_7934(1);
            }
            return class_1271.method_22427((Object)mainHandItemStack);
        }
        if (offHandItemStack.method_31574((class_1792)this) && mainHandItemStack.method_31574((class_1792)this)) {
            user.method_6019(hand);
            user.method_7350();
            return class_1271.method_22428((Object)mainHandItemStack);
        }
        return super.method_7836(world, user, hand);
    }

    public void method_7852(class_1937 world, class_1309 user, class_1799 stack, int remainingUseTicks) {
        int usageTicks = this.calcUsageTicks(stack, remainingUseTicks);
        if (!world.field_9236 && world.method_8510() % 5L == 0L) {
            class_2390 particleEffect = new class_2390(ColorVectorHelper.randomizeColor(ColorVectorHelper.WHITE_COLOR_VECTOR, 0.05f, world.field_9229), 0.8f);
            int particleCount = 2 + (int)((float)usageTicks / 40.0f * 6.0f);
            this.spawnParticlesFromServerAroundGlove((class_2394)particleEffect, user, particleCount, world);
        }
        if (usageTicks == 39) {
            world.method_43129(null, (class_1297)user, ModSoundEventsDiamond.ITEM_ENERGY_GLOVE_CHARGE, class_3419.field_15248, 1.0f, 1.0f);
        }
    }

    public void method_7840(class_1799 stack, class_1937 world, class_1309 user, int remainingUseTicks) {
        super.method_7840(stack, world, user, remainingUseTicks);
        if (user instanceof class_1657) {
            class_1657 playerEntity = (class_1657)user;
            class_1799 mainHandItemStack = user.method_5998(class_1268.field_5808);
            class_1799 offHandItemStack = user.method_5998(class_1268.field_5810);
            if (!offHandItemStack.method_31574((class_1792)this) || !mainHandItemStack.method_31574((class_1792)this)) {
                return;
            }
            int usageTicks = this.calcUsageTicks(stack, remainingUseTicks);
            if (usageTicks >= 40) {
                float zVelFactor;
                float xVel = class_3532.method_15374((float)(-playerEntity.method_36454() * ((float)Math.PI / 180))) * class_3532.method_15362((float)(-playerEntity.method_36455() * ((float)Math.PI / 180)));
                float yVel = class_3532.method_15374((float)(-playerEntity.method_36455() * ((float)Math.PI / 180)));
                float zVel = class_3532.method_15362((float)(playerEntity.method_36454() * ((float)Math.PI / 180))) * class_3532.method_15362((float)(-playerEntity.method_36455() * ((float)Math.PI / 180)));
                boolean playerGround = playerEntity.method_24828();
                float xVelFactor = playerGround ? 3.0f : 2.0f;
                float yVelFactor = 0.5f;
                float f = zVelFactor = playerGround ? 3.0f : 2.0f;
                if (playerGround && world.method_22347(playerEntity.method_24515().method_10086(2))) {
                    playerEntity.method_45166(0.0, 0.5, 0.0);
                }
                playerEntity.method_18799(new class_243((double)xVel, (double)yVel, (double)zVel).method_18805((double)xVelFactor, 0.5, (double)zVelFactor));
                if (!world.field_9236) {
                    EnergyGloveActivateItem.applyDataToConcurrentHashMap(this.dashAttackPlayerMap, playerEntity.method_5667(), DashAttackData.of(playerEntity, 40));
                }
                if (!this.checkStackForSetDownAndChangeIfNeed(mainHandItemStack, class_1268.field_5808, (class_1309)playerEntity)) {
                    mainHandItemStack.method_7956(1, (class_1309)playerEntity, _playerEntity -> _playerEntity.method_20236(class_1268.field_5808));
                }
                if (!this.checkStackForSetDownAndChangeIfNeed(offHandItemStack, class_1268.field_5810, (class_1309)playerEntity)) {
                    offHandItemStack.method_7956(1, (class_1309)playerEntity, _playerEntity -> _playerEntity.method_20236(class_1268.field_5810));
                }
                if (!playerEntity.method_7337()) {
                    playerEntity.method_7357().method_7906((class_1792)this, 300);
                }
                world.method_43129(null, (class_1297)playerEntity, ModSoundEventsDiamond.ITEM_ENERGY_GLOVE_DASH, class_3419.field_15248, 1.0f, 1.0f);
                playerEntity.method_7259(class_3468.field_15372.method_14956((Object)this));
            } else if (usageTicks >= 5) {
                playerEntity.method_7357().method_7906((class_1792)this, 60);
                playerEntity.method_7259(class_3468.field_15372.method_14956((Object)this));
            }
        }
    }

    private int calcUsageTicks(class_1799 stack, int remainingUseTicks) {
        return class_3532.method_15340((int)(this.method_7881(stack) - remainingUseTicks), (int)0, (int)40);
    }

    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
        if (entity instanceof class_1309) {
            class_1309 livingEntity = (class_1309)entity;
            boolean mainStackIsGlove = livingEntity.method_6047().method_31574((class_1792)this);
            if (mainStackIsGlove && EnergyGloveActivateItem.getHitCount(stack) + 1 >= 3 && world.method_8510() % 2L == 0L && !world.field_9236) {
                this.spawnParticlesFromServerAroundGlove((class_2394)new class_2390(ColorVectorHelper.GRAY_COLOR_VECTOR, 0.75f), livingEntity, 1, world);
            }
            if (livingEntity instanceof class_1657) {
                class_1657 playerEntity = (class_1657)livingEntity;
                if (!world.field_9236) {
                    Map.Entry<UUID, DashAttackData> dashAttackPlayerMapEntry;
                    Set<Map.Entry<UUID, DashAttackData>> dashAttackPlayerMapEntrySet;
                    Iterator<Map.Entry<UUID, DashAttackData>> iterator;
                    Set<Map.Entry<UUID, Integer>> resetPowerfulAttackDurationMapEntrySet = this.resetPowerfulAttackDurationMap.entrySet();
                    for (Map.Entry<UUID, Integer> entry : resetPowerfulAttackDurationMapEntrySet) {
                        int resetPowerfulAttackDuration = entry.getValue();
                        if (!entry.getKey().equals(playerEntity.method_5667())) continue;
                        if (resetPowerfulAttackDuration < 100) {
                            entry.setValue(resetPowerfulAttackDuration + 1);
                            break;
                        }
                        entry.setValue(0);
                        EnergyGloveActivateItem.resetHitCount(stack);
                        break;
                    }
                    if ((iterator = (dashAttackPlayerMapEntrySet = this.dashAttackPlayerMap.entrySet()).iterator()).hasNext() && (dashAttackPlayerMapEntry = iterator.next()).getKey().equals(playerEntity.method_5667())) {
                        DashAttackData valueData = dashAttackPlayerMapEntry.getValue();
                        valueData.tick();
                        boolean stopDashAttack = false;
                        if (!valueData.isEnd()) {
                            if (mainStackIsGlove && playerEntity.method_18798().method_1027() >= 1.0) {
                                class_238 boxForEntities = new class_238(-1.0, -1.0, -1.0, 1.0, 1.0, 1.0).method_1014(2.0).method_996(playerEntity.method_24515().method_10084());
                                world.method_8390(class_1309.class, boxForEntities, _entity -> _entity != playerEntity && class_1301.field_6156.test(_entity) && !_entity.method_5722((class_1297)playerEntity)).forEach(_livingEntity -> {
                                    int _livingEntityId = _livingEntity.method_5628();
                                    if (!valueData.hasEntityIdUsed(_livingEntityId)) {
                                        _livingEntity.method_5643(world.method_48963().method_48812((class_1309)playerEntity), 15.0f);
                                        _livingEntity.method_18800(0.0, 1.0, 0.0);
                                        _livingEntity.field_6037 = true;
                                        valueData.addEntityIdToUsed(_livingEntityId);
                                    }
                                    if (!valueData.atOnceTargetExists) {
                                        if (!this.isShieldCoolingDown(playerEntity)) {
                                            world.method_43129(null, (class_1297)playerEntity, ModSoundEventsDiamond.ITEM_ENERGY_GLOVE_DASH, class_3419.field_15248, 1.0f, 1.0f);
                                            playerEntity.method_6092(new class_1293(class_1294.field_5907, 200, 2, true, false));
                                            EnergyGloveActivateItem.applyDataToConcurrentHashMap(this.shieldDurationMap, playerEntity.method_5667(), 1200);
                                        }
                                        valueData.atOnceTargetExists = true;
                                    }
                                });
                                ((class_3218)world).method_14199((class_2394)class_2398.field_17430, playerEntity.method_23317(), playerEntity.method_23320(), playerEntity.method_23321(), 1, 0.0, 0.0, 0.0, 0.0);
                            } else {
                                stopDashAttack = true;
                            }
                            if (stopDashAttack) {
                                dashAttackPlayerMapEntry.setValue(NULL_DASH_ATTACK_DATA);
                            }
                        } else {
                            stopDashAttack = true;
                        }
                    }
                    Set<Map.Entry<UUID, Integer>> set = this.shieldDurationMap.entrySet();
                    for (Map.Entry<UUID, Integer> shieldDurationMapEntry : set) {
                        int shieldDuration = shieldDurationMapEntry.getValue();
                        if (!shieldDurationMapEntry.getKey().equals(playerEntity.method_5667())) continue;
                        if (shieldDuration > 880) {
                            class_2390 shieldParticleEffect = new class_2390(ColorVectorHelper.randomizeColor(ColorVectorHelper.WHITE_COLOR_VECTOR, 0.05f, world.field_9229), 0.8f);
                            for (int i = 0; i < 4; ++i) {
                                ((class_3218)world).method_14199((class_2394)shieldParticleEffect, playerEntity.method_23322(0.5), playerEntity.method_23323(world.field_9229.method_43058() * 0.75), playerEntity.method_23325(0.5), 1, 0.0, 0.0, 0.0, 0.0);
                            }
                        }
                        if (shieldDuration <= 0) continue;
                        shieldDurationMapEntry.setValue(shieldDuration - 1);
                    }
                }
            }
        }
    }

    public boolean method_7873(class_1799 stack, class_1309 target, class_1309 attacker) {
        class_3414 hitSoundEvent;
        super.method_7873(stack, target, attacker);
        if (!this.checkStackForSetDownAndChangeIfNeed(stack, class_1268.field_5808, attacker)) {
            stack.method_7956(1, attacker, _attackerEntity -> _attackerEntity.method_20235(class_1304.field_6173));
        }
        class_1937 world = attacker.method_37908();
        class_243 strikeEffectPosition = attacker.method_19538().method_1020(target.method_19538()).method_1029().method_1021((double)target.method_17681()).method_1019(target.method_19538().method_1031(0.0, (double)(target.method_17682() / 2.0f), 0.0));
        if (EnergyGloveActivateItem.incrementHitCount(stack)) {
            attacker.method_6092(new class_1293(class_1294.field_5904, 60, 1, true, false));
            target.method_5643(world.method_48963().method_48812(attacker), 2.0f);
            target.method_6005(1.0, (double)((float)(attacker.method_23317() - target.method_23317())), (double)((float)(attacker.method_23321() - target.method_23321())));
            target.field_6037 = true;
            hitSoundEvent = ModSoundEventsDiamond.ITEM_ENERGY_GLOVE_BIG_PUNCH;
            this.spawnEffectEntity(world, strikeEffectPosition, (byte)-125, 15, -attacker.method_36454(), true).triggerAnim("controller", "base");
        } else {
            hitSoundEvent = ModSoundEventsDiamond.ITEM_ENERGY_GLOVE_SMALL_PUNCH;
            this.spawnEffectEntity(world, strikeEffectPosition, (byte)-126, 15, -attacker.method_36454(), true).triggerAnim("controller", "base");
        }
        if (attacker instanceof class_1657) {
            class_1657 attackerPlayerEntity = (class_1657)attacker;
            if (!world.field_9236) {
                EnergyGloveActivateItem.applyDataToConcurrentHashMap(this.resetPowerfulAttackDurationMap, attackerPlayerEntity.method_5667(), 0);
            }
        }
        class_243 soundPositionVec3d = new class_243(Math.abs(attacker.method_23317() - target.method_23317()), Math.abs(attacker.method_23318() - target.method_23318()), Math.abs(attacker.method_23321() - target.method_23321())).method_1021(0.5).method_1019(attacker.method_19538());
        world.method_43128(null, soundPositionVec3d.field_1352, soundPositionVec3d.field_1351, soundPositionVec3d.field_1350, hitSoundEvent, class_3419.field_15248, 1.0f, 1.0f);
        return true;
    }

    public class_1839 method_7853(class_1799 stack) {
        return class_1839.field_8953;
    }

    public int method_7881(class_1799 stack) {
        return 72000;
    }

    private FXEntity spawnEffectEntity(class_1937 world, class_243 position, byte modelId, int lifeTime, float yaw, boolean hasAnimation) {
        FXEntity fxEntity = new FXEntity(world, position.field_1352, position.field_1351, position.field_1350, hasAnimation);
        fxEntity.method_36456(yaw);
        fxEntity.setModelId(modelId);
        fxEntity.setLifeTime(lifeTime);
        world.method_8649((class_1297)fxEntity);
        return fxEntity;
    }

    private boolean checkStackForSetDownAndChangeIfNeed(class_1799 stack, class_1268 hand, class_1309 entity) {
        if (stack.method_7919() + 1 == stack.method_7936()) {
            entity.method_6122(hand, ModItemsDiamond.ENERGY_GLOVE_DEACTIVE.method_7854());
            return true;
        }
        return false;
    }

    private void spawnParticlesFromServerAroundGlove(class_2394 particleEffect, class_1309 user, int particleCount, class_1937 world) {
        class_5819 rand = world.method_8409();
        float x = class_3532.method_15374((float)(-user.method_36454() * ((float)Math.PI / 180))) * class_3532.method_15362((float)(-user.method_36455() * ((float)Math.PI / 180)));
        float z = class_3532.method_15362((float)(user.method_36454() * ((float)Math.PI / 180))) * class_3532.method_15362((float)(-user.method_36455() * ((float)Math.PI / 180)));
        float y = class_3532.method_15374((float)(-user.method_36455() * ((float)Math.PI / 180)));
        class_241 rotationVector = new class_241(x, z);
        float angle = -90.0f;
        float f = class_3532.method_15362((float)-1.5707964f);
        float g = class_3532.method_15374((float)-1.5707964f);
        float rotatedX = rotationVector.field_1343 * f + rotationVector.field_1342 * g;
        float rotatedZ = rotationVector.field_1342 * f - rotationVector.field_1343 * g;
        class_241 rotatedRotationVector = new class_241(rotatedX, rotatedZ);
        double xParticle = user.method_23317() + (double)rotatedRotationVector.field_1343 * 0.25 + (double)rotationVector.field_1343 * 0.25;
        double yParticle = user.method_23320() + (double)y * 0.25;
        double zParticle = user.method_23321() + (double)rotatedRotationVector.field_1342 * 0.25 + (double)rotationVector.field_1342 * 0.25;
        for (int i = 0; i < particleCount; ++i) {
            double xParticleOffset = (rand.method_43058() - rand.method_43058()) * 0.15;
            double zParticleOffset = (rand.method_43058() - rand.method_43058()) * 0.15;
            ((class_3218)world).method_14199(particleEffect, xParticle + xParticleOffset, yParticle, zParticle + zParticleOffset, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    public boolean isPlayerShield(class_1657 playerEntity) {
        return this.shieldDurationMap.containsKey(playerEntity.method_5667()) && this.shieldDurationMap.get(playerEntity.method_5667()) > 880;
    }

    public boolean method_7879(class_1799 stack, class_1937 world, class_2680 state, class_2338 pos, class_1309 miner) {
        return true;
    }

    public boolean method_7885(class_2680 state, class_1937 world, class_2338 pos, class_1657 miner) {
        return true;
    }

    public Multimap<class_1320, class_1322> method_7844(class_1304 slot) {
        if (slot == class_1304.field_6173) {
            return this.attributeModifiers;
        }
        return super.method_7844(slot);
    }

    public boolean method_7878(class_1799 stack, class_1799 ingredient) {
        return false;
    }

    public boolean method_7856(class_2680 state) {
        return false;
    }

    public boolean method_7870(class_1799 stack) {
        return false;
    }

    public int method_31571(class_1799 stack) {
        return 0x5555FF;
    }

    @Override
    public int getUsageAttackBarDuration(class_1657 usagePlayer) {
        return 40;
    }

    public int getAttackDamage() {
        return this.attackDamage;
    }

    protected static <K, V> void applyDataToConcurrentHashMap(ConcurrentHashMap<K, V> map, K key, V value) {
        if (map.contains(key)) {
            if (map.get(key) != value) {
                map.replace(key, value);
            }
        } else {
            map.put(key, value);
        }
    }

    protected boolean hasDashAttackData(class_1657 playerEntity) {
        return this.dashAttackPlayerMap.containsKey(playerEntity.method_5667()) && this.dashAttackPlayerMap.get(playerEntity.method_5667()) != NULL_DASH_ATTACK_DATA;
    }

    protected boolean isShieldCoolingDown(class_1657 playerEntity) {
        return this.shieldDurationMap.containsKey(playerEntity.method_5667()) && this.shieldDurationMap.get(playerEntity.method_5667()) > 0;
    }

    protected void resetDashAttackData(class_1657 playerEntity) {
        EnergyGloveActivateItem.applyDataToConcurrentHashMap(this.dashAttackPlayerMap, playerEntity.method_5667(), NULL_DASH_ATTACK_DATA);
    }

    protected static class DashAttackData {
        public final ArrayList<Integer> usedEntityIds;
        public boolean atOnceTargetExists = false;
        public final class_1657 playerEntity;
        public final int maxDurationTicks;
        private int durationTicks = 0;

        public static DashAttackData of(class_1657 playerEntity, int maxDurationTicks) {
            return new DashAttackData(playerEntity, maxDurationTicks);
        }

        public DashAttackData(class_1657 playerEntity, int maxDurationTicks) {
            this.playerEntity = playerEntity;
            this.maxDurationTicks = maxDurationTicks;
            this.usedEntityIds = playerEntity == null ? null : new ArrayList(16);
        }

        public void addEntityIdToUsed(int entityId) {
            if (!this.hasEntityIdUsed(entityId)) {
                this.usedEntityIds.add(entityId);
            }
        }

        public boolean hasEntityIdUsed(int entityId) {
            return this.usedEntityIds.contains(entityId);
        }

        public void tick() {
            if (this.durationTicks < this.maxDurationTicks) {
                ++this.durationTicks;
            }
        }

        public boolean isEnd() {
            return this.durationTicks >= this.maxDurationTicks;
        }
    }
}

