/*
 * Decompiled with CFR 0.152.
 */
package net.moddercoder.immortalsoul.diamond.block.entity;

import java.util.Collection;
import mod.azure.azurelib.animatable.GeoBlockEntity;
import mod.azure.azurelib.core.animatable.GeoAnimatable;
import mod.azure.azurelib.core.animatable.instance.AnimatableInstanceCache;
import mod.azure.azurelib.core.animation.AnimatableManager;
import mod.azure.azurelib.core.animation.AnimationController;
import mod.azure.azurelib.core.animation.RawAnimation;
import mod.azure.azurelib.util.AzureLibUtil;
import net.minecraft.class_1268;
import net.minecraft.class_1293;
import net.minecraft.class_1301;
import net.minecraft.class_1309;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2390;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3965;
import net.moddercoder.immortalsoul.diamond.block.MobWardBlock;
import net.moddercoder.immortalsoul.diamond.block.entity.ModBlockEntityTypesDiamond;
import net.moddercoder.immortalsoul.diamond.effect.ModStatusEffectsDiamond;
import org.joml.Vector3f;

public class MobWardBlockEntity
extends class_2586
implements GeoBlockEntity {
    private final AnimatableInstanceCache animatableInstanceCache = AzureLibUtil.createInstanceCache((GeoAnimatable)this);
    public static final RawAnimation ANIMATION_IDLE = RawAnimation.begin().thenLoop("idle");
    public static final int ACTIVE_DURATION = 24000;
    public static final String NBT_AFFECT_RADIUS_NAME = "AffectedRadius";
    public static final String NBT_ACTIVATE_TICKS_NAME = "ActivatedTicks";
    public static final String NBT_ACTIVATE_DURATION_TICKS_NAME = "ActivatedDurationTicks";
    private float affectRadius = 7.0f;
    private int activatedTicks = 0;
    private int activatedDurationTicks = 0;
    protected final Vector3f particleColor = new Vector3f(0.86f, 0.93f, 0.8f);
    protected final class_2390 particleEffect = new class_2390(this.particleColor, 1.25f);
    protected final class_2390 particleEffectLarge = new class_2390(this.particleColor, 1.4f);

    public MobWardBlockEntity(class_2338 pos, class_2680 state) {
        super(ModBlockEntityTypesDiamond.MOB_WARD, pos, state);
    }

    public boolean tryActivate(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        boolean nonHostileEntities = true;
        for (class_1309 affectedEntity : this.getAffectedLivingEntities()) {
            if (!(affectedEntity instanceof class_1588)) continue;
            nonHostileEntities = false;
            break;
        }
        if (nonHostileEntities) {
            this.activatedTicks = this.activatedDurationTicks = 24000;
            if (world.field_9236) {
                class_243 centerPos = pos.method_46558();
                for (float outerAngle = -90.0f; outerAngle <= 90.0f; outerAngle += 5.0f) {
                    for (float innerAngle = 0.0f; innerAngle <= 360.0f; innerAngle += 5.0f) {
                        double radInnerAngle = Math.toRadians(innerAngle);
                        double radOuterAngle = Math.toRadians(outerAngle);
                        double cosOuterAngle = Math.cos(radOuterAngle);
                        double yParticle = centerPos.field_1351 + Math.sin(radOuterAngle) * (double)this.getAffectRadius();
                        double xParticle = centerPos.field_1352 + Math.cos(radInnerAngle) * cosOuterAngle * (double)this.getAffectRadius();
                        double zParticle = centerPos.field_1350 + Math.sin(radInnerAngle) * cosOuterAngle * (double)this.getAffectRadius();
                        world.method_8494((class_2394)this.particleEffect, xParticle, yParticle, zParticle, 0.0, 0.0, 0.0);
                    }
                }
            }
        }
        return nonHostileEntities;
    }

    public void tick(class_1937 world, class_2338 blockPos, class_2680 state) {
        if (this.isActivated()) {
            --this.activatedTicks;
            if (this.activatedTicks % 20 == 0) {
                for (class_1309 livingEntity : this.getAffectedLivingEntities()) {
                    if (livingEntity instanceof class_1588) continue;
                    livingEntity.method_6092(new class_1293(ModStatusEffectsDiamond.MOB_WARD, 30, 0, false, false, true));
                }
                this.method_5431();
            }
            if (!this.isActivated()) {
                world.method_8501(blockPos, (class_2680)state.method_11657((class_2769)MobWardBlock.ACTIVATE, (Comparable)Boolean.valueOf(false)));
                world.method_8396(null, blockPos, class_3417.field_14930, class_3419.field_15245, 1.0f, 0.5f);
            }
        }
    }

    public void tickOnlyClient(class_1937 world, class_2338 blockPos, class_2680 state) {
        if (this.isActivated()) {
            class_243 centerPos = blockPos.method_46558();
            if (world.method_8510() % 2L == 0L) {
                for (int i = 0; i < 32; ++i) {
                    float outerAngle = (world.field_9229.method_43057() * 180.0f - 90.0f) * ((float)Math.PI / 180);
                    float innerAngle = world.field_9229.method_43057() * 180.0f * ((float)Math.PI / 180);
                    double cosAngle = Math.cos(outerAngle);
                    double xRelativeParticle = Math.cos(innerAngle) * cosAngle * (double)this.getAffectRadius();
                    double zRelativeParticle = Math.sin(innerAngle) * cosAngle * (double)this.getAffectRadius();
                    double x1Particle = centerPos.field_1352 + xRelativeParticle;
                    double z1Particle = centerPos.field_1350 + zRelativeParticle;
                    double x2Particle = centerPos.field_1352 - xRelativeParticle;
                    double z2Particle = centerPos.field_1350 - zRelativeParticle;
                    double yParticle = centerPos.field_1351 + Math.sin(outerAngle) * (double)this.getAffectRadius();
                    world.method_8494((class_2394)this.particleEffect, x1Particle, yParticle, z1Particle, 0.0, 0.0, 0.0);
                    world.method_8494((class_2394)this.particleEffect, x2Particle, yParticle, z2Particle, 0.0, 0.0, 0.0);
                }
                float angle = 0.0f;
                while ((double)angle <= Math.PI * 2) {
                    double xParticle = centerPos.field_1352 + Math.cos(angle) * (double)this.getAffectRadius();
                    double zParticle = centerPos.field_1350 + Math.sin(angle) * (double)this.getAffectRadius();
                    world.method_8494((class_2394)this.particleEffectLarge, xParticle, (double)blockPos.method_10264() + 0.2, zParticle, 0.0, 0.0, 0.0);
                    angle += 0.05235988f;
                }
            }
        }
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.activatedTicks = nbt.method_10550(NBT_ACTIVATE_TICKS_NAME);
        this.activatedDurationTicks = nbt.method_10550(NBT_ACTIVATE_DURATION_TICKS_NAME);
        this.affectRadius = nbt.method_10583(NBT_AFFECT_RADIUS_NAME);
    }

    protected void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        nbt.method_10569(NBT_ACTIVATE_TICKS_NAME, this.activatedTicks);
        nbt.method_10569(NBT_ACTIVATE_DURATION_TICKS_NAME, this.activatedDurationTicks);
        nbt.method_10548(NBT_AFFECT_RADIUS_NAME, this.affectRadius);
    }

    protected Collection<class_1309> getAffectedLivingEntities() {
        class_243 centerPos = this.method_11016().method_46558();
        float squareAffectedRadius = this.getAffectRadius() * this.getAffectRadius();
        return this.method_10997().method_8390(class_1309.class, new class_238(this.method_11016()).method_1014((double)this.getAffectRadius()), entity -> entity.method_5707(centerPos) < (double)squareAffectedRadius && class_1301.field_6155.test(entity));
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", state -> state.setAndContinue(ANIMATION_IDLE))});
    }

    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887() {
        return this.method_38244();
    }

    public float getAffectRadius() {
        return this.affectRadius;
    }

    public int getActivatedTicks() {
        return this.activatedTicks;
    }

    public boolean isActivated() {
        return this.activatedTicks > 0;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.animatableInstanceCache;
    }
}

