/*
 * Decompiled with CFR 0.152.
 */
package net.moddercoder.immortalsoul.block.entity;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5819;
import net.minecraft.class_6032;
import net.moddercoder.immortalsoul.block.ModBlocks;
import net.moddercoder.immortalsoul.block.SoulsReceptacleBlock;
import net.moddercoder.immortalsoul.block.entity.ModBlockEntityTypes;
import net.moddercoder.immortalsoul.block.entity.logic.soulsreceptacle.SoulsReceptacleLogic;
import net.moddercoder.immortalsoul.item.ModItems;
import net.moddercoder.immortalsoul.item.WeightedItemStack;
import net.moddercoder.immortalsoul.sound.ModSoundEvents;

public class SoulsReceptacleBlockEntity
extends class_2586 {
    public static final int DELAY_BETWEEN_REWARDS = 10;
    public static final int REWARD_LATENCY_DURATION = 30;
    public static final int TICKS_RELOADING_DURATION = 12000;
    public static final String NBT_RELOADING_NAME = "ReloadingTicks";
    public static final String NBT_WAIT_TAKE_REWARD_NAME = "WaitForTakeReward";
    protected int reloadingTicks = 0;
    protected int rewardTicks = 0;
    protected boolean rewarding = false;
    protected int rewardLatencyTicks = 0;
    protected boolean waitForTakeReward = false;
    protected LinkedList<class_1799> rewardItemStacks = Lists.newLinkedList();
    private final SoulsReceptacleLogic logic = new SoulsReceptacleLogic(){

        @Override
        public void sendStatus(class_1937 world, class_2338 pos, int status) {
            world.method_8427(pos, (class_2248)ModBlocks.RECEPTACLE_OF_SOULS, status, 0);
        }

        @Override
        public void setSpawnEntityType(class_1299<?> spawnEntityType) {
            super.setSpawnEntityType(spawnEntityType);
            class_1937 world = SoulsReceptacleBlockEntity.this.method_10997();
            class_2338 blockPos = SoulsReceptacleBlockEntity.this.method_11016();
            if (world != null) {
                class_2680 blockState = world.method_8320(blockPos);
                world.method_8413(blockPos, blockState, blockState, 4);
            }
        }

        @Override
        public void onPlayerAppearInRange(class_1937 world, class_2338 pos, class_2680 state, boolean appear) {
        }
    };

    public SoulsReceptacleBlockEntity(class_2338 pos, class_2680 state) {
        super(ModBlockEntityTypes.RECEPTACLE_OF_SOULS, pos, state);
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.reloadingTicks = nbt.method_10573(NBT_RELOADING_NAME, 3) ? nbt.method_10550(NBT_RELOADING_NAME) : 0;
        this.waitForTakeReward = nbt.method_10573(NBT_WAIT_TAKE_REWARD_NAME, 1) ? nbt.method_10577(NBT_WAIT_TAKE_REWARD_NAME) : false;
        this.logic.readNbt(this.field_11863, this.field_11867, nbt);
    }

    protected void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        nbt.method_10569(NBT_RELOADING_NAME, this.reloadingTicks);
        nbt.method_10556(NBT_WAIT_TAKE_REWARD_NAME, this.waitForTakeReward);
        this.logic.writeNbt(nbt);
    }

    public static void clientTick(class_1937 world, class_2338 pos, class_2680 state, SoulsReceptacleBlockEntity blockEntity) {
        blockEntity.logic.clientTick(world, pos, state, blockEntity);
    }

    public static void serverTick(class_1937 world, class_2338 pos, class_2680 state, SoulsReceptacleBlockEntity blockEntity) {
        if (blockEntity.isWaitingTakeReward()) {
            return;
        }
        if (blockEntity.isReloading()) {
            if (blockEntity.isRewarding()) {
                if (blockEntity.rewardLatencyTicks <= 0) {
                    if (blockEntity.getRewardTicks() >= 0) {
                        --blockEntity.rewardTicks;
                        if (blockEntity.getRewardTicks() >= 0 && blockEntity.getRewardTicks() % 10 == 0) {
                            blockEntity.summonRewardItem(world, pos, state);
                            world.method_8396(null, pos, class_3417.field_14785, class_3419.field_15245, 1.0f, 1.0f);
                        }
                    } else {
                        blockEntity.rewarding = false;
                        world.method_8501(pos, (class_2680)world.method_8320(pos).method_11657((class_2769)SoulsReceptacleBlock.REWARD, (Comparable)Boolean.valueOf(false)));
                    }
                } else {
                    --blockEntity.rewardLatencyTicks;
                }
            } else {
                if (world.method_8510() % 200L == 0L) {
                    world.method_8396(null, pos, ModSoundEvents.RECEPTACLE_OF_SOULS_AMBIENT, class_3419.field_15245, 1.0f, 1.0f);
                }
                --blockEntity.reloadingTicks;
                if (!blockEntity.isReloading()) {
                    world.method_8501(pos, (class_2680)state.method_11657((class_2769)SoulsReceptacleBlock.TURNED_ON, (Comparable)Boolean.valueOf(true)));
                }
            }
        } else {
            blockEntity.logic.serverTick((class_3218)world, pos, state, blockEntity);
        }
    }

    public class_2622 toUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    public void summonRewardItem(class_1937 world, class_2338 pos, class_2680 state) {
        if (!world.field_9236 && !this.rewardItemStacks.isEmpty()) {
            class_5819 rand = world.method_8409();
            class_1799 itemStack = this.rewardItemStacks.getLast();
            class_1542 itemEntity = new class_1542(world, (double)pos.method_10263() + 0.5, (double)(pos.method_10264() + 1), (double)pos.method_10260() + 0.5, itemStack, (rand.method_43058() - rand.method_43058()) * 0.05, 0.2, (rand.method_43058() - rand.method_43058()) * 0.05);
            itemEntity.method_6988();
            world.method_8649((class_1297)itemEntity);
            for (int i = 0; i < 16; ++i) {
                ((class_3218)world).method_14199((class_2394)class_2398.field_11251, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 1.0, (double)pos.method_10260() + 0.5, 1, 0.25, 0.3, 0.25, 0.0);
            }
            this.rewardItemStacks.removeLast();
        }
    }

    public boolean method_11004(int type, int data) {
        if (this.logic.handleStatus(this.field_11863, type)) {
            return true;
        }
        return super.method_11004(type, data);
    }

    public boolean method_11011() {
        return true;
    }

    public void toggleReloading() {
        if (this.field_11863 != null && !this.field_11863.field_9236) {
            this.field_11863.method_8501(this.field_11867, (class_2680)this.field_11863.method_8320(this.field_11867).method_11657((class_2769)SoulsReceptacleBlock.TURNED_ON, (Comparable)Boolean.valueOf(false)));
            this.reloadingTicks = 12000;
            this.method_5431();
        }
    }

    public boolean tryToTakeReward(int playersCount) {
        if (this.waitForTakeReward) {
            if (this.method_11002()) {
                class_1937 world = this.method_10997();
                world.method_8396(null, this.field_11867, ModSoundEvents.RECEPTACLE_OF_SOULS_KEY_OPEN, class_3419.field_15245, 1.0f, 1.0f);
            }
            this.waitForTakeReward = false;
            this.generateRewardItemStacks(playersCount);
            this.rewardLatencyTicks = 30;
            this.rewardTicks = this.getRewardDurationTicks();
            this.rewarding = true;
            return true;
        }
        return false;
    }

    public void reward() {
        this.field_11863.method_8501(this.field_11867, (class_2680)this.field_11863.method_8320(this.field_11867).method_11657((class_2769)SoulsReceptacleBlock.REWARD, (Comparable)Boolean.valueOf(true)));
        this.waitForTakeReward = true;
    }

    public void generateRewardItemStacks(int playersCount) {
        if (this.field_11863 == null) {
            return;
        }
        if (this.field_11863.field_9236) {
            return;
        }
        List<WeightedItemStack> weightedItemStackGroup = Arrays.asList(new WeightedItemStack(new class_1799((class_1935)ModItems.SOUL, 1), 20), new WeightedItemStack(new class_1799((class_1935)ModItems.CURSED_RELIC, 1), 5), new WeightedItemStack(new class_1799((class_1935)class_1802.field_8477, 1), 10), new WeightedItemStack(new class_1799((class_1935)class_1802.field_8463, 1), 10), new WeightedItemStack(new class_1799((class_1935)class_1802.field_8071, 1), 15), new WeightedItemStack(new class_1799((class_1935)class_1802.field_8620, 1), 15), new WeightedItemStack(new class_1799((class_1935)ModItems.OMINOUS_FRAGMENT_KEY, 1), 10), new WeightedItemStack(new class_1799((class_1935)class_1802.field_8687, 1), 15));
        int droppedItemsCount = 3 * Math.min(playersCount, 3);
        ArrayList<class_1799> resultItemStacks = new ArrayList<class_1799>(droppedItemsCount);
        for (int i = 0; i < playersCount; ++i) {
            class_6032 weightedItemStackGroupWeightedList = new class_6032();
            weightedItemStackGroup.forEach(weightedItemStack -> weightedItemStackGroupWeightedList.method_35093((Object)weightedItemStack.itemStack(), weightedItemStack.weight()));
            resultItemStacks.addAll(weightedItemStackGroupWeightedList.method_35088().method_35094().toList().subList(0, 3).stream().filter(Predicate.not(class_1799::method_7960)).toList());
        }
        this.rewardItemStacks.addAll(resultItemStacks);
    }

    public Collection<class_1799> getRewardItemStacks() {
        return this.rewardItemStacks;
    }

    public SoulsReceptacleLogic getLogic() {
        return this.logic;
    }

    public boolean isWaitingTakeReward() {
        return this.waitForTakeReward;
    }

    public int getRewardDurationTicks() {
        return 10 * this.getRewardItemsCount();
    }

    public int getRewardItemsCount() {
        return this.rewardItemStacks != null ? this.rewardItemStacks.size() : 3;
    }

    public int getReloadingTicks() {
        return this.reloadingTicks;
    }

    public boolean isRewarding() {
        return this.rewarding;
    }

    public boolean isReloading() {
        return this.reloadingTicks > 0;
    }

    public int getRewardTicks() {
        return this.rewardTicks;
    }
}

