/*
 * Decompiled with CFR 0.152.
 */
package ru.xewe.immortal.utils;

import java.util.ArrayList;

public class TripleMap<KEY_TYPE, VALUE_ONE_TYPE, VALUE_TWO_TYPE> {
    ArrayList<KEY_TYPE> keys = new ArrayList();
    ArrayList<VALUE_ONE_TYPE> valuesOne = new ArrayList();
    ArrayList<VALUE_TWO_TYPE> valuesTwo = new ArrayList();

    public TripleMap<KEY_TYPE, VALUE_ONE_TYPE, VALUE_TWO_TYPE> put(KEY_TYPE key, VALUE_ONE_TYPE valueOne, VALUE_TWO_TYPE valueTwo) {
        this.keys.add(key);
        this.valuesOne.add(valueOne);
        this.valuesTwo.add(valueTwo);
        return this;
    }

    public TripleMap<KEY_TYPE, VALUE_ONE_TYPE, VALUE_TWO_TYPE> putAll(TripleMap<KEY_TYPE, VALUE_ONE_TYPE, VALUE_TWO_TYPE> map) {
        this.keys.addAll(map.keys);
        this.valuesOne.addAll(map.valuesOne);
        this.valuesTwo.addAll(map.valuesTwo);
        return this;
    }

    public VALUE_ONE_TYPE getOne(KEY_TYPE key) {
        return this.valuesOne.get(this.keys.indexOf(key));
    }

    public VALUE_TWO_TYPE getTwo(KEY_TYPE key) {
        return this.valuesTwo.get(this.keys.indexOf(key));
    }

    public boolean hasKey(KEY_TYPE key) {
        return this.keys.contains(key);
    }

    public TripleMap<KEY_TYPE, VALUE_ONE_TYPE, VALUE_TWO_TYPE> copy() {
        TripleMap<KEY_TYPE, VALUE_ONE_TYPE, VALUE_TWO_TYPE> copy = new TripleMap<KEY_TYPE, VALUE_ONE_TYPE, VALUE_TWO_TYPE>();
        copy.keys = new ArrayList<KEY_TYPE>(this.keys);
        copy.valuesOne = new ArrayList<VALUE_ONE_TYPE>(this.valuesOne);
        copy.valuesTwo = new ArrayList<VALUE_TWO_TYPE>(this.valuesTwo);
        return copy;
    }

    public static <K, V, V2> TripleMap<K, V, V2> of(K key, V valueOne, V2 valueTwo, K key2, V valueOne2, V2 valueTwo2, K key3, V valueOne3, V2 valueTwo3, K key4, V valueOne4, V2 valueTwo4) {
        return TripleMap.mapN(key, valueOne, valueTwo, key2, valueOne2, valueTwo2, key3, valueOne3, valueTwo3, key4, valueOne4, valueTwo4);
    }

    public static <K, V, V2> TripleMap<K, V, V2> of(K key, V valueOne, V2 valueTwo) {
        return new TripleMap<K, V, V2>().put(key, valueOne, valueTwo);
    }

    private static <K, V, V2> TripleMap<K, V, V2> mapN(Object ... obj) {
        TripleMap<Object, Object, Object> map = new TripleMap<Object, Object, Object>();
        for (int i = 0; i < obj.length; i += 3) {
            Object key = obj[i];
            Object valueOne = obj[i + 1];
            Object valueTwo = obj[i + 2];
            map.put(key, valueOne, valueTwo);
        }
        return map;
    }
}

