/*
 * Decompiled with CFR 0.152.
 */
package ru.xewe.immortal.recipe;

import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;
import ru.xewe.immortal.ImmortalSkills;
import ru.xewe.immortal.item.rarity.ItemRarity;
import ru.xewe.immortal.recipe.RequireStack;

public class RarityRecipe {
    private final Map<ItemRarity, RequireStack[]> requirements;

    public RarityRecipe(Map<ItemRarity, RequireStack[]> requirements) {
        this.requirements = requirements;
    }

    public Map<ItemRarity, RequireStack[]> getRequirements() {
        return this.requirements;
    }

    public boolean canCraft(List<ItemStack> inputs, ItemRarity rarity) {
        RequireStack[] required = this.requirements.get((Object)rarity);
        if (required == null) {
            return false;
        }
        for (RequireStack reqStack : required) {
            if (this.contains(inputs, reqStack)) continue;
            return false;
        }
        return true;
    }

    private boolean contains(List<ItemStack> inputs, RequireStack required) {
        String idRequired = required.id();
        int counts = required.count();
        for (ItemStack input : inputs) {
            ResourceLocation locationInput = ForgeRegistries.ITEMS.getKey((Object)input.m_41720_());
            if (locationInput == null) {
                ImmortalSkills.LOGGER.warn("NULLABLE LOCATION INPUT: {0}", (Object)input);
                return false;
            }
            if (locationInput.toString().equals(idRequired)) {
                --counts;
            }
            if (counts != 0) continue;
            return true;
        }
        return false;
    }
}

