/*
 * Decompiled with CFR 0.152.
 */
package ru.xewe.immortal.network;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.network.NetworkEvent;
import ru.xewe.immortal.network.ctx.IModPacket;

public class SyncEffectToC
implements IModPacket {
    private final int entityId;
    private final MobEffect effect;
    private final int duration;
    private final int amplifier;
    private final Operation operation;

    public SyncEffectToC(Entity entity, MobEffect effect, int duration, int amplifier) {
        this.entityId = entity.m_19879_();
        this.effect = effect;
        this.duration = duration;
        this.amplifier = amplifier;
        this.operation = Operation.ADD;
    }

    public SyncEffectToC(Entity entity, MobEffect effect) {
        this.entityId = entity.m_19879_();
        this.effect = effect;
        this.duration = 0;
        this.amplifier = 0;
        this.operation = Operation.REMOVE;
    }

    public SyncEffectToC(FriendlyByteBuf buf) {
        this.entityId = buf.readInt();
        this.effect = MobEffect.m_19453_((int)buf.readInt());
        this.duration = buf.readInt();
        this.amplifier = buf.readInt();
        this.operation = Operation.values()[buf.readInt()];
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.entityId);
        buf.writeInt(MobEffect.m_19459_((MobEffect)this.effect));
        buf.writeInt(this.duration);
        buf.writeInt(this.amplifier);
        buf.writeInt(this.operation.ordinal());
    }

    @Override
    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Entity entity;
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            if (level != null && (entity = level.m_6815_(this.entityId)) instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                if (this.operation.equals((Object)Operation.ADD)) {
                    livingEntity.m_7292_(new MobEffectInstance(this.effect, this.duration, this.amplifier, false, false, false));
                } else if (this.operation.equals((Object)Operation.REMOVE)) {
                    livingEntity.m_21195_(this.effect);
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }

    public static enum Operation {
        ADD,
        REMOVE;

    }
}

