/*
 * Decompiled with CFR 0.152.
 */
package ru.xewe.immortal.mixins;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.sensing.VillagerHostilesSensor;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import ru.xewe.immortal.item.RegisterManagerItems;
import ru.xewe.immortal.item.armor.AbstractRarityArmor;
import ru.xewe.immortal.utils.UtilItem;

@Mixin(value={VillagerHostilesSensor.class})
public abstract class VillagerHostileSensorMixin {
    @Inject(method={"isHostile"}, at={@At(value="HEAD")}, cancellable=true)
    private void onIsHostile(LivingEntity entity, CallbackInfoReturnable<Boolean> cir) {
        Player player;
        if (entity instanceof Player && this.isHostile(player = (Player)entity)) {
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"isClose"}, at={@At(value="HEAD")}, cancellable=true)
    private void onIsClose(LivingEntity pAttacker, LivingEntity pTarget, CallbackInfoReturnable<Boolean> cir) {
        Player player;
        if (pTarget instanceof Player && this.isHostile(player = (Player)pTarget)) {
            cir.setReturnValue((Object)(pTarget.m_20280_((Entity)pAttacker) <= 100.0 ? 1 : 0));
        }
    }

    private boolean isHostile(Player player) {
        return UtilItem.hasItemsInInventory(player, RegisterManagerItems.DARK_ORDEN_INQUISITOR_SET.getListItems()) || AbstractRarityArmor.isWornFullSetWithSkillEquals((Entity)player, RegisterManagerItems.DARK_ORDEN_INQUISITOR_SET);
    }
}

