/*
 * Decompiled with CFR 0.152.
 */
package ru.xewe.immortal.menus;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import ru.xewe.immortal.ImmortalSkills;
import ru.xewe.immortal.item.rarity.ItemRarity;
import ru.xewe.immortal.item.tooltip.TooltipItem;
import ru.xewe.immortal.menus.AltarMenu;
import ru.xewe.immortal.recipe.AltarRecipeManager;
import ru.xewe.immortal.utils.ItemRarityHelper;

public class AltarScreen
extends AbstractContainerScreen<AltarMenu> {
    private static final int textureWidth = 512;
    private static final int textureHeight = 512;
    private Button craftApplyButton;
    public static final ResourceLocation TEXTURE = new ResourceLocation("immortalskills", "textures/gui/altar_gui.png");

    public AltarScreen(AltarMenu pMenu, Inventory pPlayerInventory, Component pTitle) {
        super((AbstractContainerMenu)pMenu, pPlayerInventory, pTitle);
    }

    protected void m_7856_() {
        super.m_7856_();
        this.f_97731_ = 10000;
        this.f_97729_ = 10000;
        this.craftApplyButton = (Button)this.m_7787_((GuiEventListener)Button.m_253074_((Component)CommonComponents.f_130655_, btn -> this.onCraft()).m_252987_(0, 0, 22, 22).m_253136_());
    }

    private void onCraft() {
        if (this.f_96541_ != null && this.f_96541_.f_91072_ != null) {
            this.f_96541_.f_91072_.m_105208_(((AltarMenu)this.f_97732_).f_38840_, 0);
        } else {
            ImmortalSkills.LOGGER.warn("Minecraft its NULL! Tell for developors");
        }
    }

    public void m_88315_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, delta);
        this.m_280072_(guiGraphics, mouseX, mouseY);
    }

    protected void m_280072_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.m_280072_(guiGraphics, mouseX, mouseY);
        this.renderHoverInformation(guiGraphics, mouseX, mouseY);
        this.renderHoverChance(guiGraphics, mouseX, mouseY);
        this.renderHoverButton(guiGraphics, mouseX, mouseY);
    }

    protected void m_7286_(@NotNull GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        ItemStack heldItem = ((AltarMenu)this.f_97732_).blockEntity.getHeldItem();
        int altarWidth = 229;
        int altarHeight = 255;
        int x = (this.f_96543_ - altarWidth) / 2;
        int y = (this.f_96544_ - altarHeight) / 2;
        this.renderAltarAtlas(guiGraphics, x, y, 0, 0, altarWidth, altarHeight);
        this.craftApplyButton.f_93623_ = !((AltarMenu)this.f_97732_).isCrafting() && ((AltarMenu)this.f_97732_).blockEntity.isRecipeValid() && !ItemRarityHelper.getRarity(heldItem).equals((Object)ItemRarity.LEGENDARY);
        this.renderButtons(guiGraphics, mouseX, mouseY);
        this.renderProgressArrows(guiGraphics, x, y);
        this.renderChanceGems(guiGraphics, x, y, ((AltarMenu)this.f_97732_).blockEntity.getCountNearbyGemBlocks());
        this.renderRarityIcon(guiGraphics, x, y);
    }

    private void renderRarityIcon(GuiGraphics guiGraphics, int x, int y) {
        ItemStack heldItem = ((AltarMenu)this.f_97732_).blockEntity.getHeldItem();
        if (!heldItem.m_41619_()) {
            ResourceLocation texture = ItemRarityHelper.getRarity(heldItem).getTextureAltar();
            int textureSize = 34;
            guiGraphics.m_280163_(texture, x + 98, y - 35, 0.0f, 0.0f, textureSize, textureSize, textureSize, textureSize);
        }
    }

    private void renderHoverButton(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        if (!((AltarMenu)this.f_97732_).blockEntity.getHeldItem().m_41619_() && this.isMouseOverButton(this.craftApplyButton, mouseX, mouseY)) {
            this.renderTooltipLines(guiGraphics, mouseX, mouseY, (Component)Component.m_237110_((String)"altar.tip.required_materials", (Object[])new Object[]{AltarRecipeManager.getRequiredItemsToLocalize(((AltarMenu)this.f_97732_).blockEntity.getHeldItem())}));
        }
    }

    private void renderHoverInformation(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        if (this.m_6774_(8, 18, 8, 15, mouseX, mouseY)) {
            this.renderTooltipLines(guiGraphics, mouseX, mouseY, (Component)Component.m_237115_((String)"altar.tip.info"));
        }
    }

    private void renderHoverChance(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        if (this.m_6774_(10, 100, 158, 17, mouseX, mouseY)) {
            this.renderTooltipLines(guiGraphics, mouseX, mouseY, (Component)Component.m_237110_((String)"altar.tip.chance", (Object[])new Object[]{((AltarMenu)this.f_97732_).blockEntity.getCountNearbyGemBlocks() * 10 + 10}));
        }
    }

    private void renderProgressArrows(GuiGraphics pGuiGraphics, int x, int y) {
        if (((AltarMenu)this.f_97732_).isCrafting()) {
            int progress = ((AltarMenu)this.f_97732_).getScaledProgress();
            this.renderAltarAtlas(pGuiGraphics, x + 110, y + 46, 52, 272, 10, progress);
            this.renderAltarAtlas(pGuiGraphics, x + 110, y + 86 + 9 - progress, 52, 321 - progress, 10, progress);
            this.renderAltarAtlas(pGuiGraphics, x + 90, y + 66, 32, 292, progress, 10);
            this.renderAltarAtlas(pGuiGraphics, x + 130 + 9 - progress, y + 66, 81 - progress, 292, progress, 10);
        }
    }

    private void renderButtons(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        this.craftApplyButton.m_252865_(this.f_97735_ + 154);
        this.craftApplyButton.m_253211_(this.f_97736_ + 15);
        if (this.craftApplyButton.f_93623_) {
            if (this.isMouseOverButton(this.craftApplyButton, mouseX, mouseY)) {
                this.renderButton(guiGraphics, this.craftApplyButton, 0, 294);
            } else {
                this.renderButton(guiGraphics, this.craftApplyButton, 0, 272);
            }
        }
    }

    private void renderTooltipLines(GuiGraphics guiGraphics, int mouseX, int mouseY, Component component) {
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_252880_(0.0f, 0.0f, 500.0f);
        guiGraphics.m_280666_(Minecraft.m_91087_().f_91062_, TooltipItem.getComponentsLines(component, new Object[0]), mouseX, mouseY);
        poseStack.m_85849_();
    }

    public void drawSquare(GuiGraphics gui, int x, int y, int size, int argbColor) {
        gui.m_280509_(x, y, x + size, y + size, argbColor);
    }

    public boolean isMouseOverButton(Button button, double pMouseX, double pMouseY) {
        return pMouseX >= (double)button.m_252754_() && pMouseY >= (double)button.m_252907_() && pMouseX < (double)(button.m_252754_() + button.m_5711_()) && pMouseY < (double)(button.m_252907_() + button.m_93694_());
    }

    public boolean isMouseHover(int x, int y, int pWidth, int pHeight, double pMouseX, double pMouseY) {
        return pMouseX >= (double)x && pMouseY >= (double)y && pMouseX < (double)(x + pWidth) && pMouseY < (double)(y + pHeight);
    }

    private void renderChanceGems(GuiGraphics guiGraphics, int x, int y, int count) {
        while (count > 0) {
            this.renderAltarAtlas(guiGraphics, x + 19 + count * 18, y + 151, 1, 323, 14, 11);
            --count;
        }
    }

    private void renderButton(GuiGraphics guiGraphics, Button button, int uOffset, int vOffset) {
        this.renderAltarAtlas(guiGraphics, button.m_252754_(), button.m_252907_(), uOffset, vOffset, button.m_5711_(), button.m_93694_());
    }

    private void renderAltarAtlas(GuiGraphics guiGraphics, int x, int y, int uOffset, int vOffset, int uWidth, int vHeight) {
        guiGraphics.m_280398_(TEXTURE, x, y, 0, (float)uOffset, (float)vOffset, uWidth, vHeight, 512, 512);
    }
}

