/*
 * Decompiled with CFR 0.152.
 */
package ru.xewe.immortal.menus;

import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import org.jetbrains.annotations.NotNull;
import ru.xewe.immortal.blocks.RegisterManagerBlocks;
import ru.xewe.immortal.blocks.blockentity.AltarBlockTile;
import ru.xewe.immortal.item.rarity.IRarity;
import ru.xewe.immortal.menus.RegisterMenuTypes;
import ru.xewe.immortal.menus.widgets.GemSlot;
import ru.xewe.immortal.menus.widgets.ResourceSlot;

public class AltarMenu
extends AbstractContainerMenu {
    public final AltarBlockTile blockEntity;
    private final Level level;
    private final ContainerData data;
    private static final int HOTBAR_SLOT_COUNT = 9;
    private static final int PLAYER_INVENTORY_ROW_COUNT = 3;
    private static final int PLAYER_INVENTORY_COLUMN_COUNT = 9;
    private static final int PLAYER_INVENTORY_SLOT_COUNT = 27;
    private static final int VANILLA_SLOT_COUNT = 36;
    private static final int VANILLA_FIRST_SLOT_INDEX = 0;
    private static final int TE_INVENTORY_FIRST_SLOT_INDEX = 36;
    private static final int TE_INVENTORY_SLOT_COUNT = 9;

    public AltarMenu(int containerId, Inventory inv, FriendlyByteBuf extraData) {
        this(containerId, inv, inv.f_35978_.m_9236_().m_7702_(extraData.m_130135_()), (ContainerData)new SimpleContainerData(9));
    }

    public AltarMenu(int containerId, Inventory inv, BlockEntity blockEntity, ContainerData data) {
        super((MenuType)RegisterMenuTypes.ALTAR_MENU.get(), containerId);
        AltarMenu.m_38869_((Container)inv, (int)9);
        this.blockEntity = (AltarBlockTile)blockEntity;
        this.level = inv.f_35978_.m_9236_();
        this.data = data;
        this.addPlayerInventory(inv);
        this.addPlayerHotbar(inv);
        this.blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(iItemHandler -> {
            int baseY = 58;
            int baseX = 40;
            this.m_38897_((Slot)new ResourceSlot((IItemHandler)iItemHandler, 0, baseX, baseY - 80));
            this.m_38897_((Slot)new GemSlot((IItemHandler)iItemHandler, 3, baseX, baseY - 40));
            this.m_38897_((Slot)new ResourceSlot((IItemHandler)iItemHandler, 6, baseX, baseY));
            this.m_38897_((Slot)new GemSlot((IItemHandler)iItemHandler, 1, baseX * 2, baseY - 80));
            this.m_38897_((Slot)new SlotItemHandler((IItemHandler)iItemHandler, 4, baseX * 2, baseY - 40){

                public boolean m_5857_(@NotNull ItemStack stack) {
                    IRarity rarityItem;
                    Item item;
                    return super.m_5857_(stack) && (item = stack.m_41720_()) instanceof IRarity && (rarityItem = (IRarity)item).improvesAtAltar(stack);
                }

                public boolean m_8010_(Player playerIn) {
                    return super.m_8010_(playerIn) && !AltarMenu.this.isCrafting();
                }
            });
            this.m_38897_((Slot)new GemSlot((IItemHandler)iItemHandler, 7, baseX * 2, baseY));
            this.m_38897_((Slot)new ResourceSlot((IItemHandler)iItemHandler, 2, baseX * 3, baseY - 80));
            this.m_38897_((Slot)new GemSlot((IItemHandler)iItemHandler, 5, baseX * 3, baseY - 40));
            this.m_38897_((Slot)new ResourceSlot((IItemHandler)iItemHandler, 8, baseX * 3, baseY));
        });
        this.m_38884_(data);
    }

    public boolean m_6366_(Player player, int id) {
        this.blockEntity.doCraft();
        return true;
    }

    @NotNull
    public ItemStack m_7648_(@NotNull Player player, int slotIndex) {
        int end;
        Slot slot = (Slot)this.f_38839_.get(slotIndex);
        if (!slot.m_6657_()) {
            return ItemStack.f_41583_;
        }
        ItemStack sourceStack = slot.m_7993_();
        ItemStack copy = sourceStack.m_41777_();
        boolean fromPlayer = slotIndex < 36;
        int start = fromPlayer ? 36 : 0;
        if (!this.m_38903_(sourceStack, start, end = start + (fromPlayer ? 9 : 36), false)) {
            return ItemStack.f_41583_;
        }
        if (sourceStack.m_41619_()) {
            slot.m_5852_(ItemStack.f_41583_);
        } else {
            slot.m_6654_();
        }
        slot.m_142406_(player, sourceStack);
        return copy;
    }

    public boolean m_6875_(@NotNull Player pPlayer) {
        return AltarMenu.m_38889_((ContainerLevelAccess)ContainerLevelAccess.m_39289_((Level)this.level, (BlockPos)this.blockEntity.m_58899_()), (Player)pPlayer, (Block)((Block)RegisterManagerBlocks.ALTAR_BLOCK.get()));
    }

    private void addPlayerInventory(Inventory playerInventory) {
        int xOffset = 9;
        int yOffset = 129;
        for (int i = 0; i < 3; ++i) {
            for (int l = 0; l < 9; ++l) {
                this.m_38897_(new Slot((Container)playerInventory, l + i * 9 + 9, xOffset + l * 18, yOffset + i * 18));
            }
        }
    }

    private void addPlayerHotbar(Inventory playerInventory) {
        int xOffset = 9;
        int yOffset = 187;
        for (int i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)playerInventory, i, xOffset + i * 18, yOffset));
        }
    }

    public boolean isCrafting() {
        return this.data.m_6413_(0) > 0;
    }

    public int getScaledProgress() {
        int progress = this.data.m_6413_(0);
        int maxProgress = this.data.m_6413_(1);
        int progressArrowSize = 10;
        return maxProgress != 0 && progress != 0 ? progress * progressArrowSize / maxProgress : 0;
    }
}

