/*
 * Decompiled with CFR 0.152.
 */
package ru.xewe.immortal.item.weapons;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.RegistryObject;
import ru.xewe.immortal.entity.CustomLightningBolt;
import ru.xewe.immortal.events.TimeableManager;
import ru.xewe.immortal.item.RegisterManagerItems;
import ru.xewe.immortal.item.rarity.ItemRarity;
import ru.xewe.immortal.item.tooltip.TooltipItem;
import ru.xewe.immortal.item.weapons.AbstractRarityWeapon;
import ru.xewe.immortal.item.weapons.tiers.RarityTiers;
import ru.xewe.immortal.utils.ItemRarityHelper;

public class MechanicalHummer
extends AbstractRarityWeapon<MechanicalHummer> {
    private static final String KILL_COUNT_TAG = "killCount";
    private static final int KILL_COUNT_REQ = 100;
    private static final int ABILITY_COOLDOWN = 400;

    public MechanicalHummer(Item.Properties properties) {
        super(properties);
    }

    @Override
    public RegistryObject<MechanicalHummer> getVariant() {
        return RegisterManagerItems.MECHANICAL_HUMMER;
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (attacker instanceof Player) {
            Player player = (Player)attacker;
            Item item = stack.m_41720_();
            if (item instanceof MechanicalHummer) {
                MechanicalHummer hummer = (MechanicalHummer)item;
                Level world = player.m_9236_();
                if (this.isNotCooldown(player, InteractionHand.MAIN_HAND)) {
                    if (hummer.hasSkill(stack)) {
                        this.onAbility(world, stack, target, player);
                        this.setCooldown(player, 400, InteractionHand.MAIN_HAND);
                    } else if (target.m_21223_() <= 0.0f) {
                        this.onKillEnemy(stack, target, player);
                    }
                }
            }
        }
        return super.m_7579_(stack, target, attacker);
    }

    private void onAbility(Level world, ItemStack stack, LivingEntity target, Player player) {
        if (!world.f_46443_) {
            target.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 60, 2));
            int bonusDamage = ItemRarityHelper.getRarity(stack).equals((Object)ItemRarity.LEGENDARY) ? 9 : 0;
            Runnable summonLighting = () -> {
                Vec3 pos = target.m_20182_();
                CustomLightningBolt lightning = new CustomLightningBolt(world);
                lightning.m_6027_(pos.f_82479_, pos.f_82480_ + (double)target.m_20206_(), pos.f_82481_);
                world.m_7967_((Entity)lightning);
                target.m_6469_(player.m_269291_().m_269548_(), 7.0f + (float)bonusDamage);
                world.m_6263_(null, pos.f_82479_, pos.f_82480_, pos.f_82481_, SoundEvents.f_12090_, SoundSource.PLAYERS, 1.0f, 1.0f);
            };
            TimeableManager.postDelayed(summonLighting, 20);
        }
    }

    private void onKillEnemy(ItemStack stack, LivingEntity target, Player player) {
        MechanicalHummer.incrementKillCount(stack);
        if (MechanicalHummer.getKillCount(stack) >= 100) {
            this.upgradeWeapon(player, stack);
            player.m_5661_((Component)Component.m_237113_((String)"\u0412\u0430\u0448 \u043c\u043e\u043b\u043e\u0442 \u0443\u043b\u0443\u0447\u0448\u0435\u043d!").m_130940_(ChatFormatting.GREEN), true);
        }
    }

    private void upgradeWeapon(Player player, ItemStack stack) {
        int slot = player.m_150109_().m_36030_(stack);
        if (slot == -1) {
            return;
        }
        ItemRarityHelper.setRarity(stack, ItemRarity.RARE);
    }

    public static int getKillCount(ItemStack stack) {
        if (stack.m_41782_() && stack.m_41783_().m_128441_(KILL_COUNT_TAG)) {
            return stack.m_41783_().m_128451_(KILL_COUNT_TAG);
        }
        return 0;
    }

    public static void incrementKillCount(ItemStack stack) {
        int killCount = MechanicalHummer.getKillCount(stack);
        stack.m_41784_().m_128405_(KILL_COUNT_TAG, killCount + 1);
    }

    @Override
    public void m_7373_(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag flag) {
        TooltipItem.appendShiftHoverText(stack, tooltip, MechanicalHummer.getKillCount(stack));
    }

    @Override
    public boolean improvesAtAltar(ItemStack stack) {
        return this.hasSkill(stack);
    }

    @Override
    public List<RarityTiers> getRarityMaterials() {
        return List.of(RarityTiers.COMMON_MECHANICAL, RarityTiers.RARE_MECHANICAL, RarityTiers.EPIC_MECHANICAL, RarityTiers.LEGENDARY_MECHANICAL);
    }
}

