/*
 * Decompiled with CFR 0.152.
 */
package ru.xewe.immortal.item.weapons;

import java.util.List;
import java.util.Map;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.RegistryObject;
import ru.xewe.immortal.client.sounds.RegisterManagerSound;
import ru.xewe.immortal.entity.ElderWizardBookSoul;
import ru.xewe.immortal.events.TimeableManager;
import ru.xewe.immortal.item.RegisterManagerItems;
import ru.xewe.immortal.item.weapons.AbstractCastingRarityWeapon;
import ru.xewe.immortal.item.weapons.tiers.RarityTiers;

public class ElderWizardBook
extends AbstractCastingRarityWeapon<ElderWizardBook> {
    public ElderWizardBook(Item.Properties properties) {
        super(properties, Map.of());
    }

    public void cast(Level level, Player player) {
        int countSouls = ElderWizardBook.getListSouls(level, player).size();
        if (countSouls != 3) {
            level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)RegisterManagerSound.ARCANE_MISSILE.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        }
        for (int i = 0; i < 3 - countSouls; ++i) {
            ElderWizardBookSoul soul = new ElderWizardBookSoul(level, player);
            soul.m_146884_(player.m_20182_());
            TimeableManager.postDelayed(() -> level.m_7967_((Entity)soul), 10 * i);
        }
    }

    private static List<ElderWizardBookSoul> getListSouls(Level world, Player player) {
        return world.m_45976_(ElderWizardBookSoul.class, player.m_20191_().m_82400_(20.0)).stream().filter(soul -> soul.m_269323_() == player).toList();
    }

    @Override
    public RegistryObject<ElderWizardBook> getVariant() {
        return RegisterManagerItems.ELDER_WIZARD_BOOK;
    }

    @Override
    public List<RarityTiers> getRarityMaterials() {
        return List.of(RarityTiers.COMMON_WIZARDRY, RarityTiers.RARE_WIZARDRY, RarityTiers.EPIC_WIZARDRY, RarityTiers.LEGENDARY_WIZARDRY);
    }
}

