/*
 * Decompiled with CFR 0.152.
 */
package ru.xewe.immortal.item.weapons;

import java.util.List;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.Nullable;
import ru.xewe.immortal.effect.ModEffect;
import ru.xewe.immortal.effect.RegisterManagerEffects;
import ru.xewe.immortal.item.RegisterManagerItems;
import ru.xewe.immortal.item.weapons.AbstractRarityWeapon;
import ru.xewe.immortal.item.weapons.tiers.RarityTiers;

public class DarkInquisitorSword
extends AbstractRarityWeapon<DarkInquisitorSword> {
    private static final int ABILITY_COOLDOWN = 800;
    private static final TagKey<EntityType<?>> FORGE_BOSS_TAG = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)new ResourceLocation("forge", "bosses"));
    private static final TagKey<EntityType<?>> FABRIC_BOSS_TAG = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)new ResourceLocation("c", "bosses"));

    public DarkInquisitorSword(Item.Properties properties) {
        super(properties);
    }

    @Override
    public RegistryObject<DarkInquisitorSword> getVariant() {
        return RegisterManagerItems.DARK_INQUISITOR_SWORD;
    }

    @Override
    public void updateUpgradedInHand(Level world, Player player) {
        LivingEntity target;
        if (!world.f_46443_ && this.isNotCooldown(player, InteractionHand.MAIN_HAND) && (target = DarkInquisitorSword.findHostileMob(player, 10.0)) != null) {
            ModEffect effect = (ModEffect)((Object)RegisterManagerEffects.INQUISITOR_MARK_EFFECT.get());
            effect.addEffect(target, 200, 0);
            world.m_6263_(null, target.m_20185_(), target.m_20186_(), target.m_20189_(), SoundEvents.f_11862_, SoundSource.PLAYERS, 1.0f, 1.0f);
            this.setCooldown(player, 800, InteractionHand.MAIN_HAND);
        }
    }

    @Nullable
    private static LivingEntity findHostileMob(Player player, double radius) {
        return player.m_9236_().m_6443_(LivingEntity.class, player.m_20191_().m_82400_(radius), e -> e.m_6084_() && !DarkInquisitorSword.isBoss(e) && DarkInquisitorSword.isHostileTowardsPlayer(player, e)).stream().findAny().orElse(null);
    }

    public static boolean isBoss(LivingEntity entity) {
        return entity.m_6095_().m_204039_(FORGE_BOSS_TAG) || entity.m_6095_().m_204039_(FABRIC_BOSS_TAG);
    }

    private static boolean isHostileTowardsPlayer(Player player, LivingEntity entity) {
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            return mob.m_5448_() == player;
        }
        if (entity instanceof NeutralMob) {
            NeutralMob neutralMob = (NeutralMob)entity;
            return neutralMob.m_21674_((LivingEntity)player);
        }
        return false;
    }

    @Override
    public List<RarityTiers> getRarityMaterials() {
        return List.of(RarityTiers.COMMON_INQUISITOR, RarityTiers.RARE_INQUISITOR, RarityTiers.EPIC_INQUISITOR, RarityTiers.LEGENDARY_INQUISITOR);
    }

    public void onKillEnemy(Player player, LivingEntity targetEntity) {
        if (targetEntity.m_21023_((MobEffect)RegisterManagerEffects.INQUISITOR_MARK_EFFECT.get())) {
            player.m_5634_(4.0f);
            player.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 360, 0));
        }
    }
}

