/*
 * Decompiled with CFR 0.152.
 */
package ru.xewe.immortal.item.rarity;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import io.redspace.ironsspellbooks.api.registry.AttributeRegistry;
import java.util.List;
import java.util.Map;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import ru.xewe.immortal.item.rarity.IRarity;
import ru.xewe.immortal.item.rarity.ItemRarity;
import ru.xewe.immortal.item.weapons.AbstractCastingRarityWeapon;
import ru.xewe.immortal.item.weapons.AbstractRarityWeapon;
import ru.xewe.immortal.item.weapons.tiers.RarityTiers;
import ru.xewe.immortal.utils.ItemRarityHelper;

public interface IRarityTier<T extends Item>
extends IRarity<T, RarityTiers> {
    public static final Map<ItemRarity, RarityTiers> rarityMaterials = Map.of(ItemRarity.COMMON, RarityTiers.COMMON, ItemRarity.RARE, RarityTiers.RARE, ItemRarity.EPIC, RarityTiers.EPIC, ItemRarity.LEGENDARY, RarityTiers.LEGENDARY);

    @Override
    default public Map<ItemRarity, RarityTiers> getDefaultMaterials() {
        return rarityMaterials;
    }

    @Override
    default public Multimap<Attribute, AttributeModifier> getAttributeModifiersWithRarity(ItemRarity rarity) {
        return this.getAttributeModifiersWithRarity(rarity, 0.0f);
    }

    default public Multimap<Attribute, AttributeModifier> getAttributeModifiersWithRarity(ItemRarity itemRarity, float bonusDamage) {
        RarityTiers material = (RarityTiers)this.getRarityMaterialsMap().get((Object)itemRarity);
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(AbstractRarityWeapon.getBaseAttackDamageUUID(), "Weapon modifier", (double)(material.m_6631_() + bonusDamage), AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(AbstractRarityWeapon.getBaseAttackSpeedUUID(), "Weapon modifier", (double)(material.m_6624_() - 4.0f), AttributeModifier.Operation.ADDITION));
        if (material.getSpellPower() > 0.0f) {
            builder.put((Object)((Attribute)AttributeRegistry.SPELL_POWER.get()), (Object)new AttributeModifier(AbstractCastingRarityWeapon.UUID_WIZARDRY, "Weapon modifier", 0.05, AttributeModifier.Operation.MULTIPLY_BASE));
        }
        return builder.build();
    }

    @Override
    default public Multimap<Attribute, AttributeModifier> getAttributeModifiersWithRarity(ItemStack stack) {
        ItemRarity rarity = ItemRarityHelper.getRarity(stack);
        float bonusDamage = stack.m_41784_().m_128457_("BonusDamage");
        return this.getAttributeModifiersWithRarity(rarity, bonusDamage);
    }

    @Override
    default public List<RarityTiers> getRarityMaterials() {
        return List.of();
    }
}

