/*
 * Decompiled with CFR 0.152.
 */
package ru.xewe.immortal.item.armor;

import com.aizistral.enigmaticlegacy.handlers.SuperpositionHandler;
import java.util.List;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import ru.xewe.immortal.Config;
import ru.xewe.immortal.client.renderer.armor.UnholyKnightRender;
import ru.xewe.immortal.effect.UnholyAreaEffect;
import ru.xewe.immortal.item.RegisterManagerItems;
import ru.xewe.immortal.item.armor.AbstractRarityArmor;
import ru.xewe.immortal.item.armor.materials.ArmorSet;
import ru.xewe.immortal.item.armor.materials.RarityArmorMaterial;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.renderer.GeoArmorRenderer;

public class UnholyKnightArmor
extends AbstractRarityArmor<UnholyKnightArmor> {
    private static final int COOLDOWN_ABILITY = 1800;

    public UnholyKnightArmor(ArmorItem.Type type, Item.Properties properties) {
        super(type, properties);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public GeoArmorRenderer<?> supplyRenderer() {
        return new UnholyKnightRender();
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, 20, state -> {
            state.setAnimation(RawAnimation.begin().thenLoop("animation_idle"));
            Entity entity = (Entity)state.getData(DataTickets.ENTITY);
            Item original = (Item)RegisterManagerItems.UNHOLY_KNIGHT_SET.getChestplate().get();
            Item transformed = (Item)this.getSet().getChestplate().get();
            boolean contains = UnholyKnightArmor.getWornArmors(entity).contains(original) || UnholyKnightArmor.getWornArmors(entity).contains(transformed);
            return contains ? PlayState.CONTINUE : PlayState.STOP;
        })});
    }

    @Override
    public ArmorSet<UnholyKnightArmor> getSet() {
        return RegisterManagerItems.UNHOLY_KNIGHT_SET;
    }

    public boolean canEquip(ItemStack stack, EquipmentSlot armorType, Entity entity) {
        Player player;
        return entity instanceof Player && SuperpositionHandler.isTheCursedOne((Player)(player = (Player)entity)) && super.canEquip(stack, armorType, entity);
    }

    public void actionForAttack(ServerPlayer player) {
        if (UnholyKnightArmor.isArmorNotCooldown((Player)player)) {
            UnholyAreaEffect areaEffect = new UnholyAreaEffect();
            areaEffect.addEffect((LivingEntity)player, Config.UnholyKnightArmorAreaDuration, 0);
            UnholyKnightArmor.setArmorCooldown((Player)player, 1800);
        }
    }

    @Override
    public List<RarityArmorMaterial> getRarityMaterials() {
        return List.of(RarityArmorMaterial.EPIC_UNHOLY, RarityArmorMaterial.LEGENDARY_UNHOLY);
    }
}

