/*
 * Decompiled with CFR 0.152.
 */
package ru.xewe.immortal.item.armor;

import java.util.List;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import ru.xewe.immortal.client.renderer.armor.EngineerRender;
import ru.xewe.immortal.entity.GearEntity;
import ru.xewe.immortal.item.RegisterManagerItems;
import ru.xewe.immortal.item.armor.AbstractRarityArmor;
import ru.xewe.immortal.item.armor.materials.ArmorSet;
import ru.xewe.immortal.item.armor.materials.RarityArmorMaterial;
import ru.xewe.immortal.utils.AABBUtil;
import ru.xewe.immortal.utils.CoordinatesHelper;
import software.bernie.geckolib.renderer.GeoArmorRenderer;

public class EngineerArmor
extends AbstractRarityArmor<EngineerArmor> {
    private static final int COOLDOWN_ABILITY = 400;

    public EngineerArmor(ArmorItem.Type type, Item.Properties properties) {
        super(type, properties);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public GeoArmorRenderer<?> supplyRenderer() {
        return new EngineerRender();
    }

    @Override
    public ArmorSet<EngineerArmor> getSet() {
        return RegisterManagerItems.ENGINEER_SET;
    }

    @Override
    public void initSkillFullArmor(Player player) {
        EngineerArmor.setArmorCooldown(player, 400);
    }

    @Override
    public void updateOnSkillFullArmor(Level world, Player player) {
        if (!world.f_46443_ && EngineerArmor.isArmorNotCooldown(player)) {
            int countGears = 0;
            List genericMobs = player.m_9236_().m_45976_(LivingEntity.class, AABBUtil.getBoundingBoxAroundEntity((Entity)player, 21.0));
            for (LivingEntity checkedEntity : genericMobs) {
                GearEntity gearEntity;
                if (!(checkedEntity instanceof GearEntity) || !(gearEntity = (GearEntity)checkedEntity).getOwner().equals((Object)player)) continue;
                ++countGears;
            }
            if (countGears < 3 && player.m_6103_() < 6.0f) {
                GearEntity gear = new GearEntity(world, player);
                Vec3 coord = CoordinatesHelper.getRandomFreePositionForEntity(world, player.m_20183_(), (Entity)gear, 8);
                if (coord != null) {
                    gear.m_146884_(coord);
                    world.m_7967_((Entity)gear);
                    world.m_5594_(null, gear.m_20097_(), SoundEvents.f_12471_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    EngineerArmor.setArmorCooldown(player, 400);
                }
            }
        }
    }

    @Override
    public void onUnequip(Player player) {
        List genericMobs = player.m_9236_().m_45976_(LivingEntity.class, AABBUtil.getBoundingBoxAroundEntity((Entity)player, 21.0));
        for (LivingEntity checkedEntity : genericMobs) {
            GearEntity gearEntity;
            if (!(checkedEntity instanceof GearEntity) || !(gearEntity = (GearEntity)checkedEntity).getOwner().equals((Object)player)) continue;
            gearEntity.m_146870_();
        }
    }

    @Override
    public List<RarityArmorMaterial> getRarityMaterials() {
        return List.of(RarityArmorMaterial.RARE_ENGINEER, RarityArmorMaterial.EPIC_ENGINEER, RarityArmorMaterial.LEGENDARY_ENGINEER);
    }
}

