/*
 * Decompiled with CFR 0.152.
 */
package ru.xewe.immortal.item.armor;

import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import ru.xewe.immortal.Config;
import ru.xewe.immortal.client.renderer.armor.DarkOrdenInquisitorRender;
import ru.xewe.immortal.item.RegisterManagerItems;
import ru.xewe.immortal.item.armor.AbstractRarityArmor;
import ru.xewe.immortal.item.armor.materials.ArmorSet;
import ru.xewe.immortal.item.armor.materials.RarityArmorMaterial;
import ru.xewe.immortal.item.tooltip.TooltipItem;
import ru.xewe.immortal.utils.AABBUtil;
import software.bernie.geckolib.renderer.GeoArmorRenderer;

public class DarkOrdenInquisitorArmor
extends AbstractRarityArmor<DarkOrdenInquisitorArmor> {
    private static int getCooldownAbility() {
        return Config.DarkInquisitorArmorCoolDown;
    }

    public DarkOrdenInquisitorArmor(ArmorItem.Type type, Item.Properties properties) {
        super(type, properties);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public GeoArmorRenderer<?> supplyRenderer() {
        return new DarkOrdenInquisitorRender();
    }

    @Override
    public void initSkillFullArmor(Player player) {
        DarkOrdenInquisitorArmor.setArmorCooldown(player, DarkOrdenInquisitorArmor.getCooldownAbility());
    }

    @Override
    public void updateInInventory(Level world, Player player) {
        if (!world.f_46443_ && !player.m_7500_()) {
            List genericMobs = player.m_9236_().m_45976_(LivingEntity.class, AABBUtil.getBoundingBoxAroundEntity((Entity)player, 24.0));
            for (LivingEntity checkedEntity : genericMobs) {
                if (!(checkedEntity instanceof IronGolem)) continue;
                IronGolem golem = (IronGolem)checkedEntity;
                golem.m_6710_((LivingEntity)player);
            }
        }
    }

    public boolean onPreDeath(Player player) {
        if (DarkOrdenInquisitorArmor.isArmorNotCooldown(player)) {
            player.m_21219_();
            player.m_21153_(1.0f);
            player.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 900, 1));
            player.m_7292_(new MobEffectInstance(MobEffects.f_19607_, 800, 0));
            player.m_7292_(new MobEffectInstance(MobEffects.f_19617_, 100, 1));
            if (!player.m_9236_().f_46443_) {
                player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12513_, player.m_5720_(), 1.0f, 1.0f);
            }
            DarkOrdenInquisitorArmor.setArmorCooldown(player, DarkOrdenInquisitorArmor.getCooldownAbility());
            return true;
        }
        return false;
    }

    @Override
    public ArmorSet<DarkOrdenInquisitorArmor> getSet() {
        return RegisterManagerItems.DARK_ORDEN_INQUISITOR_SET;
    }

    @Override
    public List<RarityArmorMaterial> getRarityMaterials() {
        return List.of(RarityArmorMaterial.EPIC_INQUISITOR, RarityArmorMaterial.LEGENDARY_INQUISITOR);
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> components, TooltipFlag flag) {
        TooltipItem.appendShiftHoverText(stack, components, DarkOrdenInquisitorArmor.getCooldownAbility() / 20);
    }
}

