/*
 * Decompiled with CFR 0.152.
 */
package ru.xewe.immortal.item.armor;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import io.redspace.ironsspellbooks.api.registry.AttributeRegistry;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.xewe.immortal.item.armor.materials.ArmorSet;
import ru.xewe.immortal.item.armor.materials.RarityArmorMaterial;
import ru.xewe.immortal.item.rarity.IRarityArmor;
import ru.xewe.immortal.item.rarity.ItemRarity;
import ru.xewe.immortal.item.tooltip.TooltipItem;
import ru.xewe.immortal.utils.ItemRarityHelper;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.renderer.GeoArmorRenderer;
import software.bernie.geckolib.util.GeckoLibUtil;

public abstract class AbstractRarityArmor<T extends ArmorItem>
extends ArmorItem
implements GeoItem,
IRarityArmor<T> {
    private static final UUID[] ARMOR_MODIFIER_UUID_PER_SLOT = new UUID[]{UUID.fromString("845DB27C-C624-495F-8C9F-6020A9A58B6B"), UUID.fromString("D8499B04-0E66-4726-AB29-64469D734E0D"), UUID.fromString("9F3D476D-C118-4544-8365-64846904B48E"), UUID.fromString("2AD3F246-FEE1-4E67-B886-69FD380BB150")};
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    protected AbstractRarityArmor(ArmorItem.Type type, Item.Properties properties) {
        super((ArmorMaterial)RarityArmorMaterial.COMMON, type, properties);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        return slot == this.f_265916_.m_266308_() ? this.getAttributeModifiersWithRarity(stack) : ImmutableMultimap.of();
    }

    @Override
    public Multimap<Attribute, AttributeModifier> getAttributeModifiersWithRarity(ItemRarity rarity) {
        RarityArmorMaterial material = (RarityArmorMaterial)this.getRarityMaterialsMap().get((Object)rarity);
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        UUID uuid = ARMOR_MODIFIER_UUID_PER_SLOT[this.f_265916_.m_266308_().m_20749_()];
        builder.put((Object)Attributes.f_22284_, (Object)new AttributeModifier(uuid, "Armor modifier", (double)material.m_7366_(this.f_265916_), AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22285_, (Object)new AttributeModifier(uuid, "Armor toughness", (double)material.m_6651_(), AttributeModifier.Operation.ADDITION));
        if (material.getMana() > 0) {
            builder.put((Object)((Attribute)AttributeRegistry.MAX_MANA.get()), (Object)new AttributeModifier(uuid, "Max Mana", (double)material.getMana(), AttributeModifier.Operation.ADDITION));
        }
        if (material.getMultiplySpellPower() > 0.0f) {
            builder.put((Object)((Attribute)AttributeRegistry.SPELL_POWER.get()), (Object)new AttributeModifier(uuid, "Spell Power", (double)material.getMultiplySpellPower(), AttributeModifier.Operation.MULTIPLY_BASE));
        }
        if (this.f_40378_ > 0.0f) {
            builder.put((Object)Attributes.f_22278_, (Object)new AttributeModifier(uuid, "Armor knockback resistance", (double)this.f_40378_, AttributeModifier.Operation.ADDITION));
        }
        return builder.build();
    }

    public int getMaxDamage(ItemStack stack) {
        return ((RarityArmorMaterial)this.getRarityMaterialsMap().get((Object)ItemRarityHelper.getRarity(stack))).m_266425_(this.f_265916_);
    }

    public boolean isDamageable(ItemStack stack) {
        return ((RarityArmorMaterial)this.getRarityMaterialsMap().get((Object)ItemRarityHelper.getRarity(stack))).m_266425_(this.f_265916_) != -1;
    }

    @OnlyIn(value=Dist.CLIENT)
    public abstract GeoArmorRenderer<?> supplyRenderer();

    public abstract ArmorSet<T> getSet();

    @Override
    public RegistryObject<T> getVariant() {
        return this.getSet().get(this.f_265916_);
    }

    public static Set<Item> getWornArmors(Entity entity) {
        ObjectOpenHashSet armors = new ObjectOpenHashSet();
        for (ItemStack stack : entity.m_6168_()) {
            armors.add(stack.m_41720_());
        }
        return armors;
    }

    public static Set<ItemStack> getWornArmorsItemStack(Entity entity) {
        ObjectOpenHashSet armors = new ObjectOpenHashSet();
        for (ItemStack stack : entity.m_6168_()) {
            armors.add(stack);
        }
        return armors;
    }

    public static boolean isWornFullSetEquals(Entity entity, ArmorSet<?> armorSet) {
        return AbstractRarityArmor.getWornArmors(entity).containsAll(armorSet.getListItems());
    }

    public static boolean isWornFullSetWithSkillEquals(Entity entity, ArmorSet<?> armorSet) {
        return AbstractRarityArmor.isWornFullSetEquals(entity, armorSet) && AbstractRarityArmor.getWornArmorsItemStack(entity).stream().allMatch(itemStack -> {
            IRarityArmor rarityItem;
            Item patt6182$temp = itemStack.m_41720_();
            return patt6182$temp instanceof IRarityArmor && (rarityItem = (IRarityArmor)patt6182$temp).hasSkill((ItemStack)itemStack);
        });
    }

    public boolean isWornFullSetWithSkill(Entity entity) {
        return AbstractRarityArmor.isWornFullSetWithSkillEquals(entity, this.getSet());
    }

    public void onEquip(Player player) {
        if (this.isWornFullSetWithSkill((Entity)player)) {
            this.initSkillFullArmor(player);
        }
    }

    public void onUnequip(Player player) {
        if (!this.isWornFullSetWithSkill((Entity)player)) {
            this.exitOnSkillFullArmor(player);
        }
    }

    public void initSkillFullArmor(Player player) {
    }

    public void exitOnSkillFullArmor(Player player) {
    }

    public void updateOnSkillFullArmor(Level world, Player player) {
    }

    public void updateInInventory(Level world, Player player) {
    }

    public static boolean isArmorNotCooldown(Player player) {
        ItemStack boots = player.m_6844_(EquipmentSlot.FEET);
        return !player.m_36335_().m_41519_(boots.m_41720_());
    }

    public static void setArmorCooldown(Player player, int ticks) {
        ItemStack head = player.m_6844_(EquipmentSlot.HEAD);
        ItemStack chest = player.m_6844_(EquipmentSlot.CHEST);
        ItemStack legs = player.m_6844_(EquipmentSlot.LEGS);
        ItemStack boots = player.m_6844_(EquipmentSlot.FEET);
        player.m_36335_().m_41524_(boots.m_41720_(), ticks);
        player.m_36335_().m_41524_(legs.m_41720_(), ticks);
        player.m_36335_().m_41524_(chest.m_41720_(), ticks);
        player.m_36335_().m_41524_(head.m_41720_(), ticks);
    }

    public void onInventoryTick(ItemStack stack, Level level, Player player, int slotIndex, int selectedIndex) {
        super.onInventoryTick(stack, level, player, slotIndex, selectedIndex);
        if (this.isWornFullSetWithSkill((Entity)player) && player.m_150109_().m_36052_(0).equals(stack)) {
            this.updateOnSkillFullArmor(level, player);
        } else {
            this.updateInInventory(level, player);
        }
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private GeoArmorRenderer<?> renderer;

            @NotNull
            public HumanoidModel<?> getHumanoidArmorModel(LivingEntity livingEntity, ItemStack itemStack, EquipmentSlot equipmentSlot, HumanoidModel<?> original) {
                if (this.renderer == null) {
                    this.renderer = AbstractRarityArmor.this.supplyRenderer();
                }
                this.renderer.prepForRender((Entity)livingEntity, itemStack, equipmentSlot, original);
                return this.renderer;
            }
        });
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, 20, state -> PlayState.STOP)});
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> components, TooltipFlag flag) {
        TooltipItem.appendShiftHoverText(stack, components, new Object[0]);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public Component m_7626_(ItemStack pStack) {
        return this.getRarityTooltip(super.m_7626_(pStack).m_6881_(), pStack);
    }

    public boolean m_8120_(ItemStack pStack) {
        return true;
    }
}

