/*
 * Decompiled with CFR 0.152.
 */
package ru.xewe.immortal.item;

import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import ru.xewe.immortal.item.armor.AbstractRarityArmor;
import ru.xewe.immortal.item.armor.DarkOrdenInquisitorArmor;
import ru.xewe.immortal.item.armor.ElderWizardArmor;
import ru.xewe.immortal.item.armor.ElementalistArmor;
import ru.xewe.immortal.item.armor.EngineerArmor;
import ru.xewe.immortal.item.armor.MechanicalMessengerArmor;
import ru.xewe.immortal.item.armor.UnholyKnightArmor;
import ru.xewe.immortal.item.armor.materials.ArmorSet;
import ru.xewe.immortal.item.misc.ExtendedItems;
import ru.xewe.immortal.item.misc.RawGem;
import ru.xewe.immortal.item.rarity.IRarityTier;
import ru.xewe.immortal.item.weapons.DarkInquisitorSword;
import ru.xewe.immortal.item.weapons.ElderWizardBook;
import ru.xewe.immortal.item.weapons.ElementalistStuff;
import ru.xewe.immortal.item.weapons.EngineerStuff;
import ru.xewe.immortal.item.weapons.MechanicalHummer;
import ru.xewe.immortal.item.weapons.UnholyKnightMace;

public class RegisterManagerItems {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"immortalskills");
    public static final ArmorSet<DarkOrdenInquisitorArmor> DARK_ORDEN_INQUISITOR_SET = RegisterManagerItems.registerArmorSet("dark_orden_inquisitor", DarkOrdenInquisitorArmor::new);
    public static final ArmorSet<ElderWizardArmor> ELDER_WIZARD_SET = RegisterManagerItems.registerArmorSet("elder_wizard", ElderWizardArmor::new);
    public static final ArmorSet<ElementalistArmor> ELEMENTALIST_SET = RegisterManagerItems.registerArmorSet("elementalist", ElementalistArmor::new);
    public static final ArmorSet<EngineerArmor> ENGINEER_SET = RegisterManagerItems.registerArmorSet("engineer", EngineerArmor::new);
    public static final ArmorSet<MechanicalMessengerArmor> MECHANICAL_MESSENGER_SET = RegisterManagerItems.registerArmorSet("mechanical_messenger", MechanicalMessengerArmor::new);
    public static final ArmorSet<UnholyKnightArmor> UNHOLY_KNIGHT_SET = RegisterManagerItems.registerArmorSet("unholy_knight", UnholyKnightArmor::new);
    public static final RegistryObject<DarkInquisitorSword> DARK_INQUISITOR_SWORD = RegisterManagerItems.registerWeapon("inquisitor_sword", DarkInquisitorSword::new);
    public static final RegistryObject<ElderWizardBook> ELDER_WIZARD_BOOK;
    public static final RegistryObject<ElementalistStuff> ELEMENTALIST_STAFF;
    public static final RegistryObject<EngineerStuff> ENGINEER_STAFF;
    public static final RegistryObject<MechanicalHummer> MECHANICAL_HUMMER;
    public static final RegistryObject<UnholyKnightMace> UNHOLY_KNIGHT_MACE;
    public static final RegistryObject<Item> GEM;
    public static final RegistryObject<Item> RAW_GEM;

    private RegisterManagerItems() {
    }

    public static void register(IEventBus eventBus) {
        ITEMS.register(eventBus);
    }

    private static <T extends AbstractRarityArmor<T>> ArmorSet<T> registerArmorSet(String prefix, ArmorItemConstructor<T> constructor) {
        return new ArmorSet(ITEMS.register(prefix + "_helmet", () -> constructor.create(ArmorItem.Type.HELMET, new Item.Properties())), ITEMS.register(prefix + "_chestplate", () -> constructor.create(ArmorItem.Type.CHESTPLATE, new Item.Properties())), ITEMS.register(prefix + "_leggings", () -> constructor.create(ArmorItem.Type.LEGGINGS, new Item.Properties())), ITEMS.register(prefix + "_boots", () -> constructor.create(ArmorItem.Type.BOOTS, new Item.Properties())));
    }

    private static <T extends Item> RegistryObject<T> registerWeapon(String prefix, WeaponItemConstructor<T> constructor) {
        return ITEMS.register(prefix, () -> (Item)constructor.create(new Item.Properties()));
    }

    static {
        ELEMENTALIST_STAFF = RegisterManagerItems.registerWeapon("elementalist_staff", ElementalistStuff::new);
        UNHOLY_KNIGHT_MACE = RegisterManagerItems.registerWeapon("unholy_knight_mace", UnholyKnightMace::new);
        ELDER_WIZARD_BOOK = RegisterManagerItems.registerWeapon("elder_wizard_book", ElderWizardBook::new);
        ENGINEER_STAFF = RegisterManagerItems.registerWeapon("engineer_staff", EngineerStuff::new);
        MECHANICAL_HUMMER = RegisterManagerItems.registerWeapon("mechanical_hammer", MechanicalHummer::new);
        RAW_GEM = ITEMS.register("raw_gem", () -> new RawGem(new Item.Properties()));
        GEM = ITEMS.register("gem", () -> new ExtendedItems(new Item.Properties()));
    }

    @FunctionalInterface
    private static interface ArmorItemConstructor<T extends AbstractRarityArmor<T>> {
        public T create(ArmorItem.Type var1, Item.Properties var2);
    }

    @FunctionalInterface
    private static interface WeaponItemConstructor<T extends IRarityTier<?>> {
        public T create(Item.Properties var1);
    }
}

