/*
 * Decompiled with CFR 0.152.
 */
package ru.xewe.immortal.item;

import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.registries.RegistryObject;
import ru.xewe.immortal.ImmortalSkills;
import ru.xewe.immortal.blocks.RegisterManagerBlocks;
import ru.xewe.immortal.item.RegisterCreativeModeTab;
import ru.xewe.immortal.item.RegisterManagerItems;
import ru.xewe.immortal.item.armor.materials.ArmorSet;
import ru.xewe.immortal.item.rarity.ItemRarity;
import ru.xewe.immortal.utils.ItemRarityHelper;

public class ImmortalCreativeTab {
    public static void addCreativeTabItems(BuildCreativeModeTabContentsEvent event) {
        CreativeModeTab tab = event.getTab();
        if (tab.equals(RegisterCreativeModeTab.IMMORTAL_SKILLS.get())) {
            ImmortalCreativeTab.acceptSet(RegisterManagerItems.DARK_ORDEN_INQUISITOR_SET, event);
            ImmortalCreativeTab.acceptSet(RegisterManagerItems.ELDER_WIZARD_SET, event);
            ImmortalCreativeTab.acceptSet(RegisterManagerItems.ELEMENTALIST_SET, event);
            ImmortalCreativeTab.acceptSet(RegisterManagerItems.ENGINEER_SET, event);
            ImmortalCreativeTab.acceptSet(RegisterManagerItems.MECHANICAL_MESSENGER_SET, event);
            ImmortalCreativeTab.acceptSet(RegisterManagerItems.UNHOLY_KNIGHT_SET, event);
            ImmortalCreativeTab.acceptAllRarity(RegisterManagerItems.DARK_INQUISITOR_SWORD, event);
            ImmortalCreativeTab.acceptAllRarity(RegisterManagerItems.ELDER_WIZARD_BOOK, event);
            ImmortalCreativeTab.acceptAllRarity(RegisterManagerItems.ELEMENTALIST_STAFF, event);
            ImmortalCreativeTab.acceptAllRarity(RegisterManagerItems.ENGINEER_STAFF, event);
            ImmortalCreativeTab.acceptAllRarity(RegisterManagerItems.MECHANICAL_HUMMER, event);
            ImmortalCreativeTab.acceptAllRarity(RegisterManagerItems.UNHOLY_KNIGHT_MACE, event);
            event.accept(RegisterManagerBlocks.GEM_ORE);
            event.accept(RegisterManagerBlocks.DEEPSLATE_GEM_ORE);
            event.accept(RegisterManagerBlocks.GEM_BLOCK);
            event.accept(RegisterManagerBlocks.ALTAR_BLOCK);
            event.accept(RegisterManagerItems.RAW_GEM);
            event.accept(RegisterManagerItems.GEM);
        }
    }

    private static <T extends ArmorItem> void acceptSet(ArmorSet<T> armorSet, BuildCreativeModeTabContentsEvent event) {
        for (RegistryObject<T> armor : armorSet.getList()) {
            ImmortalCreativeTab.acceptAllRarity(armor, event);
        }
    }

    private static <T extends Item> void acceptAllRarity(RegistryObject<T> registryItem, BuildCreativeModeTabContentsEvent event) {
        for (ItemRarity rarity : ItemRarity.values()) {
            ItemStack itemStack = new ItemStack((ItemLike)registryItem.get());
            ItemRarityHelper.setRarity(itemStack, rarity);
            if (rarity.equals((Object)ItemRarity.COMMON)) {
                event.m_246342_(itemStack);
                continue;
            }
            if (!ImmortalSkills.isDevEnvironment()) continue;
            event.m_246342_(itemStack);
        }
    }
}

