/*
 * Decompiled with CFR 0.152.
 */
package ru.xewe.immortal.events;

import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.SpellcasterIllager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingChangeTargetEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.RegistryObject;
import ru.xewe.immortal.effect.ExtendedShieldEffect;
import ru.xewe.immortal.effect.RegisterManagerEffects;
import ru.xewe.immortal.item.RegisterManagerItems;
import ru.xewe.immortal.item.armor.AbstractRarityArmor;
import ru.xewe.immortal.item.armor.DarkOrdenInquisitorArmor;
import ru.xewe.immortal.item.armor.UnholyKnightArmor;
import ru.xewe.immortal.item.weapons.DarkInquisitorSword;
import ru.xewe.immortal.utils.UtilItem;

@Mod.EventBusSubscriber(modid="immortalskills", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class EffectSkillHandler {
    @SubscribeEvent
    public static void onLivingAttack(LivingAttackEvent event) {
        LivingEntity entity = event.getEntity();
        if (!entity.m_9236_().f_46443_ && entity instanceof ServerPlayer) {
            Item item;
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            for (RegistryObject<? extends ExtendedShieldEffect> shieldEffectRegistry : RegisterManagerEffects.SHIELDS) {
                ExtendedShieldEffect shieldEffect = (ExtendedShieldEffect)((Object)shieldEffectRegistry.get());
                if (!entity.m_21023_((MobEffect)shieldEffect)) continue;
                DamageSource source = event.getSource();
                MobEffectInstance effectInstance = serverPlayer.m_21124_((MobEffect)shieldEffect);
                if (effectInstance == null || !shieldEffect.canceledCondition(source)) continue;
                int currentAmplifier = effectInstance.m_19564_();
                shieldEffect.removeEffect((LivingEntity)serverPlayer);
                if (currentAmplifier > 0) {
                    shieldEffect.addEffect((LivingEntity)serverPlayer, 410, currentAmplifier - 1);
                }
                shieldEffect.addActionForCanceled(serverPlayer, currentAmplifier);
                event.setCanceled(true);
            }
            if ((event.getSource().m_276093_(DamageTypes.f_268566_) || event.getSource().m_276093_(DamageTypes.f_268464_)) && AbstractRarityArmor.isWornFullSetWithSkillEquals((Entity)serverPlayer, RegisterManagerItems.UNHOLY_KNIGHT_SET) && (item = serverPlayer.m_6844_(EquipmentSlot.HEAD).m_41720_()) instanceof UnholyKnightArmor) {
                UnholyKnightArmor armorItem = (UnholyKnightArmor)item;
                armorItem.actionForAttack(serverPlayer);
            }
        }
    }

    @SubscribeEvent
    public static void onLivingHurt(LivingHurtEvent event) {
        LivingEntity entity = event.getEntity();
        if (entity.m_21023_((MobEffect)RegisterManagerEffects.INQUISITOR_MARK_EFFECT.get())) {
            event.setAmount(event.getAmount() + 3.0f);
        }
    }

    @SubscribeEvent
    public static void onLivingChangeTarget(LivingChangeTargetEvent event) {
        LivingEntity livingEntity;
        Player player;
        LivingEntity livingEntity2 = event.getNewTarget();
        if (livingEntity2 instanceof Player && (player = (Player)livingEntity2).m_21023_(MobEffects.f_19594_) && AbstractRarityArmor.isWornFullSetEquals((Entity)player, RegisterManagerItems.DARK_ORDEN_INQUISITOR_SET) && (livingEntity = event.getEntity()) instanceof SpellcasterIllager) {
            livingEntity2 = (SpellcasterIllager)livingEntity;
        }
    }

    @SubscribeEvent
    public static void onLivingDeath(LivingDeathEvent event) {
        DarkOrdenInquisitorArmor darkInquisitorArmor;
        Player player;
        Item item;
        LivingEntity targetEntity = event.getEntity();
        Entity sourceEntity = event.getSource().m_7639_();
        if (targetEntity instanceof Player && (item = (player = (Player)targetEntity).m_6844_(EquipmentSlot.HEAD).m_41720_()) instanceof DarkOrdenInquisitorArmor && (darkInquisitorArmor = (DarkOrdenInquisitorArmor)item).isWornFullSetWithSkill((Entity)player)) {
            event.setCanceled(darkInquisitorArmor.onPreDeath(player));
        }
        if (sourceEntity instanceof Player && (item = (player = (Player)sourceEntity).m_21205_().m_41720_()) instanceof DarkInquisitorSword) {
            DarkInquisitorSword darkInquisitorSword = (DarkInquisitorSword)item;
            darkInquisitorSword.onKillEnemy(player, targetEntity);
        }
    }

    @SubscribeEvent
    public static void onPlayerInteract(PlayerInteractEvent.EntityInteract event) {
        if (UtilItem.hasItemsInInventory(event.getEntity(), RegisterManagerItems.DARK_ORDEN_INQUISITOR_SET.getListItems()) && event.getTarget() instanceof Villager) {
            event.setCanceled(true);
        }
    }
}

