/*
 * Decompiled with CFR 0.152.
 */
package ru.xewe.immortal.datagen.providers;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.RegistryObject;
import ru.xewe.immortal.ImmortalSkills;

public class CustomRecipeBuilder {
    private final RecipeCategory recipeCategory;
    private final RegistryObject<? extends ItemLike> resultItem;
    private final List<String> pattern = new ArrayList<String>();
    private TypeCrafting typeCrafting = TypeCrafting.SHAPED;
    private final Map<Character, String> keyItems = new HashMap<Character, String>();
    private int resultCount = 1;

    public CustomRecipeBuilder(RecipeCategory recipeCategory, RegistryObject<? extends ItemLike> resultItem) {
        this.recipeCategory = recipeCategory;
        this.resultItem = resultItem;
    }

    public static CustomRecipeBuilder shaped(RecipeCategory recipeCategory, RegistryObject<? extends ItemLike> resultItem) {
        return new CustomRecipeBuilder(recipeCategory, resultItem);
    }

    public CustomRecipeBuilder pattern(String pattern) {
        this.pattern.add(pattern);
        return this;
    }

    public CustomRecipeBuilder define(Character key, String value) {
        this.keyItems.put(key, value);
        return this;
    }

    public CustomRecipeBuilder setTypeCrafting(TypeCrafting typeCrafting) {
        this.typeCrafting = typeCrafting;
        return this;
    }

    public CustomRecipeBuilder setResultCount(int resultCount) {
        this.resultCount = resultCount;
        return this;
    }

    public void save() {
        JsonObject recipe = new JsonObject();
        recipe.addProperty("type", this.getTypeCrafting().getType());
        recipe.addProperty("category", this.recipeCategory.m_247710_());
        JsonArray patternJson = new JsonArray();
        for (String pat : this.pattern) {
            patternJson.add(pat);
        }
        recipe.add("pattern", (JsonElement)patternJson);
        JsonObject keys = new JsonObject();
        for (Map.Entry<Character, String> entry : this.keyItems.entrySet()) {
            JsonObject keyItem = new JsonObject();
            keyItem.addProperty("item", entry.getValue());
            keys.add(String.valueOf(entry.getKey()), (JsonElement)keyItem);
        }
        recipe.add("key", (JsonElement)keys);
        JsonObject result = new JsonObject();
        result.addProperty("item", this.resultItem.getId().toString());
        if (this.resultCount > 1) {
            result.addProperty("count", (Number)this.resultCount);
        }
        recipe.add("result", (JsonElement)result);
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        String json = gson.toJson((JsonElement)recipe);
        String recipeName = this.resultItem.getId().m_135815_() + ".json";
        File file = new File("data/recipes/" + recipeName);
        file.getParentFile().mkdirs();
        try {
            FileWriter writer = new FileWriter(file);
            writer.write(json);
            writer.close();
            ImmortalSkills.LOGGER.info("\u041f\u0430\u043f\u043a\u0430: " + file.getAbsolutePath());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public TypeCrafting getTypeCrafting() {
        return this.typeCrafting;
    }

    public static enum TypeCrafting {
        MECHANICAL_CRAFTING_CREATE("create:mechanical_crafting"),
        SHAPED("minecraft:crafting_shaped");

        private final String type;

        private TypeCrafting(String type) {
            this.type = type;
        }

        public String getType() {
            return this.type;
        }
    }
}

