/*
 * Decompiled with CFR 0.152.
 */
package ru.xewe.immortal.datagen.providers;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraftforge.registries.RegistryObject;
import ru.xewe.immortal.item.armor.materials.ArmorSet;
import ru.xewe.immortal.item.rarity.IRarity;

public class CustomLangBuilder {
    private final Map<String, String> langData = new LinkedHashMap<String, String>();

    CustomLangBuilder() {
    }

    public static CustomLangBuilder newLang() {
        return new CustomLangBuilder();
    }

    public <T extends ArmorItem> CustomLangBuilder addLocalizeArmorSetWithSkillDescription(ArmorSet<T> armorSet, List<String> localizeName, String commonSkillDesc, String rareSkillDesc) {
        int i = 0;
        for (RegistryObject<T> armor : armorSet.getList()) {
            this.addLocalizeItemWithSkillDescription(armor, localizeName.get(i), commonSkillDesc, rareSkillDesc);
            ++i;
        }
        return this;
    }

    public <T extends Item> CustomLangBuilder addLocalizeItemWithSkillDescription(RegistryObject<? extends IRarity<T, ?>> itemToLocalize, String localizeName, String commonSkillDesc, String rareSkillDesc) {
        this.addLocalizeItemWithSkillDescription(itemToLocalize, localizeName, commonSkillDesc, rareSkillDesc, !commonSkillDesc.equals("\u00a7c\u041d\u0435\u0442 \u0441\u043f\u043e\u0441\u043e\u0431\u043d\u043e\u0441\u0442\u0438"));
        return this;
    }

    public <T extends Item> CustomLangBuilder addLocalizeItemWithSkillDescription(RegistryObject<? extends IRarity<T, ?>> itemToLocalize, String localizeName, String commonSkillDesc, String rareSkillDesc, boolean visibleCommonInHigh) {
        this.addLocalizeNameAndParams(ObjectTypes.ITEM, itemToLocalize, localizeName, Map.entry("description.common", commonSkillDesc));
        this.addLocalizeNameAndParams(ObjectTypes.ITEM, itemToLocalize, localizeName, Map.entry("description.rare", visibleCommonInHigh ? commonSkillDesc + rareSkillDesc : rareSkillDesc));
        return this;
    }

    public <T extends Item> CustomLangBuilder addLocalizeItem(RegistryObject<? extends IRarity<T, ?>> itemToLocalize, String localizeName, String description) {
        this.addLocalizeNameAndDescription(ObjectTypes.ITEM, itemToLocalize, localizeName, description);
        return this;
    }

    public CustomLangBuilder addLocalizeParams(ObjectTypes type, RegistryObject<?> objectToLocalize, Map.Entry<String, String> ... localizedParams) {
        for (Map.Entry<String, String> localizedElement : localizedParams) {
            this.langData.put(Util.m_137492_((String)type.getType(), (ResourceLocation)objectToLocalize.getId()) + "." + localizedElement.getKey(), localizedElement.getValue());
        }
        return this;
    }

    public CustomLangBuilder addLocalizeNameAndParams(ObjectTypes type, RegistryObject<?> objectToLocalize, String localizeName, Map.Entry<String, String> ... localizedParams) {
        this.addLocalizeString(Util.m_137492_((String)type.getType(), (ResourceLocation)objectToLocalize.getId()), localizeName);
        this.addLocalizeParams(type, objectToLocalize, localizedParams);
        return this;
    }

    public CustomLangBuilder addLocalizeNameAndDescription(ObjectTypes type, RegistryObject<?> objectToLocalize, String localizeName, String description) {
        this.addLocalizeNameAndParams(type, objectToLocalize, localizeName, Map.entry("description", description));
        return this;
    }

    public CustomLangBuilder addLocalizeName(ObjectTypes type, RegistryObject<?> objectToLocalize, String localizeName) {
        this.addLocalizeString(Util.m_137492_((String)type.getType(), (ResourceLocation)objectToLocalize.getId()), localizeName);
        return this;
    }

    public CustomLangBuilder addLocalizeString(String stringToLocalize, String localize) {
        this.langData.put(stringToLocalize, localize);
        return this;
    }

    public void generate(Language language) {
        JsonObject json = new JsonObject();
        for (Map.Entry<String, String> entry : this.langData.entrySet()) {
            json.addProperty(entry.getKey(), entry.getValue());
        }
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        String jsonString = gson.toJson((JsonElement)json);
        File file = new File("assets/lang/" + language.name + ".json");
        file.getParentFile().mkdirs();
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8);){
            writer.write(jsonString);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static enum ObjectTypes {
        ITEM("item"),
        BLOCK("block");

        private final String type;

        private ObjectTypes(String type) {
            this.type = type;
        }

        public String getType() {
            return this.type;
        }
    }

    public static enum Language {
        RU("ru_ru");

        private final String name;

        private Language(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

