/*
 * Decompiled with CFR 0.152.
 */
package ru.xewe.immortal.datagen;

import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import ru.xewe.immortal.ImmortalSkills;
import ru.xewe.immortal.datagen.generators.ModBlockTagGenerator;
import ru.xewe.immortal.datagen.generators.ModLangGenerator;
import ru.xewe.immortal.datagen.generators.ModRecipeGenerator;
import ru.xewe.immortal.datagen.providers.ModBlockStateProvider;
import ru.xewe.immortal.datagen.providers.ModLootTableProvider;
import ru.xewe.immortal.datagen.providers.ModWorldGenProvider;

public class DataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        ImmortalSkills.LOGGER.info("Generating event");
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(event.includeServer(), (DataProvider)new ModBlockStateProvider(packOutput, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new ModWorldGenProvider(packOutput, lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new ModBlockTagGenerator(packOutput, lookupProvider, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)ModLootTableProvider.create(packOutput));
        generator.addProvider(event.includeServer(), (DataProvider)new ModRecipeGenerator(packOutput));
        new ModLangGenerator().buildLocalization();
    }

    public static void register(IEventBus eventBus) {
        eventBus.addListener(DataGenerators::gatherData);
    }
}

