/*
 * Decompiled with CFR 0.152.
 */
package ru.xewe.immortal.blocks.blockentity;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.xewe.immortal.blocks.RegisterManagerBlocks;
import ru.xewe.immortal.blocks.block.AltarBlock;
import ru.xewe.immortal.item.RegisterManagerItems;
import ru.xewe.immortal.item.rarity.IRarity;
import ru.xewe.immortal.menus.AltarMenu;
import ru.xewe.immortal.recipe.AltarRecipeManager;
import ru.xewe.immortal.utils.ItemRarityHelper;

public class AltarBlockTile
extends BlockEntity
implements MenuProvider {
    public final ItemStackHandler itemHandler = new ItemStackHandler(9){

        protected void onContentsChanged(int slot) {
            AltarBlockTile.this.m_6596_();
        }
    };
    private LazyOptional<IItemHandler> lazyItemHandler = LazyOptional.empty();
    private static final int ONE_GEM = 1;
    private static final int TWO_GEM = 3;
    private static final int THREE_GEM = 5;
    private static final int FOUR_GEM = 7;
    private static final int ONE_MATERIAL = 0;
    private static final int TWO_MATERIAL = 2;
    private static final int THREE_MATERIAL = 6;
    private static final int FOUR_MATERIAL = 8;
    private static final int MAIN_SLOT = 4;
    protected final ContainerData data = new ContainerData(){

        public int m_6413_(int pIndex) {
            return switch (pIndex) {
                case 0 -> AltarBlockTile.this.progress;
                case 1 -> AltarBlockTile.this.maxProgress;
                case 2 -> AltarBlockTile.this.craftState;
                default -> 0;
            };
        }

        public void m_8050_(int pIndex, int pValue) {
            switch (pIndex) {
                case 0: {
                    AltarBlockTile.this.progress = pValue;
                    break;
                }
                case 1: {
                    AltarBlockTile.this.maxProgress = pValue;
                    break;
                }
                case 2: {
                    AltarBlockTile.this.craftState = pValue;
                    break;
                }
            }
        }

        public int m_6499_() {
            return 3;
        }
    };
    private int progress = 0;
    private int maxProgress = 60;
    private int craftState = 0;
    private static final Random RANDOM = new Random();

    public AltarBlockTile(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)RegisterManagerBlocks.ALTAR_BLOCK_TILE.get(), pPos, pBlockState);
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.f_58858_, (Container)inventory);
    }

    @NotNull
    public Component m_5446_() {
        return Component.m_237119_();
    }

    public void onLoad() {
        super.onLoad();
        this.lazyItemHandler = LazyOptional.of(() -> this.itemHandler);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItemHandler.invalidate();
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.lazyItemHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int pContainerId, @NotNull Inventory pPlayerInventory, Player pPlayer) {
        return new AltarMenu(pContainerId, pPlayerInventory, this, this.data);
    }

    public void m_183515_(@NotNull CompoundTag tag) {
        super.m_183515_(tag);
        this.writeNBT(tag);
    }

    public void m_142466_(@NotNull CompoundTag tag) {
        super.m_142466_(tag);
        this.readNBT(tag);
    }

    private CompoundTag writeNBT(CompoundTag tag) {
        tag.m_128365_("inventory", (Tag)this.itemHandler.serializeNBT());
        tag.m_128405_("altar.progress", this.progress);
        tag.m_128405_("altar.craftState", this.craftState);
        return tag;
    }

    private CompoundTag readNBT(CompoundTag tag) {
        this.itemHandler.deserializeNBT(tag.m_128469_("inventory"));
        this.progress = tag.m_128451_("altar.progress");
        this.craftState = tag.m_128451_("altar.craftState");
        return tag;
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.handleUpdateTag(pkt.m_131708_());
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
    }

    public void handleUpdateTag(CompoundTag tag) {
        if (tag != null) {
            this.m_142466_(tag);
        }
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        this.writeNBT(tag);
        return tag;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        CompoundTag nbt = this.writeNBT(new CompoundTag());
        return ClientboundBlockEntityDataPacket.m_195642_((BlockEntity)this, block -> nbt);
    }

    public void tick(Level level, BlockPos blockPos, BlockState state, AltarBlockTile altarBlockTile) {
        if (this.craftApply()) {
            if (this.progress == 0) {
                this.startProgress();
            }
            this.increaseCraftingProgress();
            AltarBlockTile.m_155232_((Level)level, (BlockPos)blockPos, (BlockState)state);
            if (this.hasProgressFinished()) {
                this.craftItem();
                this.resetProgress();
            }
        }
    }

    private void startProgress() {
        this.extractResources();
        this.playSound(SoundEvents.f_12053_);
    }

    private boolean craftApply() {
        return this.craftState == 1;
    }

    public void doCraft() {
        this.craftState = 1;
    }

    private void resetProgress() {
        this.progress = 0;
        this.craftState = 0;
    }

    private void craftItem() {
        if (AltarBlockTile.checkSuccess(this.getCountNearbyGemBlocks() + 1)) {
            this.successTransformation();
        } else {
            this.failedTransformation();
        }
    }

    private void playSound(SoundEvent sound) {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.f_58857_.m_5594_(null, this.f_58858_, sound, SoundSource.BLOCKS, 1.5f, 1.0f);
        }
    }

    public static boolean checkSuccess(int chance) {
        int randomValue = RANDOM.nextInt(10) + 1;
        return randomValue <= chance;
    }

    private void successTransformation() {
        ItemStack targetItemStack = this.itemHandler.getStackInSlot(4);
        if (targetItemStack.m_41720_() instanceof IRarity) {
            ItemRarityHelper.toNextRarity(targetItemStack);
        }
        this.playSound(SoundEvents.f_12471_);
    }

    private void failedTransformation() {
        this.playSound(SoundEvents.f_12018_);
    }

    private void extractResources() {
        this.extractItems(1, 3, 5, 7, 0, 2, 6, 8);
    }

    private boolean hasProgressFinished() {
        return this.progress >= this.maxProgress;
    }

    private void increaseCraftingProgress() {
        ++this.progress;
    }

    public boolean isRecipeValid() {
        List<ItemStack> resources = this.getItemsIn(0, 2, 6, 8);
        ItemStack mainItem = this.itemHandler.getStackInSlot(4);
        boolean canUpgrade = AltarRecipeManager.canUpgrade(mainItem, resources);
        boolean hasGems = this.getItemsIn(1, 3, 5, 7).stream().allMatch(item -> item.m_41720_().equals(RegisterManagerItems.GEM.get()));
        return hasGems && canUpgrade;
    }

    public ItemStack getHeldItem() {
        return this.itemHandler.getStackInSlot(4);
    }

    private List<ItemStack> getItemsIn(Integer ... slots) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        Integer[] integerArray = slots;
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int slot = integerArray[i];
            items.add(this.itemHandler.getStackInSlot(slot));
        }
        return items;
    }

    private void extractItems(Integer ... slots) {
        Integer[] integerArray = slots;
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int slot = integerArray[i];
            this.itemHandler.extractItem(slot, 1, false);
        }
    }

    public boolean isValidGemBlock(Level level, BlockPos pos) {
        return level.m_8055_(pos).m_60713_((Block)RegisterManagerBlocks.GEM_BLOCK.get());
    }

    public int getCountNearbyGemBlocks() {
        int count = 0;
        for (BlockPos offset : AltarBlock.GEM_BLOCK_OFFSETS) {
            BlockPos checkPos = this.m_58899_().m_121955_((Vec3i)offset);
            if (!this.isValidGemBlock(this.f_58857_, checkPos)) continue;
            ++count;
        }
        return Math.min(count, 9);
    }
}

