/*
 * Decompiled with CFR 0.152.
 */
package ru.xewe.immortal.blocks;

import java.util.function.Supplier;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DropExperienceBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import ru.xewe.immortal.blocks.block.AltarBlock;
import ru.xewe.immortal.blocks.blockentity.AltarBlockTile;
import ru.xewe.immortal.item.RegisterManagerItems;

public class RegisterManagerBlocks {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"immortalskills");
    public static final DeferredRegister<BlockEntityType<?>> TILE_ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCK_ENTITY_TYPES, (String)"immortalskills");
    public static final RegistryObject<Block> GEM_ORE = RegisterManagerBlocks.registerBlockWithItem("gem_ore", () -> new DropExperienceBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50089_).m_60999_()));
    public static final RegistryObject<Block> DEEPSLATE_GEM_ORE = RegisterManagerBlocks.registerBlockWithItem("deepslate_gem_ore", () -> new DropExperienceBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_152474_).m_60999_().m_60918_(SoundType.f_154677_)));
    public static final RegistryObject<Block> ALTAR_BLOCK = RegisterManagerBlocks.registerBlockWithItem("altar_block", AltarBlock::new);
    public static final RegistryObject<BlockEntityType<AltarBlockTile>> ALTAR_BLOCK_TILE = TILE_ENTITIES.register("altar_block_tile", () -> BlockEntityType.Builder.m_155273_(AltarBlockTile::new, (Block[])new Block[]{(Block)ALTAR_BLOCK.get()}).m_58966_(null));
    public static final RegistryObject<Block> GEM_BLOCK = RegisterManagerBlocks.registerBlockWithItem("gem_block", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50090_).m_60953_(l -> 10).m_60918_(SoundType.f_154654_).m_60999_()));

    private static <T extends Block> RegistryObject<T> registerBlock(String name, Supplier<T> block) {
        return BLOCKS.register(name, block);
    }

    private static <T extends Block> void registerBlockItem(String name, RegistryObject<T> block) {
        RegisterManagerItems.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
    }

    private static <T extends Block> RegistryObject<T> registerBlockWithItem(String name, Supplier<T> block) {
        RegistryObject<T> blockObject = RegisterManagerBlocks.registerBlock(name, block);
        RegisterManagerBlocks.registerBlockItem(name, blockObject);
        return blockObject;
    }

    public static void register(IEventBus eventBus) {
        BLOCKS.register(eventBus);
        TILE_ENTITIES.register(eventBus);
    }
}

