/*
 * Decompiled with CFR 0.152.
 */
package net.moddercoder.immortalgingerbread.item;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.moddercoder.immortalgingerbread.entity.ModEntityTypes;
import net.moddercoder.immortalgingerbread.entity.projectile.GingerbreadBazookaProjectileEntity;
import net.moddercoder.immortalgingerbread.item.ModItems;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0006H\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\u0006H\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\u0006H\u0016J\u0018\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0006H\u0016J(\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\rH\u0016J&\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00060\u001b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016\u00a8\u0006\u001f"}, d2={"Lnet/moddercoder/immortalgingerbread/item/GingerbreadBazookaItem;", "Lnet/minecraft/world/item/Item;", "settings", "Lnet/minecraft/world/item/Item$Properties;", "(Lnet/minecraft/world/item/Item$Properties;)V", "getFireworkRocketStackInInventory", "Lnet/minecraft/world/item/ItemStack;", "playerEntity", "Lnet/minecraft/world/entity/player/Player;", "getUseAnimation", "Lnet/minecraft/world/item/UseAnim;", "stack", "getUseDuration", "", "isRepairable", "", "isValidRepairItem", "selfStack", "otherStack", "releaseUsing", "", "world", "Lnet/minecraft/world/level/Level;", "entity", "Lnet/minecraft/world/entity/LivingEntity;", "remainingTicks", "use", "Lnet/minecraft/world/InteractionResultHolder;", "user", "hand", "Lnet/minecraft/world/InteractionHand;", "immortalgingerbread-1.20.1"})
public final class GingerbreadBazookaItem
extends Item {
    public GingerbreadBazookaItem(@NotNull Item.Properties settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        super(settings);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level world, @NotNull Player user, @NotNull InteractionHand hand) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)hand, (String)"hand");
        if (!this.getFireworkRocketStackInInventory(user).m_41619_() || user.m_7500_()) {
            user.m_6672_(hand);
            InteractionResultHolder interactionResultHolder = InteractionResultHolder.m_19096_((Object)user.m_21120_(hand));
            Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"consume(user.getItemInHand(hand))");
            return interactionResultHolder;
        }
        InteractionResultHolder interactionResultHolder = InteractionResultHolder.m_19100_((Object)user.m_21120_(hand));
        Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"fail(user.getItemInHand(hand))");
        return interactionResultHolder;
    }

    public void m_5551_(@NotNull ItemStack stack, @NotNull Level world, @NotNull LivingEntity entity, int remainingTicks) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        super.m_5551_(stack, world, entity, remainingTicks);
        if (!(entity instanceof Player)) {
            return;
        }
        int usageTicks = this.m_8105_(stack) - remainingTicks;
        if (usageTicks >= 5) {
            ItemStack ammoItemStack = this.getFireworkRocketStackInInventory((Player)entity);
            boolean creativePlayer = ((Player)entity).m_7500_();
            if (!ammoItemStack.m_41619_() || creativePlayer) {
                Object object = ModEntityTypes.INSTANCE.getGINGERBREAD_BAZOOKA_PROJECTILE().get();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ModEntityTypes.GINGERBRE\u2026_BAZOOKA_PROJECTILE.get()");
                GingerbreadBazookaProjectileEntity projectileEntity = new GingerbreadBazookaProjectileEntity((EntityType<? extends AbstractArrow>)((EntityType)object), entity, world);
                projectileEntity.setCanHurtOwner(false);
                if (creativePlayer) {
                    projectileEntity.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
                }
                ((Player)entity).m_36246_(Stats.f_12982_.m_12902_((Object)this));
                projectileEntity.m_37251_((Entity)entity, ((Player)entity).m_146909_(), ((Player)entity).m_146908_(), 0.0f, 1.6f, 1.0f);
                if (!world.f_46443_ && world.m_7967_((Entity)projectileEntity)) {
                    if (!creativePlayer) {
                        ((Player)entity).m_36335_().m_41524_((Item)this, 60);
                        ammoItemStack.m_41774_(1);
                    }
                    world.m_5594_(null, entity.m_20183_(), SoundEvents.f_11932_, SoundSource.MASTER, 1.0f, 1.0f);
                    stack.m_41622_(1, entity, GingerbreadBazookaItem::releaseUsing$lambda$0);
                }
            }
        }
    }

    private final ItemStack getFireworkRocketStackInInventory(Player playerEntity) {
        Item fireworkRocketItem = Items.f_42688_;
        ItemStack mainHandStack = playerEntity.m_21120_(InteractionHand.MAIN_HAND);
        ItemStack offHandStack = playerEntity.m_21120_(InteractionHand.OFF_HAND);
        if (mainHandStack.m_150930_(fireworkRocketItem)) {
            Intrinsics.checkNotNullExpressionValue((Object)mainHandStack, (String)"mainHandStack");
            return mainHandStack;
        }
        if (offHandStack.m_150930_(fireworkRocketItem)) {
            Intrinsics.checkNotNullExpressionValue((Object)offHandStack, (String)"offHandStack");
            return offHandStack;
        }
        int i = 0;
        int n = playerEntity.m_150109_().m_6643_();
        if (i <= n) {
            while (true) {
                ItemStack itemStack;
                if ((itemStack = playerEntity.m_150109_().m_8020_(i)).m_150930_(fireworkRocketItem)) {
                    Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"itemStack");
                    return itemStack;
                }
                if (i == n) break;
                ++i;
            }
        }
        ItemStack itemStack = ItemStack.f_41583_;
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
        return itemStack;
    }

    public boolean m_6832_(@NotNull ItemStack selfStack, @NotNull ItemStack otherStack) {
        Intrinsics.checkNotNullParameter((Object)selfStack, (String)"selfStack");
        Intrinsics.checkNotNullParameter((Object)otherStack, (String)"otherStack");
        return otherStack.m_150930_((Item)ModItems.INSTANCE.getGINGERBREAD_BAZOOKA().get()) || otherStack.m_150930_((Item)ModItems.INSTANCE.getCANDY_CANE().get());
    }

    public boolean isRepairable(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        return false;
    }

    public int m_8105_(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        return 72000;
    }

    @NotNull
    public UseAnim m_6164_(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        return UseAnim.BOW;
    }

    private static final void releaseUsing$lambda$0(Player it) {
        it.m_21190_(it.m_7655_());
    }
}

