/*
 * Decompiled with CFR 0.152.
 */
package net.moddercoder.immortalgingerbread.entity.raid;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.minecraft.world.level.block.entity.BannerPatterns;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.IExtensibleEnum;
import net.minecraftforge.event.ForgeEventFactory;
import net.moddercoder.immortalgingerbread.advancements.ModCriteriaTriggers;
import net.moddercoder.immortalgingerbread.effect.ModMobEffects;
import net.moddercoder.immortalgingerbread.entity.AbstractSpoiledPatrolEntity;
import net.moddercoder.immortalgingerbread.entity.ModEntityTypes;
import net.moddercoder.immortalgingerbread.mixinexpander.IServerLevelExpander;
import net.moddercoder.immortalgingerbread.sound.ModSoundEvents;

public class SpoiledRaid {
    private static final int SECTION_RADIUS_FOR_FINDING_NEW_VILLAGE_CENTER = 2;
    private static final int ATTEMPT_RAID_FARTHEST = 0;
    private static final int ATTEMPT_RAID_CLOSE = 1;
    private static final int ATTEMPT_RAID_INSIDE = 2;
    private static final int VILLAGE_SEARCH_RADIUS = 32;
    private static final int RAID_TIMEOUT_TICKS = 48000;
    private static final int NUM_SPAWN_ATTEMPTS = 3;
    private static final String OMINOUS_BANNER_PATTERN_NAME = "block.minecraft.ominous_banner";
    private static final String RAIDERS_REMAINING = "event.minecraft.raid.raiders_remaining";
    public static final int VILLAGE_RADIUS_BUFFER = 16;
    private static final int POST_RAID_TICK_LIMIT = 40;
    private static final int DEFAULT_PRE_RAID_TICKS = 300;
    public static final int MAX_NO_ACTION_TIME = 2400;
    public static final int MAX_CELEBRATION_TICKS = 600;
    private static final int OUTSIDE_RAID_BOUNDS_TIMEOUT = 30;
    public static final int TICKS_PER_DAY = 24000;
    public static final int DEFAULT_MAX_BAD_OMEN_LEVEL = 5;
    private static final int LOW_MOB_THRESHOLD = 2;
    private static final Component RAID_NAME_COMPONENT = Component.m_237115_((String)"event.immortalgingerbread.spoiled_raid.name");
    private static final Component VICTORY = Component.m_237115_((String)"event.minecraft.raid.victory");
    private static final Component DEFEAT = Component.m_237115_((String)"event.minecraft.raid.defeat");
    private static final Component RAID_BAR_VICTORY_COMPONENT = RAID_NAME_COMPONENT.m_6881_().m_130946_(" - ").m_7220_(VICTORY);
    private static final Component RAID_BAR_DEFEAT_COMPONENT = RAID_NAME_COMPONENT.m_6881_().m_130946_(" - ").m_7220_(DEFEAT);
    private static final int HERO_OF_THE_VILLAGE_DURATION = 48000;
    public static final int VALID_RAID_RADIUS_SQR = 9216;
    public static final int RAID_REMOVAL_THRESHOLD_SQR = 12544;
    private final Map<Integer, AbstractSpoiledPatrolEntity> groupToLeaderMap = Maps.newHashMap();
    private final Map<Integer, Set<AbstractSpoiledPatrolEntity>> groupRaiderMap = Maps.newHashMap();
    private final Set<UUID> heroesOfTheVillage = Sets.newHashSet();
    private long ticksActive;
    private BlockPos center;
    private final ServerLevel level;
    private boolean started;
    private final int id;
    private float totalHealth;
    private int badOmenLevel;
    private boolean active;
    private int groupsSpawned;
    private final ServerBossEvent raidEvent = new ServerBossEvent(RAID_NAME_COMPONENT, BossEvent.BossBarColor.WHITE, BossEvent.BossBarOverlay.NOTCHED_12);
    private int postRaidTicks;
    private int raidCooldownTicks;
    private final RandomSource random = RandomSource.m_216327_();
    private final int numGroups;
    private RaidStatus status;
    private int celebrationTicks;
    private Optional<BlockPos> waveSpawnPos = Optional.empty();

    public SpoiledRaid(int id, ServerLevel serverWorld, BlockPos centerBlockPos) {
        this.id = id;
        this.level = serverWorld;
        this.active = true;
        this.raidCooldownTicks = 300;
        this.raidEvent.m_142711_(0.0f);
        this.center = centerBlockPos;
        this.numGroups = this.getNumGroups(serverWorld.m_46791_());
        this.status = RaidStatus.ONGOING;
    }

    public SpoiledRaid(ServerLevel p_37696_, CompoundTag p_37697_) {
        this.level = p_37696_;
        this.id = p_37697_.m_128451_("Id");
        this.started = p_37697_.m_128471_("Started");
        this.active = p_37697_.m_128471_("Active");
        this.ticksActive = p_37697_.m_128454_("TicksActive");
        this.badOmenLevel = p_37697_.m_128451_("BadOmenLevel");
        this.groupsSpawned = p_37697_.m_128451_("GroupsSpawned");
        this.raidCooldownTicks = p_37697_.m_128451_("PreRaidTicks");
        this.postRaidTicks = p_37697_.m_128451_("PostRaidTicks");
        this.totalHealth = p_37697_.m_128457_("TotalHealth");
        this.center = new BlockPos(p_37697_.m_128451_("CX"), p_37697_.m_128451_("CY"), p_37697_.m_128451_("CZ"));
        this.numGroups = p_37697_.m_128451_("NumGroups");
        this.status = RaidStatus.getByName(p_37697_.m_128461_("Status"));
        this.heroesOfTheVillage.clear();
        if (p_37697_.m_128425_("HeroesOfTheVillage", 9)) {
            ListTag listtag = p_37697_.m_128437_("HeroesOfTheVillage", 11);
            for (int i = 0; i < listtag.size(); ++i) {
                this.heroesOfTheVillage.add(NbtUtils.m_129233_((Tag)listtag.get(i)));
            }
        }
    }

    public boolean isOver() {
        return this.isVictory() || this.isLoss();
    }

    public boolean isBetweenWaves() {
        return this.hasFirstWaveSpawned() && this.getTotalRaidersAlive() == 0 && this.raidCooldownTicks > 0;
    }

    public boolean hasFirstWaveSpawned() {
        return this.groupsSpawned > 0;
    }

    public boolean isStopped() {
        return this.status == RaidStatus.STOPPED;
    }

    public boolean isVictory() {
        return this.status == RaidStatus.VICTORY;
    }

    public boolean isLoss() {
        return this.status == RaidStatus.LOSS;
    }

    public float getTotalHealth() {
        return this.totalHealth;
    }

    public Set<AbstractSpoiledPatrolEntity> getAllRaiders() {
        HashSet set = Sets.newHashSet();
        for (Set<AbstractSpoiledPatrolEntity> set1 : this.groupRaiderMap.values()) {
            set.addAll(set1);
        }
        return set;
    }

    public Level getLevel() {
        return this.level;
    }

    public boolean isStarted() {
        return this.started;
    }

    public int getGroupsSpawned() {
        return this.groupsSpawned;
    }

    private Predicate<ServerPlayer> validPlayer() {
        return p_289493_ -> {
            BlockPos blockpos = p_289493_.m_20183_();
            return p_289493_.m_6084_() && ((IServerLevelExpander)this.level).getSpoiledRaidAt(blockpos) == this;
        };
    }

    private void updatePlayers() {
        HashSet set = Sets.newHashSet((Iterable)this.raidEvent.m_8324_());
        List list = this.level.m_8795_(this.validPlayer());
        for (ServerPlayer serverplayer : list) {
            if (set.contains(serverplayer)) continue;
            this.raidEvent.m_6543_(serverplayer);
        }
        for (ServerPlayer serverplayer1 : set) {
            if (list.contains(serverplayer1)) continue;
            this.raidEvent.m_6539_(serverplayer1);
        }
    }

    public int getMaxBadOmenLevel() {
        return 5;
    }

    public int getBadOmenLevel() {
        return this.badOmenLevel;
    }

    public void setBadOmenLevel(int p_150219_) {
        this.badOmenLevel = p_150219_;
    }

    public void absorbBadOmen(Player p_37729_) {
        if (p_37729_.m_21023_((MobEffect)ModMobEffects.INSTANCE.getSUGAR_RUSH().get())) {
            this.badOmenLevel += p_37729_.m_21124_((MobEffect)ModMobEffects.INSTANCE.getSUGAR_RUSH().get()).m_19564_() + 1;
            this.badOmenLevel = Mth.m_14045_((int)this.badOmenLevel, (int)0, (int)this.getMaxBadOmenLevel());
        }
        p_37729_.m_21195_((MobEffect)ModMobEffects.INSTANCE.getSUGAR_RUSH().get());
    }

    public void stop() {
        this.active = false;
        this.raidEvent.m_7706_();
        this.status = RaidStatus.STOPPED;
    }

    public void tick() {
        if (!this.isStopped()) {
            if (this.status == RaidStatus.ONGOING) {
                boolean flag = this.active;
                this.active = this.level.m_46805_(this.center);
                if (this.level.m_46791_() == Difficulty.PEACEFUL) {
                    this.stop();
                    return;
                }
                if (flag != this.active) {
                    this.raidEvent.m_8321_(this.active);
                }
                if (!this.active) {
                    return;
                }
                if (!this.level.m_8802_(this.center)) {
                    this.moveRaidCenterToNearbyVillageSection();
                }
                if (!this.level.m_8802_(this.center)) {
                    if (this.groupsSpawned > 0) {
                        this.status = RaidStatus.LOSS;
                        this.playSound(this.waveSpawnPos.isPresent() ? this.waveSpawnPos.get() : this.findRandomSpawnPos(0, 12), (Holder<SoundEvent>)((Holder)ModSoundEvents.INSTANCE.getSPOILED_RAID_FAIL().getHolder().orElse(SoundEvents.f_12355_)));
                    } else {
                        this.stop();
                    }
                }
                ++this.ticksActive;
                if (this.ticksActive >= 48000L) {
                    this.stop();
                    return;
                }
                int i = this.getTotalRaidersAlive();
                if (i == 0 && this.hasMoreWaves()) {
                    if (this.raidCooldownTicks <= 0) {
                        if (this.raidCooldownTicks == 0 && this.groupsSpawned > 0) {
                            this.raidCooldownTicks = 300;
                            this.raidEvent.m_6456_(RAID_NAME_COMPONENT);
                            return;
                        }
                    } else {
                        boolean flag2;
                        boolean flag1 = this.waveSpawnPos.isPresent();
                        boolean bl = flag2 = !flag1 && this.raidCooldownTicks % 5 == 0;
                        if (flag1 && !this.level.m_143340_(this.waveSpawnPos.get())) {
                            flag2 = true;
                        }
                        if (flag2) {
                            int j = 0;
                            if (this.raidCooldownTicks < 100) {
                                j = 1;
                            } else if (this.raidCooldownTicks < 40) {
                                j = 2;
                            }
                            this.waveSpawnPos = this.getValidSpawnPos(j);
                        }
                        if (this.raidCooldownTicks == 300 || this.raidCooldownTicks % 20 == 0) {
                            this.updatePlayers();
                        }
                        --this.raidCooldownTicks;
                        this.raidEvent.m_142711_(Mth.m_14036_((float)((float)(300 - this.raidCooldownTicks) / 300.0f), (float)0.0f, (float)1.0f));
                    }
                }
                if (this.ticksActive % 20L == 0L) {
                    this.updatePlayers();
                    this.updateRaiders();
                    if (i > 0) {
                        if (i <= 2) {
                            this.raidEvent.m_6456_((Component)RAID_NAME_COMPONENT.m_6881_().m_130946_(" - ").m_7220_((Component)Component.m_237110_((String)RAIDERS_REMAINING, (Object[])new Object[]{i})));
                        } else {
                            this.raidEvent.m_6456_(RAID_NAME_COMPONENT);
                        }
                    } else {
                        this.raidEvent.m_6456_(RAID_NAME_COMPONENT);
                    }
                }
                boolean flag3 = false;
                int k = 0;
                while (this.shouldSpawnGroup()) {
                    BlockPos blockpos;
                    BlockPos blockPos = blockpos = this.waveSpawnPos.isPresent() ? this.waveSpawnPos.get() : this.findRandomSpawnPos(k, 12);
                    if (blockpos != null) {
                        this.started = true;
                        this.spawnGroup(blockpos);
                        if (!flag3) {
                            this.playSound(blockpos, (Holder<SoundEvent>)((Holder)ModSoundEvents.INSTANCE.getSPOILED_RAID_START().getHolder().get()));
                            flag3 = true;
                        }
                    } else {
                        ++k;
                    }
                    if (k <= 3) continue;
                    this.stop();
                    break;
                }
                if (this.isStarted() && !this.hasMoreWaves() && i == 0) {
                    if (this.postRaidTicks < 40) {
                        ++this.postRaidTicks;
                    } else {
                        this.status = RaidStatus.VICTORY;
                        for (UUID uuid : this.heroesOfTheVillage) {
                            Entity entity = this.level.m_8791_(uuid);
                            if (!(entity instanceof LivingEntity) || entity.m_5833_()) continue;
                            LivingEntity livingentity = (LivingEntity)entity;
                            livingentity.m_7292_(new MobEffectInstance(MobEffects.f_19595_, 48000, this.badOmenLevel - 1, false, false, true));
                            if (!(livingentity instanceof ServerPlayer)) continue;
                            ServerPlayer serverplayer = (ServerPlayer)livingentity;
                            serverplayer.m_6330_((SoundEvent)ModSoundEvents.INSTANCE.getSPOILED_RAID_FINISH().get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
                            serverplayer.m_36220_(Stats.f_12950_);
                            ModCriteriaTriggers.INSTANCE.getSPOILED_RAID_WIN().m_222618_(serverplayer);
                        }
                    }
                }
                this.setDirty();
            } else if (this.isOver()) {
                ++this.celebrationTicks;
                if (this.celebrationTicks >= 600) {
                    this.stop();
                    return;
                }
                if (this.celebrationTicks % 20 == 0) {
                    this.updatePlayers();
                    this.raidEvent.m_8321_(true);
                    if (this.isVictory()) {
                        this.raidEvent.m_142711_(0.0f);
                        this.raidEvent.m_6456_(RAID_BAR_VICTORY_COMPONENT);
                    } else {
                        this.raidEvent.m_6456_(RAID_BAR_DEFEAT_COMPONENT);
                    }
                }
            }
        }
    }

    private void moveRaidCenterToNearbyVillageSection() {
        Stream stream = SectionPos.m_123201_((SectionPos)SectionPos.m_123199_((BlockPos)this.center), (int)2);
        stream.filter(arg_0 -> ((ServerLevel)this.level).m_8762_(arg_0)).map(SectionPos::m_123250_).min(Comparator.comparingDouble(p_37766_ -> p_37766_.m_123331_((Vec3i)this.center))).ifPresent(this::setCenter);
    }

    private Optional<BlockPos> getValidSpawnPos(int p_37764_) {
        for (int i = 0; i < 3; ++i) {
            BlockPos blockpos = this.findRandomSpawnPos(p_37764_, 1);
            if (blockpos == null) continue;
            return Optional.of(blockpos);
        }
        return Optional.empty();
    }

    private boolean hasMoreWaves() {
        if (this.hasBonusWave()) {
            return !this.hasSpawnedBonusWave();
        }
        return !this.isFinalWave();
    }

    private boolean isFinalWave() {
        return this.getGroupsSpawned() == this.numGroups;
    }

    private boolean hasBonusWave() {
        return this.badOmenLevel > 1;
    }

    private boolean hasSpawnedBonusWave() {
        return this.getGroupsSpawned() > this.numGroups;
    }

    private boolean shouldSpawnBonusGroup() {
        return this.isFinalWave() && this.getTotalRaidersAlive() == 0 && this.hasBonusWave();
    }

    private void updateRaiders() {
        Iterator<Set<AbstractSpoiledPatrolEntity>> iterator = this.groupRaiderMap.values().iterator();
        HashSet set = Sets.newHashSet();
        while (iterator.hasNext()) {
            Set<AbstractSpoiledPatrolEntity> set1 = iterator.next();
            for (AbstractSpoiledPatrolEntity raider : set1) {
                BlockPos blockpos = raider.m_20183_();
                if (!raider.m_213877_() && raider.m_9236_().m_46472_() == this.level.m_46472_() && !(this.center.m_123331_((Vec3i)blockpos) >= 12544.0)) {
                    if (raider.f_19797_ <= 600) continue;
                    if (this.level.m_8791_(raider.m_20148_()) == null) {
                        set.add(raider);
                    }
                    if (!this.level.m_8802_(blockpos) && raider.m_21216_() > 2400) {
                        raider.setTicksOutsideRaid(raider.getTicksOutsideRaid() + 1);
                    }
                    if (raider.getTicksOutsideRaid() < 30) continue;
                    set.add(raider);
                    continue;
                }
                set.add(raider);
            }
        }
        for (AbstractSpoiledPatrolEntity raider1 : set) {
            this.removeFromRaid(raider1, true);
        }
    }

    private void playSound(BlockPos p_37744_, Holder<SoundEvent> soundEventHolder) {
        float f = 13.0f;
        int i = 64;
        Collection collection = this.raidEvent.m_8324_();
        long j = this.random.m_188505_();
        for (ServerPlayer serverplayer : this.level.m_6907_()) {
            Vec3 vec3 = serverplayer.m_20182_();
            Vec3 vec31 = Vec3.m_82512_((Vec3i)p_37744_);
            double d0 = Math.sqrt((vec31.f_82479_ - vec3.f_82479_) * (vec31.f_82479_ - vec3.f_82479_) + (vec31.f_82481_ - vec3.f_82481_) * (vec31.f_82481_ - vec3.f_82481_));
            double d1 = vec3.f_82479_ + 13.0 / d0 * (vec31.f_82479_ - vec3.f_82479_);
            double d2 = vec3.f_82481_ + 13.0 / d0 * (vec31.f_82481_ - vec3.f_82481_);
            if (!(d0 <= 64.0) && !collection.contains(serverplayer)) continue;
            serverplayer.f_8906_.m_9829_((Packet)new ClientboundSoundPacket(soundEventHolder, SoundSource.NEUTRAL, d1, serverplayer.m_20186_(), d2, 64.0f, 1.0f, j));
        }
    }

    private void spawnGroup(BlockPos p_37756_) {
        int i = this.groupsSpawned + 1;
        this.totalHealth = 0.0f;
        DifficultyInstance difficultyinstance = this.level.m_6436_(p_37756_);
        boolean flag1 = this.shouldSpawnBonusGroup();
        for (RaiderType raid$raidertype : RaiderType.VALUES) {
            AbstractSpoiledPatrolEntity raider;
            int j = this.getDefaultNumSpawns(raid$raidertype, i, flag1) + this.getPotentialBonusSpawns(raid$raidertype, this.random, i, difficultyinstance, flag1);
            boolean k = false;
            for (int l = 0; l < j && (raider = (AbstractSpoiledPatrolEntity)raid$raidertype.entityType.m_20615_((Level)this.level)) != null; ++l) {
                this.joinRaid(i, raider, p_37756_, false);
            }
        }
        this.waveSpawnPos = Optional.empty();
        ++this.groupsSpawned;
        this.updateBossbar();
        this.setDirty();
    }

    public void joinRaid(int p_37714_, AbstractSpoiledPatrolEntity p_37715_, @Nullable BlockPos p_37716_, boolean p_37717_) {
        boolean flag = this.addWaveMob(p_37714_, p_37715_);
        if (flag) {
            p_37715_.setCurrentRaid(this);
            p_37715_.setWave(p_37714_);
            p_37715_.setCanJoinRaid(true);
            p_37715_.setTicksOutsideRaid(0);
            if (!p_37717_ && p_37716_ != null) {
                p_37715_.m_6034_((double)p_37716_.m_123341_() + 0.5, (double)p_37716_.m_123342_() + 1.0, (double)p_37716_.m_123343_() + 0.5);
                ForgeEventFactory.onFinalizeSpawn((Mob)p_37715_, (ServerLevelAccessor)this.level, (DifficultyInstance)this.level.m_6436_(p_37716_), (MobSpawnType)MobSpawnType.PATROL, null, null);
                p_37715_.applyRaidBuffs(p_37714_, false);
                p_37715_.m_6853_(true);
                this.level.m_47205_((Entity)p_37715_);
            }
        }
    }

    public void updateBossbar() {
        this.raidEvent.m_142711_(Mth.m_14036_((float)(this.getHealthOfLivingRaiders() / this.totalHealth), (float)0.0f, (float)1.0f));
    }

    public float getHealthOfLivingRaiders() {
        float f = 0.0f;
        for (Set<AbstractSpoiledPatrolEntity> set : this.groupRaiderMap.values()) {
            for (AbstractSpoiledPatrolEntity raider : set) {
                f += raider.m_21223_();
            }
        }
        return f;
    }

    private boolean shouldSpawnGroup() {
        return this.raidCooldownTicks == 0 && (this.groupsSpawned < this.numGroups || this.shouldSpawnBonusGroup()) && this.getTotalRaidersAlive() == 0;
    }

    public int getTotalRaidersAlive() {
        return this.groupRaiderMap.values().stream().mapToInt(Set::size).sum();
    }

    public void removeFromRaid(AbstractSpoiledPatrolEntity p_37741_, boolean p_37742_) {
        boolean flag;
        Set<AbstractSpoiledPatrolEntity> set = this.groupRaiderMap.get(p_37741_.getWave());
        if (set != null && (flag = set.remove(p_37741_))) {
            if (p_37742_) {
                this.totalHealth -= p_37741_.m_21223_();
            }
            p_37741_.setCurrentRaid(null);
            this.updateBossbar();
            this.setDirty();
        }
    }

    private void setDirty() {
        ((IServerLevelExpander)this.level).getSpoiledRaids().m_77762_();
    }

    public static ItemStack getLeaderBannerInstance() {
        ItemStack itemstack = new ItemStack((ItemLike)Items.f_42660_);
        CompoundTag compoundtag = new CompoundTag();
        ListTag listtag = new BannerPattern.Builder().m_222705_(BannerPatterns.f_222751_, DyeColor.CYAN).m_222705_(BannerPatterns.f_222731_, DyeColor.LIGHT_GRAY).m_222705_(BannerPatterns.f_222735_, DyeColor.GRAY).m_222705_(BannerPatterns.f_222715_, DyeColor.LIGHT_GRAY).m_222705_(BannerPatterns.f_222736_, DyeColor.BLACK).m_222705_(BannerPatterns.f_222712_, DyeColor.LIGHT_GRAY).m_222705_(BannerPatterns.f_222750_, DyeColor.LIGHT_GRAY).m_222705_(BannerPatterns.f_222715_, DyeColor.BLACK).m_58587_();
        compoundtag.m_128365_("Patterns", (Tag)listtag);
        BlockItem.m_186338_((ItemStack)itemstack, (BlockEntityType)BlockEntityType.f_58935_, (CompoundTag)compoundtag);
        itemstack.m_41654_(ItemStack.TooltipPart.ADDITIONAL);
        itemstack.m_41714_((Component)Component.m_237115_((String)OMINOUS_BANNER_PATTERN_NAME).m_130940_(ChatFormatting.GOLD));
        return itemstack;
    }

    @Nullable
    public AbstractSpoiledPatrolEntity getLeader(int p_37751_) {
        return this.groupToLeaderMap.get(p_37751_);
    }

    @Nullable
    private BlockPos findRandomSpawnPos(int p_37708_, int p_37709_) {
        int i = p_37708_ == 0 ? 2 : 2 - p_37708_;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (int i1 = 0; i1 < p_37709_; ++i1) {
            float f = this.level.f_46441_.m_188501_() * ((float)Math.PI * 2);
            int j = this.center.m_123341_() + Mth.m_14143_((float)(Mth.m_14089_((float)f) * 16.0f * (float)i)) + this.level.f_46441_.m_188503_(5);
            int l = this.center.m_123343_() + Mth.m_14143_((float)(Mth.m_14031_((float)f) * 16.0f * (float)i)) + this.level.f_46441_.m_188503_(5);
            int k = this.level.m_6924_(Heightmap.Types.WORLD_SURFACE, j, l);
            blockpos$mutableblockpos.m_122178_(j, k, l);
            if (this.level.m_8802_((BlockPos)blockpos$mutableblockpos) && p_37708_ < 2) continue;
            int j1 = 10;
            if (!this.level.m_151572_(blockpos$mutableblockpos.m_123341_() - 10, blockpos$mutableblockpos.m_123343_() - 10, blockpos$mutableblockpos.m_123341_() + 10, blockpos$mutableblockpos.m_123343_() + 10) || !this.level.m_143340_((BlockPos)blockpos$mutableblockpos) || !NaturalSpawner.m_47051_((SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (LevelReader)this.level, (BlockPos)blockpos$mutableblockpos, (EntityType)EntityType.f_20518_) && (!this.level.m_8055_(blockpos$mutableblockpos.m_7495_()).m_60713_(Blocks.f_50125_) || !this.level.m_8055_((BlockPos)blockpos$mutableblockpos).m_60795_())) continue;
            return blockpos$mutableblockpos;
        }
        return null;
    }

    private boolean addWaveMob(int p_37753_, AbstractSpoiledPatrolEntity p_37754_) {
        return this.addWaveMob(p_37753_, p_37754_, true);
    }

    public boolean addWaveMob(int p_37719_, AbstractSpoiledPatrolEntity p_37720_, boolean p_37721_) {
        this.groupRaiderMap.computeIfAbsent(p_37719_, p_37746_ -> Sets.newHashSet());
        Set<AbstractSpoiledPatrolEntity> set = this.groupRaiderMap.get(p_37719_);
        AbstractSpoiledPatrolEntity raider = null;
        for (AbstractSpoiledPatrolEntity raider1 : set) {
            if (!raider1.m_20148_().equals(p_37720_.m_20148_())) continue;
            raider = raider1;
            break;
        }
        if (raider != null) {
            set.remove(raider);
            set.add(p_37720_);
        }
        set.add(p_37720_);
        if (p_37721_) {
            this.totalHealth += p_37720_.m_21223_();
        }
        this.updateBossbar();
        this.setDirty();
        return true;
    }

    public void setLeader(int p_37711_, AbstractSpoiledPatrolEntity p_37712_) {
        this.groupToLeaderMap.put(p_37711_, p_37712_);
        p_37712_.m_8061_(EquipmentSlot.HEAD, SpoiledRaid.getLeaderBannerInstance());
        p_37712_.m_21409_(EquipmentSlot.HEAD, 2.0f);
    }

    public void removeLeader(int p_37759_) {
        this.groupToLeaderMap.remove(p_37759_);
    }

    public BlockPos getCenter() {
        return this.center;
    }

    private void setCenter(BlockPos p_37761_) {
        this.center = p_37761_;
    }

    public int getId() {
        return this.id;
    }

    private int getDefaultNumSpawns(RaiderType p_37731_, int p_37732_, boolean p_37733_) {
        return p_37733_ ? p_37731_.spawnsPerWaveBeforeBonus[this.numGroups] : p_37731_.spawnsPerWaveBeforeBonus[p_37732_];
    }

    private int getPotentialBonusSpawns(RaiderType p_219829_, RandomSource p_219830_, int p_219831_, DifficultyInstance p_219832_, boolean p_219833_) {
        int i;
        Difficulty difficulty = p_219832_.m_19048_();
        boolean flag = difficulty == Difficulty.EASY;
        boolean flag1 = difficulty == Difficulty.NORMAL;
        switch (p_219829_) {
            case SPOILED_GINGERBREAD_MAN_ENTITY: {
                i = 1;
                break;
            }
            case SPOILED_GINGERBREAD_GOLEM_ENTITY: {
                i = !flag1 && p_219833_ ? 1 : 0;
                break;
            }
            default: {
                return 0;
            }
        }
        return i > 0 ? p_219830_.m_188503_(i + 1) : 0;
    }

    public boolean isActive() {
        return this.active;
    }

    public CompoundTag save(CompoundTag p_37748_) {
        p_37748_.m_128405_("Id", this.id);
        p_37748_.m_128379_("Started", this.started);
        p_37748_.m_128379_("Active", this.active);
        p_37748_.m_128356_("TicksActive", this.ticksActive);
        p_37748_.m_128405_("BadOmenLevel", this.badOmenLevel);
        p_37748_.m_128405_("GroupsSpawned", this.groupsSpawned);
        p_37748_.m_128405_("PreRaidTicks", this.raidCooldownTicks);
        p_37748_.m_128405_("PostRaidTicks", this.postRaidTicks);
        p_37748_.m_128350_("TotalHealth", this.totalHealth);
        p_37748_.m_128405_("NumGroups", this.numGroups);
        p_37748_.m_128359_("Status", this.status.getName());
        p_37748_.m_128405_("CX", this.center.m_123341_());
        p_37748_.m_128405_("CY", this.center.m_123342_());
        p_37748_.m_128405_("CZ", this.center.m_123343_());
        ListTag listtag = new ListTag();
        for (UUID uuid : this.heroesOfTheVillage) {
            listtag.add((Object)NbtUtils.m_129226_((UUID)uuid));
        }
        p_37748_.m_128365_("HeroesOfTheVillage", (Tag)listtag);
        return p_37748_;
    }

    public int getNumGroups(Difficulty p_37725_) {
        switch (p_37725_) {
            case EASY: {
                return 3;
            }
            case NORMAL: {
                return 5;
            }
            case HARD: {
                return 7;
            }
        }
        return 0;
    }

    public float getEnchantOdds() {
        int i = this.getBadOmenLevel();
        if (i == 2) {
            return 0.1f;
        }
        if (i == 3) {
            return 0.25f;
        }
        if (i == 4) {
            return 0.5f;
        }
        return i == 5 ? 0.75f : 0.0f;
    }

    public void addHeroOfTheVillage(Entity p_37727_) {
        this.heroesOfTheVillage.add(p_37727_.m_20148_());
    }

    static enum RaidStatus {
        ONGOING,
        VICTORY,
        LOSS,
        STOPPED;

        private static final RaidStatus[] VALUES;

        static RaidStatus getByName(String p_37804_) {
            for (RaidStatus raid$raidstatus : VALUES) {
                if (!p_37804_.equalsIgnoreCase(raid$raidstatus.name())) continue;
                return raid$raidstatus;
            }
            return ONGOING;
        }

        public String getName() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        static {
            VALUES = RaidStatus.values();
        }
    }

    public static enum RaiderType implements IExtensibleEnum
    {
        SPOILED_GINGERBREAD_MAN_ENTITY((EntityType<? extends AbstractSpoiledPatrolEntity>)((EntityType)ModEntityTypes.INSTANCE.getSPOILED_GINGERBREAD_MAN().get()), new int[]{6, 9, 9, 12, 12, 15, 15, 20}),
        SPOILED_GINGERBREAD_GOLEM_ENTITY((EntityType<? extends AbstractSpoiledPatrolEntity>)((EntityType)ModEntityTypes.INSTANCE.getSPOILED_GINGERBREAD_GOLEM().get()), new int[]{1, 1, 2, 3, 3, 3, 4, 4});

        static RaiderType[] VALUES;
        final EntityType<? extends AbstractSpoiledPatrolEntity> entityType;
        final int[] spawnsPerWaveBeforeBonus;

        private RaiderType(EntityType<? extends AbstractSpoiledPatrolEntity> entityType, int[] spawnsPerWaveBeforeBonus) {
            this.entityType = entityType;
            this.spawnsPerWaveBeforeBonus = spawnsPerWaveBeforeBonus;
        }

        public static RaiderType create(String name, EntityType<? extends AbstractSpoiledPatrolEntity> typeIn, int[] waveCountsIn) {
            throw new IllegalStateException("Enum not extended");
        }

        @Deprecated
        public void init() {
            VALUES = RaiderType.values();
        }

        static {
            VALUES = RaiderType.values();
        }
    }
}

