/*
 * Decompiled with CFR 0.152.
 */
package net.moddercoder.immortalgingerbread.entity.projectile;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.moddercoder.immortalgingerbread.entity.ISpoiledPatrolEntity;
import net.moddercoder.immortalgingerbread.item.ModItems;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B'\b\u0016\u0012\u000e\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tB\u001d\u0012\u000e\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0004\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0016J\b\u0010#\u001a\u00020 H\u0016J\u0018\u0010$\u001a\u00020 2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010%\u001a\u00020&H\u0002J\b\u0010'\u001a\u00020 H\u0002J\b\u0010(\u001a\u00020\fH\u0016J\b\u0010)\u001a\u00020*H\u0014J\b\u0010+\u001a\u00020,H\u0014J\u0006\u0010\u0019\u001a\u00020\u001aJ\u000e\u0010\u0019\u001a\u00020\u00002\u0006\u0010-\u001a\u00020\u001aJ\u0010\u0010.\u001a\u00020 2\u0006\u0010/\u001a\u000200H\u0014J\u0010\u00101\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0016J\u0010\u00102\u001a\u00020 2\u0006\u00103\u001a\u000204H\u0016R\u0016\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0011\"\u0004\b\u0016\u0010\u0013R\u0016\u0010\u0017\u001a\n \r*\u0004\u0018\u00010\u00180\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0019\u001a\u00020\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001e\u00a8\u00065"}, d2={"Lnet/moddercoder/immortalgingerbread/entity/projectile/GingerbreadBazookaProjectileEntity;", "Lnet/minecraft/world/entity/projectile/AbstractArrow;", "Lsoftware/bernie/geckolib/animatable/GeoEntity;", "entityType", "Lnet/minecraft/world/entity/EntityType;", "owner", "Lnet/minecraft/world/entity/LivingEntity;", "world", "Lnet/minecraft/world/level/Level;", "(Lnet/minecraft/world/entity/EntityType;Lnet/minecraft/world/entity/LivingEntity;Lnet/minecraft/world/level/Level;)V", "(Lnet/minecraft/world/entity/EntityType;Lnet/minecraft/world/level/Level;)V", "animatableInstanceCache", "Lsoftware/bernie/geckolib/core/animatable/instance/AnimatableInstanceCache;", "kotlin.jvm.PlatformType", "canHurtOwner", "", "getCanHurtOwner", "()Z", "setCanHurtOwner", "(Z)V", "canHurtSpoiledEntities", "getCanHurtSpoiledEntities", "setCanHurtSpoiledEntities", "flyAnimation", "Lsoftware/bernie/geckolib/core/animation/RawAnimation;", "maxDamage", "", "getMaxDamage", "()F", "setMaxDamage", "(F)V", "addAdditionalSaveData", "", "tag", "Lnet/minecraft/nbt/CompoundTag;", "baseTick", "dealExplosionDamage", "causeEntity", "Lnet/minecraft/world/entity/Entity;", "explode", "getAnimatableInstanceCache", "getDefaultHitGroundSoundEvent", "Lnet/minecraft/sounds/SoundEvent;", "getPickupItem", "Lnet/minecraft/world/item/ItemStack;", "value", "onHitEntity", "hitResult", "Lnet/minecraft/world/phys/EntityHitResult;", "readAdditionalSaveData", "registerControllers", "controllerRegistrar", "Lsoftware/bernie/geckolib/core/animation/AnimatableManager$ControllerRegistrar;", "immortalgingerbread-1.20.1"})
public final class GingerbreadBazookaProjectileEntity
extends AbstractArrow
implements GeoEntity {
    private final AnimatableInstanceCache animatableInstanceCache;
    private final RawAnimation flyAnimation;
    private boolean canHurtOwner;
    private boolean canHurtSpoiledEntities;
    private float maxDamage;

    public GingerbreadBazookaProjectileEntity(@NotNull EntityType<? extends AbstractArrow> entityType, @NotNull Level world) {
        Intrinsics.checkNotNullParameter(entityType, (String)"entityType");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        super(entityType, world);
        this.animatableInstanceCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)((GeoAnimatable)this));
        this.flyAnimation = RawAnimation.begin().thenPlay("animation_fly");
        this.canHurtOwner = true;
        this.canHurtSpoiledEntities = true;
        this.maxDamage = 12.0f;
    }

    public final boolean getCanHurtOwner() {
        return this.canHurtOwner;
    }

    public final void setCanHurtOwner(boolean bl) {
        this.canHurtOwner = bl;
    }

    public final boolean getCanHurtSpoiledEntities() {
        return this.canHurtSpoiledEntities;
    }

    public final void setCanHurtSpoiledEntities(boolean bl) {
        this.canHurtSpoiledEntities = bl;
    }

    public GingerbreadBazookaProjectileEntity(@NotNull EntityType<? extends AbstractArrow> entityType, @NotNull LivingEntity owner, @NotNull Level world) {
        Intrinsics.checkNotNullParameter(entityType, (String)"entityType");
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        this(entityType, world);
        this.m_5602_((Entity)owner);
        this.m_6034_(owner.m_20185_(), owner.m_20188_() - 0.1, owner.m_20189_());
    }

    public void m_6075_() {
        Level world = this.m_9236_();
        if (world.f_46443_) {
            if (world.m_46467_() % (long)2 == 0L) {
                world.m_7106_((ParticleOptions)ParticleTypes.f_123815_, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.f_19796_.m_188583_() * 0.05, -this.m_20184_().f_82480_ * 0.5, this.f_19796_.m_188583_() * 0.05);
            }
        } else if (this.f_36703_) {
            this.explode();
        }
        super.m_6075_();
    }

    protected void m_5790_(@NotNull EntityHitResult hitResult) {
        Intrinsics.checkNotNullParameter((Object)hitResult, (String)"hitResult");
        this.explode();
    }

    @NotNull
    protected SoundEvent m_7239_() {
        SoundEvent soundEvent = SoundEvents.f_11928_;
        Intrinsics.checkNotNullExpressionValue((Object)soundEvent, (String)"FIREWORK_ROCKET_BLAST");
        return soundEvent;
    }

    public final float getMaxDamage() {
        return this.maxDamage;
    }

    public final void setMaxDamage(float f) {
        this.maxDamage = f;
    }

    @NotNull
    public final GingerbreadBazookaProjectileEntity maxDamage(float value) {
        this.maxDamage = value;
        return this;
    }

    public final float maxDamage() {
        return this.maxDamage;
    }

    private final void explode() {
        Level world = this.m_9236_();
        Entity entity = this.m_19749_();
        if (entity == null) {
            entity = (Entity)this;
        }
        Intrinsics.checkNotNullExpressionValue((Object)entity, (String)"this.owner ?: this");
        Entity causeEntity = entity;
        this.m_146852_(GameEvent.f_157812_, causeEntity);
        Intrinsics.checkNotNullExpressionValue((Object)world, (String)"world");
        this.dealExplosionDamage(world, causeEntity);
        world.m_5594_(null, this.m_20183_(), SoundEvents.f_11913_, SoundSource.MASTER, 2.0f, (1.0f + (world.f_46441_.m_188501_() - world.f_46441_.m_188501_()) * 0.2f) * 0.7f);
        if (world instanceof ServerLevel) {
            ((ServerLevel)world).m_8767_((ParticleOptions)ParticleTypes.f_123815_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 16, 0.4, 0.4, 0.4, 0.1);
            ((ServerLevel)world).m_8767_((ParticleOptions)ParticleTypes.f_123813_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
        }
        this.m_146870_();
    }

    private final void dealExplosionDamage(Level world, Entity causeEntity) {
        Vec3 selfCenterPosition = this.m_20183_().m_252807_();
        for (LivingEntity targetEntity : world.m_45976_(LivingEntity.class, this.m_20191_().m_82400_(4.0))) {
            float maxDamage;
            if (targetEntity instanceof TamableAnimal && Intrinsics.areEqual((Object)((TamableAnimal)targetEntity).m_269323_(), (Object)causeEntity)) continue;
            boolean ownerTarget = Intrinsics.areEqual((Object)targetEntity, (Object)causeEntity);
            if (!this.canHurtOwner && ownerTarget || !this.canHurtSpoiledEntities && targetEntity instanceof ISpoiledPatrolEntity) continue;
            Vec3 targetCenterBodyPosition = targetEntity.m_20182_().m_82520_(0.0, (double)targetEntity.m_20206_() * 0.5, 0.0);
            float distance = (float)Math.sqrt((float)this.m_20238_(targetCenterBodyPosition));
            float damageDistance = ownerTarget ? 2.0f : 4.0f;
            float damageDeadZone = ownerTarget ? 1.2f : 1.8f;
            float f = maxDamage = ownerTarget ? this.maxDamage / (float)2 : this.maxDamage;
            if (distance > damageDistance) continue;
            boolean canDamage = false;
            for (int i = 0; i < 2; ++i) {
                Vec3 fromRayPos = new Vec3(selfCenterPosition.f_82479_, selfCenterPosition.f_82480_ + (double)i * 1.0, selfCenterPosition.f_82481_);
                BlockHitResult blockHitResult = world.m_45547_(new ClipContext(fromRayPos, targetCenterBodyPosition, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
                Intrinsics.checkNotNullExpressionValue((Object)blockHitResult, (String)"world.clip(ClipContext(f\u2026ontext.Fluid.NONE, this))");
                HitResult hitResult = (HitResult)blockHitResult;
                if (hitResult.m_6662_() != HitResult.Type.MISS) continue;
                canDamage = true;
                break;
            }
            if (!canDamage) continue;
            float damage = distance <= damageDeadZone ? maxDamage : maxDamage + (maxDamage * damageDeadZone - maxDamage * distance) / (damageDistance - damageDeadZone);
            targetEntity.m_6469_(this.m_269291_().m_269036_((Entity)this, causeEntity), damage);
            if (!(causeEntity instanceof LivingEntity)) continue;
            ((LivingEntity)causeEntity).m_21335_((Entity)targetEntity);
        }
    }

    public void m_7378_(@NotNull CompoundTag tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        super.m_7378_(tag);
        if (tag.m_128425_("MaxDamage", 5)) {
            this.maxDamage = tag.m_128457_("MaxDamage");
        }
        if (tag.m_128425_("CanHurtOwner", 5)) {
            this.canHurtOwner = tag.m_128471_("CanHurtOwner");
        }
    }

    public void m_7380_(@NotNull CompoundTag tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        super.m_7380_(tag);
        tag.m_128350_("MaxDamage", this.maxDamage());
        tag.m_128379_("CanHurtOwner", this.canHurtOwner);
    }

    public void registerControllers(@NotNull AnimatableManager.ControllerRegistrar controllerRegistrar) {
        Intrinsics.checkNotNullParameter((Object)controllerRegistrar, (String)"controllerRegistrar");
        AnimationController[] animationControllerArray = new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", arg_0 -> GingerbreadBazookaProjectileEntity.registerControllers$lambda$0(this, arg_0))};
        controllerRegistrar.add(animationControllerArray);
    }

    @NotNull
    protected ItemStack m_7941_() {
        ItemStack itemStack = ((Item)ModItems.INSTANCE.getGINGERBREAD_BAZOOKA().get()).m_7968_();
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"ModItems.GINGERBREAD_BAZOOKA.get().defaultInstance");
        return itemStack;
    }

    @NotNull
    public AnimatableInstanceCache getAnimatableInstanceCache() {
        AnimatableInstanceCache animatableInstanceCache = this.animatableInstanceCache;
        Intrinsics.checkNotNullExpressionValue((Object)animatableInstanceCache, (String)"animatableInstanceCache");
        return animatableInstanceCache;
    }

    private static final PlayState registerControllers$lambda$0(GingerbreadBazookaProjectileEntity this$0, AnimationState it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        return it.setAndContinue(this$0.flyAnimation);
    }
}

