/*
 * Decompiled with CFR 0.152.
 */
package net.moddercoder.immortalgingerbread.entity.ai.goal;

import java.util.EnumSet;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.RangedAttackMob;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB'\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0005\u0012\u0006\u0010\n\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u000bJ\b\u0010(\u001a\u00020)H\u0016J\b\u0010*\u001a\u00020)H\u0016J\b\u0010+\u001a\u00020)H\u0016J\b\u0010,\u001a\u00020-H\u0016J\b\u0010.\u001a\u00020-H\u0016R\u001a\u0010\n\u001a\u00020\u0005X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\t\u001a\u00020\u0005X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\r\"\u0004\b\u0011\u0010\u000fR\u001a\u0010\u0006\u001a\u00020\u0007X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u0005X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\r\"\u0004\b\u0018\u0010\u000fR\u0014\u0010\u0019\u001a\u00020\u001aX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u001a\u0010\u001f\u001a\u00020\u0005X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\r\"\u0004\b!\u0010\u000fR\u001c\u0010\"\u001a\u0004\u0018\u00010#X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'\u00a8\u0006/"}, d2={"Lnet/moddercoder/immortalgingerbread/entity/ai/goal/OnSiteRangedAttackGoal;", "Lnet/minecraft/world/entity/ai/goal/Goal;", "rangedAttackMob", "Lnet/minecraft/world/entity/monster/RangedAttackMob;", "attackInterval", "", "attackRadius", "", "(Lnet/minecraft/world/entity/monster/RangedAttackMob;IF)V", "attackIntervalMin", "attackIntervalMax", "(Lnet/minecraft/world/entity/monster/RangedAttackMob;IIF)V", "getAttackIntervalMax", "()I", "setAttackIntervalMax", "(I)V", "getAttackIntervalMin", "setAttackIntervalMin", "getAttackRadius", "()F", "setAttackRadius", "(F)V", "attackTime", "getAttackTime", "setAttackTime", "mob", "Lnet/minecraft/world/entity/Mob;", "getMob", "()Lnet/minecraft/world/entity/Mob;", "getRangedAttackMob", "()Lnet/minecraft/world/entity/monster/RangedAttackMob;", "seeTime", "getSeeTime", "setSeeTime", "target", "Lnet/minecraft/world/entity/LivingEntity;", "getTarget", "()Lnet/minecraft/world/entity/LivingEntity;", "setTarget", "(Lnet/minecraft/world/entity/LivingEntity;)V", "canContinueToUse", "", "canUse", "requiresUpdateEveryTick", "stop", "", "tick", "immortalgingerbread-1.20.1"})
@SourceDebugExtension(value={"SMAP\nOnSiteRangedAttackGoal.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OnSiteRangedAttackGoal.kt\nnet/moddercoder/immortalgingerbread/entity/ai/goal/OnSiteRangedAttackGoal\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,100:1\n1#2:101\n*E\n"})
public final class OnSiteRangedAttackGoal
extends Goal {
    @NotNull
    private final Mob mob;
    @NotNull
    private final RangedAttackMob rangedAttackMob;
    @Nullable
    private LivingEntity target;
    private int attackTime;
    private int seeTime;
    private int attackIntervalMin;
    private int attackIntervalMax;
    private float attackRadius;

    @NotNull
    protected final Mob getMob() {
        return this.mob;
    }

    @NotNull
    protected final RangedAttackMob getRangedAttackMob() {
        return this.rangedAttackMob;
    }

    @Nullable
    protected final LivingEntity getTarget() {
        return this.target;
    }

    protected final void setTarget(@Nullable LivingEntity livingEntity) {
        this.target = livingEntity;
    }

    protected final int getAttackTime() {
        return this.attackTime;
    }

    protected final void setAttackTime(int n) {
        this.attackTime = n;
    }

    protected final int getSeeTime() {
        return this.seeTime;
    }

    protected final void setSeeTime(int n) {
        this.seeTime = n;
    }

    protected final int getAttackIntervalMin() {
        return this.attackIntervalMin;
    }

    protected final void setAttackIntervalMin(int n) {
        this.attackIntervalMin = n;
    }

    protected final int getAttackIntervalMax() {
        return this.attackIntervalMax;
    }

    protected final void setAttackIntervalMax(int n) {
        this.attackIntervalMax = n;
    }

    protected final float getAttackRadius() {
        return this.attackRadius;
    }

    protected final void setAttackRadius(float f) {
        this.attackRadius = f;
    }

    public OnSiteRangedAttackGoal(@NotNull RangedAttackMob rangedAttackMob, int attackInterval, float attackRadius) {
        Intrinsics.checkNotNullParameter((Object)rangedAttackMob, (String)"rangedAttackMob");
        this(rangedAttackMob, attackInterval, attackInterval, attackRadius);
    }

    public OnSiteRangedAttackGoal(@NotNull RangedAttackMob rangedAttackMob, int attackIntervalMin, int attackIntervalMax, float attackRadius) {
        Intrinsics.checkNotNullParameter((Object)rangedAttackMob, (String)"rangedAttackMob");
        this.attackTime = -1;
        if (!(rangedAttackMob instanceof LivingEntity)) {
            boolean bl = false;
            String string = "ArrowAttackGoal requires Mob implements RangedAttackMob";
            throw new IllegalArgumentException(string.toString());
        }
        this.attackRadius = attackRadius;
        this.mob = (Mob)rangedAttackMob;
        this.rangedAttackMob = rangedAttackMob;
        this.attackIntervalMax = attackIntervalMax;
        this.attackIntervalMin = attackIntervalMin;
        this.m_7021_(EnumSet.of((Enum)Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        LivingEntity livingEntity = this.mob.m_5448_();
        if (livingEntity == null) {
            return false;
        }
        LivingEntity targetEntity = livingEntity;
        if (targetEntity.m_6084_()) {
            this.target = targetEntity;
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean m_8045_() {
        if (this.m_8036_()) return true;
        LivingEntity livingEntity = this.target;
        Intrinsics.checkNotNull((Object)livingEntity);
        if (!livingEntity.m_6084_()) return false;
        return true;
    }

    public void m_8041_() {
        this.seeTime = 0;
        this.target = null;
        this.attackTime = -1;
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8037_() {
        LivingEntity livingEntity = this.target;
        if (livingEntity == null) {
            return;
        }
        LivingEntity targetEntity = livingEntity;
        double distance = Math.sqrt(this.mob.m_20275_(targetEntity.m_20185_(), targetEntity.m_20186_(), targetEntity.m_20189_()));
        boolean flag = this.mob.m_21574_().m_148306_((Entity)targetEntity);
        this.seeTime = flag ? ++this.seeTime : 0;
        this.mob.m_21563_().m_24960_((Entity)targetEntity, 30.0f, 30.0f);
        this.attackTime += -1;
        if (this.attackTime == 0) {
            if (!flag) {
                return;
            }
            float f = (float)distance / this.attackRadius;
            float f1 = Mth.m_14036_((float)f, (float)0.1f, (float)1.0f);
            this.rangedAttackMob.m_6504_(targetEntity, f1);
            this.attackTime = Mth.m_14143_((float)(f * (float)(this.attackIntervalMax - this.attackIntervalMin) + (float)this.attackIntervalMin));
        } else if (this.attackTime < 0) {
            this.attackTime = Mth.m_14107_((double)Mth.m_14139_((double)(distance / (double)this.attackRadius), (double)this.attackIntervalMin, (double)this.attackIntervalMax));
        }
    }
}

