/*
 * Decompiled with CFR 0.152.
 */
package net.moddercoder.immortalgingerbread.entity.ai.goal;

import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.moddercoder.immortalgingerbread.entity.IMeleeWithSpecialAttackAnimatable;
import net.moddercoder.immortalgingerbread.entity.ai.goal.AbstractAnimatedMeleeWithSpecialAttackGoal;

public class AnimatedMeleeWithChancedSpecialAttackGoal<T extends PathfinderMob>
extends AbstractAnimatedMeleeWithSpecialAttackGoal<T> {
    protected final float chanceForSpecialAttack;

    public AnimatedMeleeWithChancedSpecialAttackGoal(T mob, double speedModifier, int animationDurationTicksBeforeDamage, int animationDurationTicksAfterDamage, int attackCooldownDuration, float chanceForSpecialAttack) {
        super(mob, speedModifier, animationDurationTicksBeforeDamage, animationDurationTicksAfterDamage, attackCooldownDuration);
        this.chanceForSpecialAttack = chanceForSpecialAttack;
    }

    @Override
    protected boolean attack(LivingEntity target, double squaredDistance) {
        boolean canAttack = super.canAttack(target, squaredDistance);
        if (canAttack) {
            if (this.specialAttack) {
                ((IMeleeWithSpecialAttackAnimatable)this.mob).doSpecialMeleeAttack(target);
                this.specialAttack = false;
                return true;
            }
            return super.attack(target, squaredDistance);
        }
        return false;
    }

    @Override
    protected void startAttackingFlags() {
        this.specialAttack = this.world.f_46441_.m_188501_() <= this.chanceForSpecialAttack;
        super.startAttackingFlags();
    }
}

