/*
 * Decompiled with CFR 0.152.
 */
package net.moddercoder.immortalgingerbread.entity;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.FrostWalkerEnchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.moddercoder.immortalgingerbread.entity.ISnowmanEntity;
import net.moddercoder.immortalgingerbread.entity.projectile.SpoiledSnowballProjectileEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\b&\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u001d\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00000\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\n\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0014J\n\u0010\u0016\u001a\u0004\u0018\u00010\u0015H\u0014J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0018\u001a\u00020\u0019H\u0014J\n\u0010\u001a\u001a\u0004\u0018\u00010\u0015H\u0014J\u0010\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\u0018\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0016R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006#"}, d2={"Lnet/moddercoder/immortalgingerbread/entity/AbstractSnowmanEntity;", "Lnet/minecraft/world/entity/PathfinderMob;", "Lnet/minecraft/world/entity/monster/RangedAttackMob;", "Lnet/moddercoder/immortalgingerbread/entity/ISnowmanEntity;", "entityType", "Lnet/minecraft/world/entity/EntityType;", "world", "Lnet/minecraft/world/level/Level;", "(Lnet/minecraft/world/entity/EntityType;Lnet/minecraft/world/level/Level;)V", "despawnAtDay", "", "getDespawnAtDay", "()Z", "setDespawnAtDay", "(Z)V", "baseTick", "", "canBeLeashed", "player", "Lnet/minecraft/world/entity/player/Player;", "getAmbientSound", "Lnet/minecraft/sounds/SoundEvent;", "getDeathSound", "getHurtSound", "damageSource", "Lnet/minecraft/world/damagesource/DamageSource;", "getRangeAttackSound", "onChangedBlock", "blockPos", "Lnet/minecraft/core/BlockPos;", "performRangedAttack", "targetEntity", "Lnet/minecraft/world/entity/LivingEntity;", "strength", "", "immortalgingerbread-1.20.1"})
public abstract class AbstractSnowmanEntity
extends PathfinderMob
implements RangedAttackMob,
ISnowmanEntity {
    private boolean despawnAtDay;

    public AbstractSnowmanEntity(@NotNull EntityType<? extends AbstractSnowmanEntity> entityType, @NotNull Level world) {
        Intrinsics.checkNotNullParameter(entityType, (String)"entityType");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        super(entityType, world);
        this.despawnAtDay = true;
    }

    public final boolean getDespawnAtDay() {
        return this.despawnAtDay;
    }

    public final void setDespawnAtDay(boolean bl) {
        this.despawnAtDay = bl;
    }

    public void m_6075_() {
        super.m_6075_();
        Level world = this.m_9236_();
        if (this.despawnAtDay) {
            boolean day;
            boolean bl = day = world.m_46468_() % 24000L < 13000L;
            if (day) {
                world.m_5898_(null, 2001, this.m_20183_(), Block.m_49956_((BlockState)Blocks.f_50127_.m_49966_()));
                this.m_146870_();
                return;
            }
        }
    }

    protected void m_5806_(@NotNull BlockPos blockPos) {
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        super.m_5806_(blockPos);
        FrostWalkerEnchantment.m_45018_((LivingEntity)((LivingEntity)this), (Level)this.m_9236_(), (BlockPos)blockPos, (int)1);
    }

    public void m_6504_(@NotNull LivingEntity targetEntity, float strength) {
        SoundEvent rangeAttackSound;
        Intrinsics.checkNotNullParameter((Object)targetEntity, (String)"targetEntity");
        Level world = this.m_9236_();
        LivingEntity livingEntity = (LivingEntity)this;
        Intrinsics.checkNotNullExpressionValue((Object)world, (String)"world");
        SpoiledSnowballProjectileEntity spoiledSnowball = new SpoiledSnowballProjectileEntity(livingEntity, world);
        double targetY = targetEntity.m_20188_() - 1.1;
        double xDifference = targetEntity.m_20185_() - this.m_20185_();
        double yDifference = targetY - spoiledSnowball.m_20186_();
        double zDifference = targetEntity.m_20189_() - this.m_20189_();
        double planeDistance = Math.sqrt(Math.pow(xDifference, 2) + Math.pow(zDifference, 2)) * 0.2;
        spoiledSnowball.m_6686_(xDifference, yDifference + planeDistance, zDifference, 1.6f, 12.0f);
        if (world.m_7967_((Entity)spoiledSnowball) && (rangeAttackSound = this.getRangeAttackSound()) != null) {
            this.m_5496_(rangeAttackSound, 1.0f, 0.4f / (this.m_217043_().m_188501_() * 0.4f + 0.8f));
        }
    }

    @Nullable
    protected SoundEvent getRangeAttackSound() {
        return SoundEvents.f_12479_;
    }

    @Nullable
    protected SoundEvent m_7975_(@NotNull DamageSource damageSource) {
        Intrinsics.checkNotNullParameter((Object)damageSource, (String)"damageSource");
        return SoundEvents.f_12478_;
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return SoundEvents.f_12476_;
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return SoundEvents.f_12477_;
    }

    public boolean m_6573_(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return false;
    }
}

