/*
 * Decompiled with CFR 0.152.
 */
package net.moddercoder.immortaldroid.item;

import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.moddercoder.immortaldroid.entity.DroidEntity;
import net.moddercoder.immortaldroid.entity.ModEntityTypes;
import net.moddercoder.immortaldroid.item.ModItems;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J0\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016\u00a8\u0006\u0015"}, d2={"Lnet/moddercoder/immortaldroid/item/DroidItem;", "Lnet/minecraft/world/item/Item;", "properties", "Lnet/minecraft/world/item/Item$Properties;", "(Lnet/minecraft/world/item/Item$Properties;)V", "appendHoverText", "", "stack", "Lnet/minecraft/world/item/ItemStack;", "world", "Lnet/minecraft/world/level/Level;", "tooltip", "", "Lnet/minecraft/network/chat/Component;", "flag", "Lnet/minecraft/world/item/TooltipFlag;", "useOn", "Lnet/minecraft/world/InteractionResult;", "context", "Lnet/minecraft/world/item/context/UseOnContext;", "Companion", "immortaldroid-1.20.1"})
public final class DroidItem
extends Item {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String NBT_OWNER_NAME = "Owner";

    public DroidItem(@NotNull Item.Properties properties) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        super(properties);
    }

    @NotNull
    public InteractionResult m_6225_(@NotNull UseOnContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Player player = context.m_43723_();
        if (player == null) {
            return InteractionResult.PASS;
        }
        Player user = player;
        Level world = context.m_43725_();
        BlockPos pos = context.m_8083_();
        ItemStack stack = context.m_43722_();
        Direction faceDir = context.m_43719_();
        Object object = ModEntityTypes.INSTANCE.getDroid().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ModEntityTypes.droid.get()");
        EntityType entityType = (EntityType)object;
        Intrinsics.checkNotNullExpressionValue((Object)world, (String)"world");
        DroidEntity droid = new DroidEntity((EntityType<? extends TamableAnimal>)entityType, world);
        droid.m_20219_(pos.m_121945_(faceDir).m_252807_().m_82492_(0.0, 0.4, 0.0));
        Intrinsics.checkNotNullExpressionValue((Object)stack, (String)"stack");
        Player owner = Companion.readOwner(stack, world);
        if (!world.f_46443_) {
            if (owner != null) {
                droid.m_21828_(owner);
                BlockPos blockPos = owner.m_20183_();
                Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"owner.blockPosition()");
                DroidEntity.Companion.sitNearbyBibos(owner, world, blockPos);
                droid.m_21839_(false);
            }
            if (world.m_7967_((Entity)droid) && !user.m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
        }
        return InteractionResult.SUCCESS;
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level world, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        Player owner;
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter(tooltip, (String)"tooltip");
        Intrinsics.checkNotNullParameter((Object)flag, (String)"flag");
        super.m_7373_(stack, world, tooltip, flag);
        if (world != null && (owner = Companion.readOwner(stack, world)) != null) {
            MutableComponent mutableComponent = Component.m_237113_((String)owner.m_6302_()).m_130940_(ChatFormatting.GOLD);
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"literal(owner.scoreboard\u2026tyle(ChatFormatting.GOLD)");
            tooltip.add((Component)mutableComponent);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0018\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0007\u001a\u00020\bJ\u0018\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u000eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lnet/moddercoder/immortaldroid/item/DroidItem$Companion;", "", "()V", "NBT_OWNER_NAME", "", "hasOwner", "", "stack", "Lnet/minecraft/world/item/ItemStack;", "readOwner", "Lnet/minecraft/world/entity/player/Player;", "world", "Lnet/minecraft/world/level/Level;", "readOwnerUuid", "Ljava/util/UUID;", "writeOwnerUuid", "Lnet/minecraft/nbt/CompoundTag;", "ownerUuid", "immortaldroid-1.20.1"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final CompoundTag writeOwnerUuid(@NotNull ItemStack stack, @NotNull UUID ownerUuid) {
            Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
            Intrinsics.checkNotNullParameter((Object)ownerUuid, (String)"ownerUuid");
            if (!stack.m_150930_((Item)ModItems.INSTANCE.getDroidItem().get())) {
                return null;
            }
            CompoundTag tag = stack.m_41784_();
            tag.m_128362_(DroidItem.NBT_OWNER_NAME, ownerUuid);
            return tag;
        }

        public final boolean hasOwner(@NotNull ItemStack stack) {
            Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
            if (!stack.m_150930_((Item)ModItems.INSTANCE.getDroidItem().get())) {
                return false;
            }
            CompoundTag tag = stack.m_41783_();
            return tag != null && tag.m_128403_(DroidItem.NBT_OWNER_NAME);
        }

        @Nullable
        public final UUID readOwnerUuid(@NotNull ItemStack stack) {
            UUID uUID;
            Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
            if (this.hasOwner(stack)) {
                CompoundTag compoundTag = stack.m_41783_();
                Intrinsics.checkNotNull((Object)compoundTag);
                uUID = compoundTag.m_128342_(DroidItem.NBT_OWNER_NAME);
            } else {
                uUID = null;
            }
            return uUID;
        }

        @Nullable
        public final Player readOwner(@NotNull ItemStack stack, @NotNull Level world) {
            Player owner;
            Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
            Intrinsics.checkNotNullParameter((Object)world, (String)"world");
            if (!this.hasOwner(stack)) {
                return null;
            }
            UUID ownerUuid = this.readOwnerUuid(stack);
            if (ownerUuid != null && (owner = world.m_46003_(ownerUuid)) != null) {
                return owner;
            }
            return null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

