/*
 * Decompiled with CFR 0.152.
 */
package net.moddercoder.immortaldroid.entity.ai.goal;

import java.util.EnumSet;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.moddercoder.immortaldroid.ImmortalDroid;
import net.moddercoder.immortaldroid.entity.DroidEntity;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lnet/moddercoder/immortaldroid/entity/ai/goal/ShowStructureGoal;", "Lnet/minecraft/world/entity/ai/goal/Goal;", "droid", "Lnet/moddercoder/immortaldroid/entity/DroidEntity;", "(Lnet/moddercoder/immortaldroid/entity/DroidEntity;)V", "getDroid", "()Lnet/moddercoder/immortaldroid/entity/DroidEntity;", "canUse", "", "start", "", "immortaldroid-1.20.1"})
public final class ShowStructureGoal
extends Goal {
    @NotNull
    private final DroidEntity droid;

    public ShowStructureGoal(@NotNull DroidEntity droid) {
        Intrinsics.checkNotNullParameter((Object)((Object)droid), (String)"droid");
        this.droid = droid;
        this.m_7021_(EnumSet.of((Enum)Goal.Flag.LOOK, (Enum)Goal.Flag.MOVE));
    }

    @NotNull
    public final DroidEntity getDroid() {
        return this.droid;
    }

    public boolean m_8036_() {
        return this.droid.isShowingStructure();
    }

    public void m_8056_() {
        this.droid.m_6862_(false);
        this.droid.m_21573_().m_26573_();
        Level world = this.droid.m_9236_();
        MinecraftServer server = world.m_7654_();
        if (server != null && world instanceof ServerLevel) {
            Vec3 structurePos;
            BlockPos blockPos = ((ServerLevel)world).m_215011_(this.droid.getShowStructureTag(), this.droid.m_20183_(), 100, false);
            Vec3 vec3 = structurePos = blockPos != null ? blockPos.m_252807_() : null;
            if (structurePos != null) {
                this.droid.triggerAnim("controller", "showDirection");
                Logger logger = ImmortalDroid.INSTANCE.getDevLogger();
                if (logger != null) {
                    logger.info("Structure has been founded at: [" + structurePos.f_82479_ + ", " + structurePos.f_82480_ + ", " + structurePos.f_82481_ + "]");
                }
                float angle = (float)Mth.m_14136_((double)(this.droid.m_20185_() - structurePos.f_82479_), (double)(structurePos.f_82481_ - this.droid.m_20189_())) * 57.295776f;
                this.droid.m_146922_(angle);
                this.droid.f_19859_ = angle;
                this.droid.m_5618_(angle);
                this.droid.f_20884_ = angle;
                this.droid.m_5616_(angle);
                this.droid.f_20886_ = angle;
            } else {
                LivingEntity owner = this.droid.m_269323_();
                if (owner != null && owner instanceof Player) {
                    Object[] objectArray = new Object[]{""};
                    ((Player)owner).m_5661_((Component)Component.m_237110_((String)"commands.locate.structure.not_found", (Object[])objectArray).m_130940_(ChatFormatting.RED), true);
                }
            }
        }
    }
}

