/*
 * Decompiled with CFR 0.152.
 */
package net.moddercoder.immortaldroid.entity.ai.goal;

import com.mojang.datafixers.util.Pair;
import java.util.EnumSet;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.moddercoder.immortaldroid.ImmortalDroid;
import net.moddercoder.immortaldroid.entity.DroidEntity;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lnet/moddercoder/immortaldroid/entity/ai/goal/ShowBiomeGoal;", "Lnet/minecraft/world/entity/ai/goal/Goal;", "droid", "Lnet/moddercoder/immortaldroid/entity/DroidEntity;", "(Lnet/moddercoder/immortaldroid/entity/DroidEntity;)V", "getDroid", "()Lnet/moddercoder/immortaldroid/entity/DroidEntity;", "canUse", "", "start", "", "immortaldroid-1.20.1"})
public final class ShowBiomeGoal
extends Goal {
    @NotNull
    private final DroidEntity droid;

    public ShowBiomeGoal(@NotNull DroidEntity droid) {
        Intrinsics.checkNotNullParameter((Object)((Object)droid), (String)"droid");
        this.droid = droid;
        this.m_7021_(EnumSet.of((Enum)Goal.Flag.LOOK, (Enum)Goal.Flag.MOVE));
    }

    @NotNull
    public final DroidEntity getDroid() {
        return this.droid;
    }

    public boolean m_8036_() {
        return this.droid.isShowingBiome();
    }

    public void m_8056_() {
        this.droid.m_6862_(false);
        this.droid.m_21573_().m_26573_();
        Level world = this.droid.m_9236_();
        MinecraftServer server = world.m_7654_();
        if (server != null && world instanceof ServerLevel) {
            Pair pair = ((ServerLevel)world).m_215069_(arg_0 -> ShowBiomeGoal.start$lambda$0(this, arg_0), this.droid.m_20183_(), 6400, 32, 64);
            if (pair != null) {
                this.droid.triggerAnim("controller", "showDirection");
                BlockPos biomePos = (BlockPos)pair.getFirst();
                Logger logger = ImmortalDroid.INSTANCE.getDevLogger();
                if (logger != null) {
                    logger.info("Structure has been founded at: [" + biomePos.m_123341_() + ", " + biomePos.m_123342_() + ", " + biomePos.m_123343_() + "]");
                }
                float angle = (float)Mth.m_14136_((double)(this.droid.m_20185_() - (double)biomePos.m_123341_()), (double)((double)biomePos.m_123343_() - this.droid.m_20189_())) * 57.295776f;
                this.droid.m_146922_(angle);
                this.droid.f_19859_ = angle;
                this.droid.m_5618_(angle);
                this.droid.f_20884_ = angle;
                this.droid.m_5616_(angle);
                this.droid.f_20886_ = angle;
            } else {
                LivingEntity owner = this.droid.m_269323_();
                if (owner != null && owner instanceof Player) {
                    Object[] objectArray = new Object[]{""};
                    ((Player)owner).m_5661_((Component)Component.m_237110_((String)"commands.locate.biome.not_found", (Object[])objectArray).m_130940_(ChatFormatting.RED), true);
                }
            }
        }
    }

    private static final boolean start$lambda$0(ShowBiomeGoal this$0, Holder biomeHolder) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        return biomeHolder.m_203656_(this$0.droid.getShowingBiomeTag());
    }
}

